=begin
(c) 2013, Renderiza Studio

Permission to use, copy, modify, and distribute this software for
any purpose and without fee is hereby granted, provided the above
copyright notice appear in all copies.

THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

== Information
Author:: Renderiza
Name:: GOSU
Version:: 1.1.1
SU Version:: 2013
Date:: 10/21/2013
Description:: Link components to websites, proxy, layers, scenes, sounds, files and folders.
=end

module RND_Extensions

	module RND_GOSU
		require 'sketchup.rb'
		require 'RND_GOSU/RND_GOSU_loader.rb'
	end

	if !file_loaded?('rnd_menu_loader')
		@@rnd_tools_menu = UI.menu("Plugins").add_submenu("Renderiza Tools")
	end

	#------New menu Items---------------------------
	if !file_loaded?('rnd_ew_loader')
		@@rnd_ew_menu = @@rnd_tools_menu.add_submenu("Websites")
		@@rnd_ew_menu.add_separator
		@@rnd_ew_menu.add_item("PluginStore"){UI.openURL('http://sketchucation.com/resources/pluginstore?pauthor=renderiza')}
		@@rnd_ew_menu.add_item("Extension Warehouse"){UI.openURL('http://extensions.sketchup.com/en/user/5451/store')}
		@@rnd_tools_menu.add_separator
		@@rnd_ew_menu.add_separator
	end
	#------------------------------------------------
	if !file_loaded?(__FILE__) then
		@@rnd_tools_menu.add_item('GOSU') {
		Sketchup.active_model.select_tool RND_Extensions::RND_GOSU::GOSU.new
		}
		# Add toolbar
		rnd_gosu_tb = UI::Toolbar.new "GOSU"
		rnd_gosu_cmd = UI::Command.new("GOSU") {
		Sketchup.active_model.select_tool RND_Extensions::RND_GOSU::GOSU.new
		}
		rnd_gosu_cmd.small_icon = "images/rnd_gosu_1_16.png"
		rnd_gosu_cmd.large_icon = "images/rnd_gosu_1_24.png"
		rnd_gosu_cmd.tooltip = "GOSU"
		rnd_gosu_cmd.status_bar_text = "Link components to websites, proxy, layers, scenes, sounds, files and folders."
		rnd_gosu_cmd.menu_text = "GOSU"
		rnd_gosu_tb = rnd_gosu_tb.add_item rnd_gosu_cmd
		rnd_gosu_tb.show
		
		
		# Add Context Menu
		UI.add_context_menu_handler{|menu|

			rclick_menu  = menu.add_submenu("GOSU")
			rclick_menu.add_item('GOSU'){
				model = Sketchup.active_model ;
				pages = model.pages ;			
				@@sel = Sketchup.active_model.selection[0] ;

				if @@sel.name[-4..-1] != ".wav" #Don't Run if file is "*.wav"
					UI.openURL("#{@@sel.name}") ;
				end ;
				
				#----------------------------
				#Play Sound
				#----------------------------
				@sound_wav = @@sel.name ;
				if @@sel.name[-4..-1] == ".wav"
				UI.play_sound @sound_wav ;
				end ;
				
				#----------------------------	
				#Go:: Scene	
				#----------------------------
				rm1 = @@sel.name ;
				page_num = 0 ;
				if @@sel.name 
					pages.each do |e|
					  if e.name == rm1
						pages.selected_page = model.pages[page_num] ;
						break
					  end ;
					  page_num+=1 ;
					end ;
				end	;
				
				#----------------------------	
				#Go:: Layer	
				#----------------------------
				model.active_layer = @@sel.name ;
			}
			
			rclick_menu.add_separator ;
			
			rclick_menu.add_item('Set:: Name'){
				@@sel = Sketchup.active_model.selection[0] ;
				results = inputbox(["Enter Name:"], [@@sel.name], "Set:: NAME") ;
				return if !results
				@@sel.name = results[0] ;
			}
			
			rclick_menu.add_item('Set:: URL'){
				@@sel = Sketchup.active_model.selection[0] ;
				results = inputbox(["Enter URL:"], [@@sel.name], "Set:: URL") ;
				return if !results
				@@sel.name = results[0] ;
			}
			
			#----------------------------
			#Set::Proxy
			#----------------------------
				model = Sketchup.active_model ;
				allsel = model.selection ;
				sel = model.selection[0] ;
				defm = model.definitions ;
				defs = sel.definition ;
				defn = defs.name ;
				
					if allsel.length and sel.kind_of?(Sketchup::ComponentInstance)			

						rclick_menu.add_item("Set::Proxy(Box)") { 
							if defn[-7..-1] != "::proxy"
								proxy = defm[defn + "::proxy"] ;
								unless proxy
									proxy = defm.add(defn + "::proxy") ;
									pts = [] ;
									for i in 0..8
										pts.push Geom::Point3d.new((i & 1)!=0 ? defs.bounds.min.x : defs.bounds.max.x,
																	(i & 2)!=0 ? defs.bounds.min.y : defs.bounds.max.y,
																	(i & 4)!=0 ? defs.bounds.min.z : defs.bounds.max.z)
									end

									faces = [
									[ pts[0], pts[1], pts[3], pts[2] ],
									[ pts[4], pts[5], pts[7], pts[6] ],
									[ pts[0], pts[1], pts[5], pts[4] ],
									[ pts[3], pts[2], pts[6], pts[7] ],
									[ pts[1], pts[3], pts[7], pts[5] ],
									[ pts[2], pts[0], pts[4], pts[6] ]
									]
									
									faces.each { |face|
									proxy.entities.add_face( face ) ;
									color=proxy.entities.add_face( face ) ;
									color.material = [255, 101, 101] ;
									color.back_material = [255, 101, 101] ;
									}
								end ;#unless
								
								# and replace
								model.start_operation("Set::Proxy(Box)")
								allsel.each {|s|
									s.definition = proxy if s.kind_of?(Sketchup::ComponentInstance) and s.definition == defs
								}
								model.commit_operation
							else	
								proxy = defs ;
								defs = defm[proxy.name[0...-7]] ;
								if defs
									model.start_operation("No::Proxy(Box)") ;
									allsel.each {|s|
										s.definition = defs if s.kind_of?(Sketchup::ComponentInstance) and s.definition == proxy 
									}
									model.commit_operation
								end ;
							
							end ;
						}
									
						rclick_menu.add_item("Set::Proxy(Cline)") { 
							if defn[-7..-1] != "::proxy"	
								proxy = defm[defn + "::proxy"] ;
								unless proxy
									proxy = defm.add(defn + "::proxy") ;
									pts = [] ;
									for i in 0..8
										pts.push Geom::Point3d.new((i & 1)!=0 ? defs.bounds.min.x : defs.bounds.max.x,
																	   (i & 2)!=0 ? defs.bounds.min.y : defs.bounds.max.y,
																	   (i & 4)!=0 ? defs.bounds.min.z : defs.bounds.max.z)
									end ;
										faces = [
										[ pts[0], pts[1] ],
										[ pts[1], pts[3] ],
										[ pts[3], pts[2] ],
										[ pts[2], pts[0] ],
										
										[ pts[4], pts[5] ],
										[ pts[5], pts[7] ],
										[ pts[7], pts[6] ],
										[ pts[6], pts[4] ],
										
										[ pts[0], pts[4] ],
										[ pts[1], pts[5] ],
										[ pts[2], pts[6] ],
										[ pts[3], pts[7] ]
										]	
										
										faces.each { |face|
										proxy.entities.add_cline( face[0], face[1] ) ;
										}
								end ;#unless
								
								# and replace
								model.start_operation("Set::Proxy(Cline)")
								allsel.each {|s|
									s.definition = proxy if s.kind_of?(Sketchup::ComponentInstance) and s.definition == defs
								}
								model.commit_operation
							else
								proxy = defs
								defs = defm[proxy.name[0...-7]] ;
								if defs
									model.start_operation("No::Proxy(Cline)")
									allsel.each {|s|
										s.definition = defs if s.kind_of?(Sketchup::ComponentInstance) and s.definition == proxy
									}
									model.commit_operation
								end ;
							end	;
						}
					end ;
					
			
				ents = model.active_entities ; 
				instances = [] ;
				
				rclick_menu.add_item("Set::Proxy(Instances)") { 
					ents.each do |e|
						if e.is_a? Sketchup::ComponentInstance
								instances << e
						end ;
					end ;
					
					instances.each do |e|
						if e.definition.name == defn
								allsel.add e        
						end	;
					end ;
				
					if allsel.length and sel.kind_of?(Sketchup::ComponentInstance)			
						if defn[-7..-1] != "::proxy"
							proxy = defm[defn + "::proxy"] ;
							unless proxy
								proxy = defm.add(defn + "::proxy") ;
								pts = [] ;
								for i in 0..8
									pts.push Geom::Point3d.new((i & 1)!=0 ? defs.bounds.min.x : defs.bounds.max.x,
																   (i & 2)!=0 ? defs.bounds.min.y : defs.bounds.max.y,
																   (i & 4)!=0 ? defs.bounds.min.z : defs.bounds.max.z)
								end ;
								faces = [
								[ pts[0], pts[1], pts[3], pts[2] ],
								[ pts[4], pts[5], pts[7], pts[6] ],
								[ pts[0], pts[1], pts[5], pts[4] ],
								[ pts[3], pts[2], pts[6], pts[7] ],
								[ pts[1], pts[3], pts[7], pts[5] ],
								[ pts[2], pts[0], pts[4], pts[6] ]
								]	
								faces.each { |face|
								proxy.entities.add_face( face ) ;
								color=proxy.entities.add_face( face ) ;
								color.material = [255, 101, 101] ;
								color.back_material = [255, 101, 101] ;
								}
							end ;#unless
						
							# and replace
							model.start_operation("Set:: Proxy")
							allsel.each {|s|
								s.definition = proxy if s.kind_of?(Sketchup::ComponentInstance) and s.definition == defs
							}
							model.commit_operation	
						else
							proxy = defs
							defs = defm[proxy.name[0...-7]]
							if defs
								model.start_operation("No:: Proxy")
								allsel.each {|s|
									s.definition = defs if s.kind_of?(Sketchup::ComponentInstance) and s.definition == proxy
								}
								model.commit_operation
							end	;
						end ;
					end	;
							
				}	
							
			rclick_menu.add_item('Set:: Scene'){
				model = Sketchup.active_model ;
				pages = model.pages ;			
				@@sel = Sketchup.active_model.selection[0] ;
				results = inputbox(["Enter Scene Name:"], [@@sel.name], "Set:: SCENE")
				return if !results
				@@sel.name = results[0] ;
				pages.add results[0] ;
			}
			
			rclick_menu.add_item('Set:: Layer'){
				model = Sketchup.active_model ;		
				layers = model.layers ;
				@@sel = Sketchup.active_model.selection[0] ;
				@@sel.definition.name ;
				results = inputbox(["Enter Layer Name:"], [@@sel.name], "Set:: LAYER")
				return if !results
				@@sel.name = results[0] ;
				layers.add results[0] ;
				layer = Sketchup.active_model.layers.add results[0] ;
				@@sel.layer = results[0] ;
			}
			
			rclick_menu.add_item('Set:: Sound'){
				@@sel = Sketchup.active_model.selection[0] ;
				title = "Choose a sound file"
				filepath = UI.openpanel( title, "*.wav" ) ;
				if filepath
					@sound = filepath.gsub("\\",'/') ;
				else
					return nil
				end ;
				@@sel.name = @sound ;			
			}
			
			rclick_menu.add_item('Set:: Files'){
				@@sel = Sketchup.active_model.selection[0] ;
				title = "Choose a file" ;
				filepath = UI.openpanel( title, "") ;
				if filepath
					@file = filepath.gsub("\\",'/') ;
				else
					return nil
				end ;
				@@sel.name = @file ;	
			}
			
			rclick_menu.add_item('Set:: Folder'){
				@@sel = Sketchup.active_model.selection[0] ;
				title = "Choose a folder" ;
				filepath = UI.openpanel( title, "" ) ;
				if filepath
					file_path = filepath.gsub("\\",'/') ;
					@folder = File.dirname(file_path) ;
				else
					return nil
				end ;
				@@sel.name = @folder ;
			}
			
			rclick_menu.add_item('Set:: Empty'){
				@@sel = Sketchup.active_model.selection[0] ;
				@@sel.name = "" ;
				UI.beep ;
			}

			rclick_menu.add_separator	
			
			rclick_menu.add_item('::Gosu Files::'){
				@@dir = File.dirname(__FILE__) ;# this plugin's folder
				@@gosu_files = File.join(@@dir, '/GOSUFiles/') ;
				UI.openURL(@@gosu_files) ;
			}
		}


	end

	file_loaded('rnd_ew_loader')
	file_loaded('rnd_menu_loader')
	file_loaded(__FILE__)
end