/*
 * Decompiled with CFR 0.152.
 */
package kexts;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class ETable
extends JTable {
    public ETable() {
        this.setShowVerticalLines(false);
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.paintEmptyRows(g);
    }

    protected void paintEmptyRows(Graphics g) {
        int rowCount = this.getRowCount();
        Rectangle clip = g.getClipBounds();
        if (rowCount * this.rowHeight < clip.height) {
            for (int i = rowCount; i <= clip.height / this.rowHeight; ++i) {
                g.setColor(this.colorForRow(i));
                g.fillRect(clip.x, i * this.rowHeight, clip.width, this.rowHeight);
            }
        }
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            JViewport parent = (JViewport)this.getParent();
            return parent.getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    protected Color colorForRow(int row) {
        return row % 2 == 0 ? new Color(15791611) : this.getBackground();
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        if (!this.isCellSelected(row, column)) {
            c.setBackground(this.colorForRow(row));
            c.setForeground(UIManager.getColor("Table.foreground"));
        } else {
            c.setBackground(UIManager.getColor("Table.selectionBackground"));
            c.setForeground(UIManager.getColor("Table.selectionForeground"));
        }
        return c;
    }
}

