/*
 * Decompiled with CFR 0.152.
 */
package kexts;

import comm.FileStream;
import comm.HttpUpdateTable;
import comm.HttpUpload;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import kexts.ETable;
import kexts.KextTableImageModel;
import kexts.KextTableModel;
import kexts.KextsAbout;
import kexts.KextsApp;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;
import parser.IORegParser;
import parser.LsPciParser;
import parser.RegParser;

public class KextsView
extends FrameView
implements ClipboardOwner {
    private JPopupMenu popupKext;
    private JPopupMenu popupDevice;
    private IORegParser ior;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JPopupMenu jPopupMenu1;
    private JPopupMenu jPopupMenu2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;
    private JTable jTable2;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JProgressBar progressBar;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;

    public KextsView(SingleFrameApplication app) {
        super((Application)app);
        this.initComponents();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KextsView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KextsView.this.busyIconIndex = (KextsView.this.busyIconIndex + 1) % KextsView.this.busyIcons.length;
                KextsView.this.statusAnimationLabel.setIcon(KextsView.this.busyIcons[KextsView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!KextsView.this.busyIconTimer.isRunning()) {
                        KextsView.this.statusAnimationLabel.setIcon(KextsView.this.busyIcons[0]);
                        KextsView.this.busyIconIndex = 0;
                        KextsView.this.busyIconTimer.start();
                    }
                    KextsView.this.progressBar.setVisible(true);
                    KextsView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    KextsView.this.busyIconTimer.stop();
                    KextsView.this.statusAnimationLabel.setIcon(KextsView.this.idleIcon);
                    KextsView.this.progressBar.setVisible(false);
                    KextsView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    KextsView.this.statusMessageLabel.setText(text == null ? "" : text);
                    KextsView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    KextsView.this.progressBar.setVisible(true);
                    KextsView.this.progressBar.setIndeterminate(false);
                    KextsView.this.progressBar.setValue(value);
                }
            }
        });
        this.createPopup();
        KextTableModel dtm = new KextTableModel((Object[][])new Object[0][], new String[]{"Works?", "Kext name", "Version", "Device", "Class ID"});
        TableRowSorter<DefaultTableModel> sorter = new TableRowSorter<KextTableModel>(dtm);
        this.jTable1 = new ETable();
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jTable1.setModel(dtm);
        this.jTable1.setRowSorter(sorter);
        this.jTable1.setComponentPopupMenu(this.popupKext);
        KextTableImageModel model = new KextTableImageModel((Object[][])new Object[0][], new String[]{" ", "Ven ID", "Vendor", "Dev ID", "Device", "Class", "Subclass"});
        sorter = new TableRowSorter<KextTableImageModel>(model);
        this.jTable2 = new ETable();
        this.jScrollPane2.setViewportView(this.jTable2);
        this.jTable2.setModel(model);
        this.jTable2.setRowSorter(sorter);
        this.jTable2.setComponentPopupMenu(this.popupDevice);
        TableColumn column = this.jTable1.getColumnModel().getColumn(1);
        column.setPreferredWidth(350);
        column = this.jTable1.getColumnModel().getColumn(3);
        column.setPreferredWidth(350);
        column = this.jTable1.getColumnModel().getColumn(0);
        column.setPreferredWidth(50);
        column = this.jTable2.getColumnModel().getColumn(4);
        column.setPreferredWidth(300);
        column = this.jTable2.getColumnModel().getColumn(1);
        column.setPreferredWidth(50);
        column = this.jTable2.getColumnModel().getColumn(0);
        column.setPreferredWidth(20);
        column = this.jTable2.getColumnModel().getColumn(3);
        column.setPreferredWidth(50);
        String s = System.getProperty("os.name").toLowerCase();
        if (s.indexOf("linux") != -1) {
            this.jTabbedPane1.setEnabledAt(1, false);
            LsPciParser ior = new LsPciParser(this);
            ior.setKextsTable(this.jTable1);
            ior.setDevicesTable(this.jTable2);
            Thread t = new Thread(ior);
            t.start();
        } else if (s.indexOf("windows") != -1) {
            this.jTabbedPane1.setEnabledAt(1, false);
            RegParser ior = new RegParser(this);
            ior.setKextsTable(this.jTable1);
            ior.setDevicesTable(this.jTable2);
            Thread t = new Thread(ior);
            t.start();
        } else {
            this.ior = new IORegParser(this);
            this.ior.setKextsTable(this.jTable1);
            this.ior.setDevicesTable(this.jTable2);
            Thread t = new Thread(this.ior);
            t.start();
        }
    }

    @Action
    public void checkCompatibility() {
        HttpUpdateTable upd = new HttpUpdateTable(this, (KextTableImageModel)this.jTable2.getModel());
        Thread t = new Thread(upd);
        t.start();
    }

    public void startLoad() {
        if (!this.busyIconTimer.isRunning()) {
            this.statusAnimationLabel.setIcon(this.busyIcons[0]);
            this.busyIconIndex = 0;
            this.busyIconTimer.start();
        }
        this.progressBar.setVisible(true);
        this.progressBar.setIndeterminate(true);
    }

    public void setMaximumLoadValue(int value) {
        this.progressBar.setMaximum(value);
    }

    public void setLoadValue(int value) {
        if (!this.busyIconTimer.isRunning()) {
            this.statusAnimationLabel.setIcon(this.busyIcons[0]);
            this.busyIconIndex = 0;
            this.busyIconTimer.start();
        }
        this.progressBar.setVisible(true);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(value);
    }

    public void stopLoad() {
        this.busyIconTimer.stop();
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        this.progressBar.setValue(0);
    }

    public void toogleMenus(boolean menu1, boolean menu2, boolean menu3, boolean menu4) {
        this.jMenuItem1.setEnabled(menu1);
        this.jMenuItem2.setEnabled(menu2);
        this.jMenuItem3.setEnabled(menu3);
        this.jMenuItem4.setEnabled(menu4);
    }

    private void createPopup() {
        this.popupKext = new JPopupMenu();
        ActionListener menuListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if ("Copy kext to clipboard".equals(event.getActionCommand())) {
                    StringSelection ss = new StringSelection(KextsView.this.getSelectedData(KextsView.this.jTable1));
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, KextsView.this);
                } else if ("Copy device to clipboard".equals(event.getActionCommand())) {
                    StringSelection ss = new StringSelection(KextsView.this.getSelectedData(KextsView.this.jTable2));
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, KextsView.this);
                }
            }
        };
        JMenuItem item = new JMenuItem("Copy kext to clipboard");
        this.popupKext.add(item);
        item.setHorizontalTextPosition(0);
        item.addActionListener(menuListener);
        this.popupDevice = new JPopupMenu();
        item = new JMenuItem("Copy device to clipboard");
        this.popupDevice.add(item);
        item.setHorizontalTextPosition(0);
        item.addActionListener(menuListener);
    }

    private int getSelectedCount() {
        int count = 0;
        KextTableModel model = (KextTableModel)this.jTable1.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            try {
                Boolean b = (Boolean)model.getValueAt(i, 0);
                if (!b.booleanValue()) continue;
                ++count;
                continue;
            }
            catch (ClassCastException ex) {
                // empty catch block
            }
        }
        return count;
    }

    @Action
    public void transmitData() {
        int n = JOptionPane.showConfirmDialog(this.getFrame(), "You are about to send kexts information for " + this.getSelectedCount() + " kexts\n" + "and related device IDs to our server. Please unmark those kexts which are\n" + "related to non-working devices. Do you confirm?", "Confirm please", 0);
        if (n == 0) {
            HttpUpload up = new HttpUpload(this, this.ior.getPostContentData((KextTableModel)this.jTable1.getModel()));
            Thread t = new Thread(up);
            t.start();
        }
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = KextsApp.getApplication().getMainFrame();
            this.aboutBox = new KextsAbout(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        KextsApp.getApplication().show(this.aboutBox);
    }

    @Action
    public void exportKexts() {
        File a = this.promptForFile();
        if (a != null) {
            this.exportTableData(this.jTable1, a.getAbsolutePath());
        }
    }

    @Action
    public void exportDevices() {
        File a = this.promptForFile();
        if (a != null) {
            this.exportTableData(this.jTable2, a.getAbsolutePath());
        }
    }

    private String getSelectedData(JTable table) {
        String line = "";
        KextTableModel model = (KextTableModel)table.getModel();
        int[] selection = table.getSelectedRows();
        if (selection != null) {
            for (int i = 0; i < selection.length; ++i) {
                for (int j = 0; j < model.getColumnCount() - 1; ++j) {
                    try {
                        String tmp = (String)model.getValueAt(selection[i], j);
                        line = line.concat(tmp + ";");
                        continue;
                    }
                    catch (ClassCastException ex) {
                        // empty catch block
                    }
                }
                line = line.concat((String)model.getValueAt(selection[i], model.getColumnCount() - 1) + "\n");
            }
        }
        return line;
    }

    private void exportTableData(JTable table, String file) {
        FileStream fs = new FileStream(file);
        String line = "";
        KextTableModel model = (KextTableModel)table.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            line = "";
            for (int j = 0; j < model.getColumnCount() - 1; ++j) {
                line = line.concat((String)model.getValueAt(i, j) + ";");
            }
            line = line.concat((String)model.getValueAt(i, model.getColumnCount() - 1) + "\n");
            fs.writeLine(line);
        }
        fs.save();
    }

    private File promptForFile() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogType(1);
        int returnVal = fc.showSaveDialog(null);
        if (returnVal == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane2 = new JScrollPane();
        this.jTable2 = new JTable();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem4 = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.jPopupMenu1 = new JPopupMenu();
        this.jPopupMenu2 = new JPopupMenu();
        this.mainPanel.setName("mainPanel");
        this.jTabbedPane1.setName("jTabbedPane1");
        this.jScrollPane2.setName("jScrollPane2");
        this.jTable2.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTable2.setName("jTable2");
        this.jScrollPane2.setViewportView(this.jTable2);
        this.jTabbedPane1.addTab("Devices", this.jScrollPane2);
        this.jScrollPane1.setName("jScrollPane1");
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTable1.setName("jTable1");
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jTabbedPane1.addTab("Kexts", null, this.jScrollPane1, "Kext / device relations");
        ResourceMap resourceMap = ((KextsApp)Application.getInstance(KextsApp.class)).getContext().getResourceMap(KextsView.class);
        this.jScrollPane1.getAccessibleContext().setAccessibleName(resourceMap.getString("jScrollPane1.AccessibleContext.accessibleName", new Object[0]));
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 800, Short.MAX_VALUE));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, GroupLayout.Alignment.TRAILING, -1, 391, Short.MAX_VALUE));
        this.jTabbedPane1.getAccessibleContext().setAccessibleName(resourceMap.getString("jTabbedPane1.AccessibleContext.accessibleName", new Object[0]));
        this.jTabbedPane1.getAccessibleContext().setAccessibleDescription(resourceMap.getString("jTabbedPane1.AccessibleContext.accessibleDescription", new Object[0]));
        this.menuBar.setName("menuBar");
        fileMenu.setText("File");
        fileMenu.setName("fileMenu");
        ApplicationActionMap actionMap = ((KextsApp)Application.getInstance(KextsApp.class)).getContext().getActionMap(KextsView.class, (Object)this);
        this.jMenuItem1.setAction(actionMap.get("exportKexts"));
        this.jMenuItem1.setText(resourceMap.getString("Textos.menu1", new Object[0]));
        this.jMenuItem1.setName("jMenuItem1");
        fileMenu.add(this.jMenuItem1);
        this.jMenuItem2.setAction(actionMap.get("exportDevices"));
        this.jMenuItem2.setText(resourceMap.getString("Textos.menu2", new Object[0]));
        this.jMenuItem2.setName("jMenuItem2");
        fileMenu.add(this.jMenuItem2);
        this.jMenuItem3.setAction(actionMap.get("transmitData"));
        this.jMenuItem3.setText(resourceMap.getString("Textos.menu3", new Object[0]));
        this.jMenuItem3.setName("jMenuItem3");
        fileMenu.add(this.jMenuItem3);
        this.jMenuItem4.setAction(actionMap.get("checkCompatibility"));
        this.jMenuItem4.setText(resourceMap.getString("Textos.menu4", new Object[0]));
        this.jMenuItem4.setName("jMenuItem4");
        fileMenu.add(this.jMenuItem4);
        this.jSeparator1.setName("jSeparator1");
        fileMenu.add(this.jSeparator1);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText("Help");
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 800, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 604, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.jPopupMenu1.setName("jPopupMenu1");
        this.jPopupMenu2.setName("jPopupMenu2");
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    public void lostOwnership(Clipboard arg0, Transferable arg1) {
    }
}

