/*
 * Decompiled with CFR 0.152.
 */
package parser;

import data.KextCollection;
import data.KextData;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import kexts.KextTableModel;
import kexts.KextsView;
import parser.KextStatParser;
import pciids.Classe;
import pciids.Device;
import pciids.PciIdsParser;
import pciids.Subclasse;
import pciids.Vendor;

public class IORegParser
implements Runnable {
    public static String IOREG_COMMAND = "ioreg -l -w 0";
    private KextCollection kc;
    private String data = "";
    private int datalevel;
    private Pattern bundle = Pattern.compile("\"CFBundleIdentifier\" = \"([^\"]+)\"");
    private Pattern device = Pattern.compile("\"device-id\" = <(....)0000>");
    private Pattern vendor = Pattern.compile("\"vendor-id\" = <(....)0000>");
    private Pattern pciclass = Pattern.compile("\"pciclass,(....)..\"");
    private Pattern iopciclassmatch = Pattern.compile("\"IOPCIClassMatch\" = \"0x(....)[^\"]+\"");
    private JTable tableKexts;
    private JTable tableDevices;
    private KextsView parent;
    private PciIdsParser pciids;
    private KextStatParser stat;

    public IORegParser(KextsView kv) {
        this.kc = new KextCollection();
        this.parent = kv;
    }

    public void run() {
        this.parent.startLoad();
        this.parent.toogleMenus(false, false, false, false);
        this.pciids = new PciIdsParser();
        this.pciids.run();
        this.stat = new KextStatParser();
        this.stat.parse();
        this.parseKextDevice();
        this.parent.toogleMenus(true, true, true, true);
        this.parent.stopLoad();
    }

    public String getPostContentData(KextTableModel model) {
        String buf = "";
        for (int i = 0; i < model.getRowCount(); ++i) {
            try {
                KextData kd;
                Boolean b = (Boolean)model.getValueAt(i, 0);
                if (!b.booleanValue() || (kd = this.getKext((String)model.getValueAt(i, 1), (String)model.getValueAt(i, 2))) == null) continue;
                buf = buf.concat(kd.toString() + "\n");
                continue;
            }
            catch (ClassCastException ex) {
                // empty catch block
            }
        }
        return buf;
    }

    public KextData getKext(String name, String version) {
        for (int i = 0; i < this.kc.size(); ++i) {
            KextData kd = (KextData)this.kc.get(i);
            if (!kd.getKextName().equalsIgnoreCase(name) || !version.equalsIgnoreCase(kd.getVersion())) continue;
            return kd;
        }
        return null;
    }

    public void parseKextDevice() {
        String block = "";
        try {
            String line;
            Pattern startBlock = Pattern.compile("^\\s*(\\s*\\|\\s*)*\\}\\s*$");
            Pattern endBlock = Pattern.compile("^\\s*(\\s*\\|\\s*)*\\{\\s*$");
            Process p = Runtime.getRuntime().exec(IOREG_COMMAND);
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                Matcher mat = startBlock.matcher(line);
                if (mat.find() && block.length() > 0) {
                    if (this.data.length() > 0 && this.getLevel(block) < this.datalevel) {
                        this.data = "";
                        this.datalevel = 0;
                    }
                    this.parseBlock(block);
                    continue;
                }
                mat = endBlock.matcher(line);
                if (mat.find()) {
                    block = "";
                    continue;
                }
                block = block.concat(line.concat("\n"));
            }
            input.close();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    private void parseBlock(String block) {
        Matcher m = this.bundle.matcher(block);
        URL lURL = this.getClass().getResource("/search.png");
        if (m.find()) {
            String kext = m.group(1);
            if (this.data.length() > 0 && !"com.apple.kpi.iokit".equalsIgnoreCase(kext) && !"com.apple.kernel.iokit".equalsIgnoreCase(kext)) {
                String[] buf = this.data.split(":");
                if ("0000".equals(buf[2]) && (m = this.iopciclassmatch.matcher(block)).find()) {
                    buf[2] = m.group(1);
                }
                KextData kd = new KextData(kext, buf[0], buf[1], buf[2], this.stat.getVersion(kext));
                DefaultTableModel tm = (DefaultTableModel)this.tableKexts.getModel();
                if (!kd.getKextName().contains("Family") && !kd.getBundleName().endsWith("Disabler") && this.kc.add(kd)) {
                    Device d = this.pciids.getDevice(kd.getDeviceId(), kd.getVendorId());
                    if (d != null) {
                        tm.insertRow(0, new Object[]{new Boolean(true), kd.getKextName(), kd.getVersion(), d.getDeviceDesc(), kd.getClassId()});
                    } else {
                        d = this.pciids.getDevice(kd.getVendorId(), kd.getDeviceId());
                        if (d != null) {
                            String device = kd.getVendorId();
                            kd.setVendorId(kd.getDeviceId());
                            kd.setDeviceId(device);
                            tm.insertRow(0, new Object[]{new Boolean(true), kd.getKextName(), kd.getVersion(), d.getDeviceDesc(), kd.getClassId()});
                        }
                    }
                }
            }
        } else {
            m = this.device.matcher(block);
            if (m.find()) {
                String[] buf = new String[3];
                buf[0] = this.inverte(m.group(1));
                buf[2] = "0000";
                buf[1] = "0000";
                m = this.vendor.matcher(block);
                if (m.find()) {
                    buf[1] = this.inverte(m.group(1));
                }
                if ((m = this.pciclass.matcher(block)).find()) {
                    buf[2] = m.group(1);
                }
                DefaultTableModel tm = (DefaultTableModel)this.tableDevices.getModel();
                Device dev = this.pciids.getDevice(buf[0], buf[1]);
                Classe cla = this.pciids.getClasse(buf[2].substring(0, 2));
                Subclasse sub = this.pciids.getSubclasse(cla.getId(), buf[2].substring(2));
                if (dev != null) {
                    tm.insertRow(0, new Object[]{new ImageIcon(lURL), dev.getVendor().getVendorId(), dev.getVendor().getVendorDesc(), dev.getDeviceId(), dev.getDeviceDesc(), cla.getDesc(), sub.getDesc()});
                } else {
                    dev = this.pciids.getDevice(buf[1], buf[0]);
                    if (dev != null) {
                        tm.insertRow(0, new Object[]{new ImageIcon(lURL), dev.getVendor().getVendorId(), dev.getVendor().getVendorDesc(), dev.getDeviceId(), dev.getDeviceDesc(), cla.getDesc(), sub.getDesc()});
                    } else {
                        Vendor v = this.pciids.getVendor(buf[1]);
                        if (v != null) {
                            tm.insertRow(0, new Object[]{new ImageIcon(lURL), v.getVendorId(), v.getVendorDesc(), buf[0], "Unknown device", cla.getDesc(), sub.getDesc()});
                        } else {
                            tm.insertRow(0, new Object[]{new ImageIcon(lURL), buf[1], "Unknown vendor", buf[0], "Unknown device", cla.getDesc(), sub.getDesc()});
                        }
                    }
                }
                this.data = this.join(":", buf);
                this.datalevel = this.getLevel(block);
            }
        }
    }

    private String join(String divisor, String[] array) {
        if (array.length == 1) {
            return array[0];
        }
        String retorno = "";
        for (int i = 0; i < array.length - 1; ++i) {
            retorno = retorno.concat(array[i] + divisor);
        }
        retorno = retorno.concat(array[array.length - 1]);
        return retorno;
    }

    private int getLevel(String block) {
        int count = 0;
        try {
            String line = block.split("\n")[0];
            for (int i = 0; i < line.length(); ++i) {
                if (line.charAt(i) == ' ' || line.charAt(i) == '|') {
                    ++count;
                    continue;
                }
                return count;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    private String inverte(String id) {
        Pattern p = Pattern.compile("^(..)(..)$");
        Matcher m = p.matcher(id);
        if (m.find()) {
            return m.group(2) + m.group(1);
        }
        return id;
    }

    public static void main(String[] args) {
        String a = "aabb";
        System.out.println(a.substring(0, 2));
        System.out.println(a.substring(2));
    }

    public void setKextsTable(JTable table) {
        this.tableKexts = table;
    }

    public void setDevicesTable(JTable table) {
        this.tableDevices = table;
    }
}

