/*
 * Decompiled with CFR 0.152.
 */
package parser;

import data.KextStatData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import parser.IORegParser;

public class KextStatParser {
    private ArrayList<KextStatData> data = new ArrayList();

    public String getVersion(String bundle) {
        for (int i = 0; i < this.data.size(); ++i) {
            KextStatData kd = this.data.get(i);
            if (!kd.getBundle().equalsIgnoreCase(bundle)) continue;
            return kd.getVersion();
        }
        return "undefined";
    }

    public void parse() {
        String line = null;
        try {
            Process p = Runtime.getRuntime().exec("kextstat");
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            Pattern pat = Pattern.compile("0x[a-f0-9]+\\s+([^ ]+) \\(([^)]+)\\)");
            while ((line = input.readLine()) != null) {
                Matcher m = pat.matcher(line);
                if (!m.find()) continue;
                KextStatData kd = new KextStatData(m.group(1), m.group(2));
                this.data.add(kd);
            }
            input.close();
        }
        catch (IOException ex) {
            Logger.getLogger(IORegParser.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        KextStatParser p = new KextStatParser();
        p.parse();
    }
}

