/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import kexts.KextsView;
import pciids.Classe;
import pciids.Device;
import pciids.PciIdsParser;
import pciids.Subclasse;
import pciids.Vendor;

public class LsPciParser
implements Runnable {
    public static String LSPCI_COMMAND = "lspci -mmnn";
    private JTable tableKexts;
    private JTable tableDevices;
    private Pattern entryPattern = Pattern.compile("\\[([0-9A-Fa-f]{4})\\]\".*\\[([0-9A-Fa-f]{4})\\]\".*\\[([0-9A-Fa-f]{4})\\]\".*\\[[0-9A-Fa-f]{4}\\]\".*\\[[0-9A-Fa-f]{4}\\]\"");
    private KextsView parent;
    private PciIdsParser pciids;

    public LsPciParser(KextsView kv) {
        this.parent = kv;
    }

    private LsPciParser() {
    }

    public void run() {
        this.parent.startLoad();
        this.parent.toogleMenus(false, false, false, false);
        this.pciids = new PciIdsParser();
        this.pciids.run();
        this.parseRegistry();
        this.parent.toogleMenus(false, true, false, true);
        this.parent.stopLoad();
    }

    public void parseRegistry() {
        String block = "";
        try {
            String line;
            URL lURL = this.getClass().getResource("/search.png");
            Process p = Runtime.getRuntime().exec(LSPCI_COMMAND);
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                Matcher mat = this.entryPattern.matcher(line);
                if (!mat.find()) continue;
                DefaultTableModel tm = (DefaultTableModel)this.tableDevices.getModel();
                Device dev = this.pciids.getDevice(mat.group(3), mat.group(2));
                Classe cla = this.pciids.getClasse(mat.group(1).substring(0, 2));
                Subclasse sub = this.pciids.getSubclasse(cla.getId(), mat.group(1).substring(2));
                if (dev != null) {
                    tm.insertRow(0, new Object[]{new ImageIcon(lURL), dev.getVendor().getVendorId(), dev.getVendor().getVendorDesc(), dev.getDeviceId(), dev.getDeviceDesc(), cla.getDesc(), sub.getDesc()});
                    continue;
                }
                Vendor v = this.pciids.getVendor(mat.group(2));
                if (v != null) {
                    tm.insertRow(0, new Object[]{new ImageIcon(lURL), v.getVendorId(), v.getVendorDesc(), mat.group(3), "Unknown device", cla.getDesc(), sub.getDesc()});
                    continue;
                }
                tm.insertRow(0, new Object[]{new ImageIcon(lURL), mat.group(2), "Unknown vendor", mat.group(3), "Unknown device", cla.getDesc(), sub.getDesc()});
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public void setKextsTable(JTable table) {
        this.tableKexts = table;
    }

    public void setDevicesTable(JTable table) {
        this.tableDevices = table;
    }

    public static void main(String[] args) {
        LsPciParser iop = new LsPciParser();
        iop.run();
    }
}

