/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import kexts.KextsView;
import pciids.Classe;
import pciids.Device;
import pciids.PciIdsParser;
import pciids.Subclasse;
import pciids.Vendor;

public class RegParser
implements Runnable {
    public static String IOREG_COMMAND = "reg query hklm\\system\\currentcontrolset\\enum\\pci /s";
    private JTable tableKexts;
    private JTable tableDevices;
    private Pattern entryPattern = Pattern.compile("^\\s*HardwareID\\s*.*VEN_(....)&DEV_(....)&CC_(....)(?:\\\\0\\\\0)?$");
    private KextsView parent;
    private PciIdsParser pciids;

    public RegParser(KextsView kv) {
        this.parent = kv;
    }

    private RegParser() {
    }

    public void run() {
        this.parent.startLoad();
        this.parent.toogleMenus(false, false, false, false);
        this.pciids = new PciIdsParser();
        this.pciids.run();
        this.parseRegistry();
        this.parent.toogleMenus(false, true, false, true);
        this.parent.stopLoad();
    }

    public void parseRegistry() {
        String block = "";
        try {
            String line;
            URL lURL = this.getClass().getResource("/search.png");
            Process p = Runtime.getRuntime().exec(IOREG_COMMAND);
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                Matcher mat = this.entryPattern.matcher(line);
                if (!mat.matches()) continue;
                DefaultTableModel tm = (DefaultTableModel)this.tableDevices.getModel();
                Device dev = this.pciids.getDevice(mat.group(2), mat.group(1));
                Classe cla = this.pciids.getClasse(mat.group(3).substring(0, 2));
                Subclasse sub = this.pciids.getSubclasse(cla.getId(), mat.group(3).substring(2));
                if (dev != null) {
                    tm.insertRow(0, new Object[]{new ImageIcon(lURL), dev.getVendor().getVendorId(), dev.getVendor().getVendorDesc(), dev.getDeviceId(), dev.getDeviceDesc(), cla.getDesc(), sub.getDesc()});
                    continue;
                }
                Vendor v = this.pciids.getVendor(mat.group(1));
                if (v != null) {
                    tm.insertRow(0, new Object[]{new ImageIcon(lURL), v.getVendorId(), v.getVendorDesc(), mat.group(2), "Unknown device", cla.getDesc(), sub.getDesc()});
                    continue;
                }
                tm.insertRow(0, new Object[]{new ImageIcon(lURL), mat.group(1), "Unknown vendor", mat.group(2), "Unknown device", cla.getDesc(), sub.getDesc()});
            }
            input.close();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    private String join(String divisor, String[] array) {
        if (array.length == 1) {
            return array[0];
        }
        String retorno = "";
        for (int i = 0; i < array.length - 1; ++i) {
            retorno = retorno.concat(array[i] + divisor);
        }
        retorno = retorno.concat(array[array.length - 1]);
        return retorno;
    }

    private String inverte(String id) {
        Pattern p = Pattern.compile("^(..)(..)$");
        Matcher m = p.matcher(id);
        if (m.find()) {
            return m.group(2) + m.group(1);
        }
        return id;
    }

    public static void main(String[] args) {
        RegParser iop = new RegParser();
        iop.parseRegistry();
    }

    public void setKextsTable(JTable table) {
        this.tableKexts = table;
    }

    public void setDevicesTable(JTable table) {
        this.tableDevices = table;
    }
}

