/*
 * Decompiled with CFR 0.152.
 */
package pciids;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pciids.Classe;
import pciids.Device;
import pciids.Subclasse;
import pciids.Vendor;

public class PciIdsParser
implements Runnable {
    public static String PCI_IDS_FILENAME = "/pciids/pci.ids.txt";
    private ArrayList<Device> devices = new ArrayList();
    private ArrayList<Vendor> vendors = new ArrayList();
    private ArrayList<Classe> classes = new ArrayList();
    private ArrayList<Subclasse> subclasses = new ArrayList();

    public Device getDevice(String dev, String ven) {
        Device d = null;
        for (int i = 0; i < this.devices.size(); ++i) {
            d = this.devices.get(i);
            try {
                if (!d.getDeviceId().equalsIgnoreCase(dev) || !d.getVendor().getVendorId().equalsIgnoreCase(ven)) continue;
                return d;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        return null;
    }

    public Vendor getVendor(String codigo) {
        Vendor d = null;
        for (int i = 0; i < this.vendors.size(); ++i) {
            d = this.vendors.get(i);
            try {
                if (!d.getVendorId().equalsIgnoreCase(codigo)) continue;
                return d;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        return null;
    }

    public Subclasse getSubclasse(String codigoClasse, String sub) {
        Subclasse d = null;
        for (int i = 0; i < this.subclasses.size(); ++i) {
            d = this.subclasses.get(i);
            try {
                if (!d.getId().equalsIgnoreCase(sub) || !d.getParent().getId().equalsIgnoreCase(codigoClasse)) continue;
                return d;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        return null;
    }

    public Classe getClasse(String codigo) {
        Classe d = null;
        for (int i = 0; i < this.classes.size(); ++i) {
            d = this.classes.get(i);
            if (!codigo.equalsIgnoreCase(d.getId())) continue;
            return d;
        }
        return null;
    }

    public void run() {
        try {
            String line;
            Pattern vendorPat = Pattern.compile("^([0-9a-f]{4})  (.*)$");
            Pattern devicePat = Pattern.compile("^\t([0-9a-f]{4})  (.*)$");
            Pattern classPat = Pattern.compile("^C ([0-9a-f]{2})  (.*)$");
            Pattern subclassPat = Pattern.compile("^\t([0-9a-f]{2})  (.*)$");
            InputStream is = this.getClass().getResourceAsStream(PCI_IDS_FILENAME);
            BufferedReader in = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            Classe lastClasse = null;
            Vendor lastVendor = null;
            while ((line = in.readLine()) != null) {
                Matcher m = classPat.matcher(line);
                if (m.matches()) {
                    lastClasse = new Classe(m.group(1), m.group(2));
                    this.classes.add(lastClasse);
                }
                if ((m = vendorPat.matcher(line)).matches()) {
                    lastVendor = new Vendor(m.group(1), m.group(2));
                    this.vendors.add(lastVendor);
                }
                if ((m = devicePat.matcher(line)).matches()) {
                    Device dev = new Device(m.group(1), m.group(2), lastVendor);
                    this.devices.add(dev);
                }
                if (!(m = subclassPat.matcher(line)).matches()) continue;
                Subclasse sub = new Subclasse(m.group(1), m.group(2), lastClasse);
                this.subclasses.add(sub);
            }
            in.close();
        }
        catch (IOException e) {
            System.out.println(e.getLocalizedMessage());
        }
    }

    public static void main(String[] args) {
        PciIdsParser p = new PciIdsParser();
        p.run();
        Device d = p.getDevice("4364", "11ab");
        System.out.println(d);
    }
}

