require "smartinput"
local P = {}
P._G = _G

if _REQUIREDNAME == nil then
	chs_symbol = P
else
	_G[_REQUIREDNAME] = P
end
setfenv(1, P)

si = _G.smartinput
local pi = si.pending_input
local ca = si.candidates

function symbol_sk_on_click(surface, sk)
	si.input_string(sk.input_content)
	local i
	for i = 1, sk.cursor_offset do
		si.input_keycode(_G.config.L_KEYCODE_EDIT_LEFT);
	end
    
    local cur_tab = si.get_setting_value(si.settings.SYMBOL_CURRENT_TAB, si.settings_type.SETTING_INT)
    if cur_tab == 2 then -- number
        -- do nothing
    elseif cur_tab == 3 then -- smiley
        si.back_to_previous()
	elseif not si.get_setting_value(si.settings.SYMBOL_LOCK) then
		si.back_to_previous()
	end
end

function load_symbol(surface, symbol, page)
	local index = 1
	for i, row in _G.pairs(symbol[page]) do
		for j, title in _G.pairs(row) do
			key = si.new_softkey()
			if _G.type(title) == "table" then
				if title[3] == nil then
					key.main_title = title[1]
					key.cursor_offset = title[2]
					key.input_content = title[1]
				else 
					key.main_title = title[1]
					key.cursor_offset = title[2]
					key.input_content = title[3]
				end
			else
				key.main_title = title
				key.input_content = title
				key.cursor_offset = 0
			end
			key.on_click = function(sk)
		    	    if (not pi.empty()) and ca.empty() then
		                ca.clear()
		            end
				symbol_sk_on_click(surface, sk)
			end
			--si.print("#################load_symbol: " .. i .. "-" .. j .. " = " .. title)
			--if 0 == _G.string.len(key.main_title) then
			--	key.main_title = nil
			--end
			key.case_sensitive = false
			surface.softkeys["sk_" .. i .. "_" .. j] = key
			--surface.softkeys["sk_" .. index] = key
			--index = index + 1
		end
	end
	local sk_sp = surface.softkeys["sk_sp"]
	sk_sp.main_title = surface.sym_current_page .. "/" .. _G.table.getn(symbol)
end

function reload_symbol(surface, symbol, page)
	for a=1,3 do
		for b=1,4 do
			key = si.new_softkey()
			key.main_title = nil
			surface.softkeys["sk_" .. a .. "_" .. b] = key
		end
	end

	load_symbol(surface, symbol, page)
	si.sync_display()
end

function setup_chs_symbol(surface, symbol_tab)
	local sk_prev = si.new_softkey()
	sk_prev.on_click = surface.prev_page
	surface.softkeys["sk_prev_virtual"] = sk_prev
	
	local sk_next = si.new_softkey()
	sk_next.on_click = surface.next_page
	surface.softkeys["sk_next_virtual"] = sk_next

	local sk_lock = si.new_softkey()
	sk_lock.on_click = function()
       local cur_tab = si.get_setting_value(si.settings.SYMBOL_CURRENT_TAB, si.settings_type.SETTING_INT)
        if cur_tab ~= 2 and cur_tab ~= 3 then
            local locked = si.get_setting_value(si.settings.SYMBOL_LOCK)
            si.set_setting_value(si.settings.SYMBOL_LOCK, not locked)
        end
	end
	surface.softkeys["sk_lock"] = sk_lock

	local sk_back = si.new_softkey()
	sk_back.on_click = function ()
		si.back_to_previous()
	end
	surface.softkeys["sk_sym_back"] = sk_back
	
	for k, v in _G.pairs(symbol_tab) do
		local sk_symbol_tab = si.new_softkey()
		sk_symbol_tab.on_click = function()
			surface.switch_tab(k)
		end
		--si.print("#################setup_chs_symbol: " .. "sk_" .. k)
		surface.softkeys["sk_" .. k] = sk_symbol_tab
	end
end
