require "smartinput"
local P = {}
P._G = _G

if _REQUIREDNAME == nil then
	common_key = P
else
	_G[_REQUIREDNAME] = P
end
setfenv(1, P)

COMMON_KEY_TYPE = {
	WESTERN = 1,
	CHS = 2,
}

HARD_KEYCODE = {
	HARD_KEYCODE_DPAD_UP = 19,
	HARD_KEYCODE_DPAD_DOWN = 20,
	HARD_KEYCODE_DPAD_LEFT = 21,
	HARD_KEYCODE_DPAD_RIGHT = 22,
	HARD_KEYCODE_DPAD_CENTER = 23,
}

local si = _G.smartinput
local pi = si.pending_input
local ca = si.candidates
local ts = si.tri_status
local fi = si.filter_list

local function setup_dpad_keys(surface)
	local hk_up = si.new_hardkey()
	surface.hardkeys[HARD_KEYCODE.HARD_KEYCODE_DPAD_UP] = hk_up
	hk_up.on_click = function ()
		if not ca.empty() then
			si.input_keycode(_G.config.L_KEYCODE_FUN_CANDIDATE_UP)
		else
			return 1
		end
	end
	
	local hk_down = si.new_hardkey()
	surface.hardkeys[HARD_KEYCODE.HARD_KEYCODE_DPAD_DOWN] = hk_down
	hk_down.on_click = function ()
		if not ca.empty() then
			si.input_keycode(_G.config.L_KEYCODE_FUN_CANDIDATE_DOWN)
		else
			return 1
		end
	end
	
	local hk_left = si.new_hardkey()
	surface.hardkeys[HARD_KEYCODE.HARD_KEYCODE_DPAD_LEFT] = hk_left
	hk_left.on_click = function ()
		if not ca.empty() then
			local first = ca.get_first_index()
			local index = ca.get_default_index() - 1
			if index >= 1 then
				ca.set_default_index(index)
			end
			si.input_keycode(_G.config.L_KEYCODE_FUN_CANDIDATE_LEFT)
		else
			return 1
		end
	end
	
	local hk_right = si.new_hardkey()
	surface.hardkeys[HARD_KEYCODE.HARD_KEYCODE_DPAD_RIGHT] = hk_right
	hk_right.on_click = function ()
		if not ca.empty() then
			local index = ca.get_default_index() + 1
			if ca.get_item(index) ~= nil then
				ca.set_default_index(index)
				si.input_keycode(_G.config.L_KEYCODE_FUN_CANDIDATE_RIGHT)
			end
		else
			return 1
		end
	end
	
	local hk_center = si.new_hardkey()
	surface.hardkeys[HARD_KEYCODE.HARD_KEYCODE_DPAD_CENTER] = hk_center
	hk_center.on_click = function ()
		if not ca.empty() then
			local default = ca.get_default_index()
			if default ~= 0 then
				ca.confirm_item_2(default)
			end
		else
			return 1
		end
	end
end

local function setup_western(s)
	local sk_dot = si.new_softkey()
	local sk_comma = si.new_softkey()
	local sk_dic = si.new_softkey()
	local sk_sp = s.softkeys["sk_sp"]
	local sk_sym = s.softkeys["sk_sym"]

	s.softkeys["Dot"] = sk_dot
	s.softkeys["Comma"] = sk_comma
	s.softkeys["sk_dic"] = sk_dic

	sk_dot.main_title = "."
	sk_dot.on_click = function()
		si.input_precise(".", "", "", false)
	end

	sk_comma.main_title = ","
	sk_comma.on_click = function()
		si.input_precise(",", "", "", false)
	end
	sk_comma.on_long_press_once = function()
		local sur = si._G.dofile("expand.sur") 
		if (sur == nil) then 
			sur = si.new_surface("expand.sur")
			sur.surface_type = si.surface_type.POPUP_EXPAND
		end
		sur.softkeys[1] = si.new_expandkey(si.u16code(",", 1))
		sur.softkeys[2] = si.new_expandkey(si.u16code("'", 1))
		si.popup_surface(sur)
	end

	sk_dic.on_click = function()
		si.input_keycode(_G.config.L_KEYCODE_PREDICT)
		local on = si.get_setting_value(si.settings.WORD_PREDICTION)
		si.set_setting_value(si.settings.WORD_PREDICTION, not on)
	end

	sk_sp.on_slide_left = function()
		if not si.get_setting_value(si.settings.WORD_PREDICTION) then
			si.set_setting_value(si.settings.WORD_PREDICTION, true)
		end
	end

	sk_sp.on_slide_right = function()
		if si.get_setting_value(si.settings.WORD_PREDICTION) then
			si.set_setting_value(si.settings.WORD_PREDICTION, false)
		end
	end
	
	sk_sp.on_double_click = function()
		si.input_keycode(_G.config.L_KEYCODE_DOUBLE_SPACE)
		local ca = si.candidates
		if not ca.empty() then
			ca.clear()
		end
	end
end

local function setup_chs(s)
	local sk_dot = si.new_softkey()
	local sk_comma = si.new_softkey()
	local sk_sym = s.softkeys["sk_sym"]
	local sk_sp = s.softkeys["sk_sp"]	
	local sk_ent = s.softkeys["sk_ent"]
	
	sk_sp.on_click = function ()
		local default = ca.get_default_index()
		if pi.range_exist(pi.L_RANGE_PENDING) and ca.empty() then
			pi.commit_input()
			si.input_precise(" ", "", "", false)
		elseif not pi.empty() then
			if pi.range_exist(pi.L_RANGE_PENDING + pi.L_RANGE_CURVE) and (not ca.empty()) then
				ca.confirm_item_2(default)
			elseif pi.range_exist(pi.L_RANGE_CONFIRM) and (not pi.range_exist(pi.L_RANGE_PENDING)) then
				pi.commit_input()
			end
		elseif default ~= 0 and (si.get_setting_value(si.settings.SPACE_GET_NEXTWORD) or ca.get_item_source(ca.get_item(default)) == ca.SOURCE_EXTERNALCAND) then
			if ca.get_item_source(ca.get_item(default)) == ca.SOURCE_TOUCHCORRECTCAND then
				ca.clear()
			si.input_precise(" ", "", "", false)
			else
				ca.confirm_item_2(default)
			end
		else
			ca.clear()
			si.input_precise(" ", "", "", false)
		end
	end
	s.softkeys["sk_sp"] = sk_sp

	s.softkeys["Dot"] = sk_dot
	s.softkeys["Comma"] = sk_comma

	sk_dot.main_title = "。"
	sk_dot.on_click = function()
		si.input_string("。")
	end

	sk_comma.main_title = "，"
	sk_comma.on_click = function()
		si.input_string("，")
	end
	
	sk_ent.main_title = ""
	
	--softkeys
	local sk_cancel_confirm = si.new_softkey() --button above the candidate bar
	local sk_sep = si.new_softkey() --pinyin separator
	local sk_bk = s.softkeys["sk_bk"] --back space
	
	s.softkeys["sk_cancel"] = sk_cancel_confirm
	s.softkeys["sk_sep"] = sk_sep
	
	function sk_cancel_confirm.on_click()
		if not pi.stroke_filter_empty() then	--TODO: pack in clear_stroke
			pi.delete_stroke()
		else
			si.pending_input.cancel_confirm()
		end
	end
	
	local sk_sep = si.new_softkey()
	sk_sep.on_click = function ()
		if ts.get_tri_status(ts.SEPERATOR) == ts.NORMAL and pi.range_exist(pi.L_RANGE_PENDING) then
			si.input_precise("`", "", "", false)
		elseif pi.empty() then
			--ts.set_tri_status(ts.SEPERATOR, ts.NEXT)
			si.change_surface_by_id("number.sur.png")
		end
	end
	s.softkeys["sk_sep"] = sk_sep
	
end

function setup_common_sk(surface, common_key_type)
	-- space key
	local sk_sp = si.new_softkey()
	sk_sp.on_click = function ()
                local default = ca.get_default_index()
                if pi.range_exist(pi.L_RANGE_PENDING) and ca.empty() then
                        pi.commit_input()
                elseif not pi.empty() then
                        if pi.range_exist(pi.L_RANGE_PENDING + pi.L_RANGE_CURVE) and (not ca.empty()) then
                                ca.confirm_item_2(default)
                        elseif pi.range_exist(pi.L_RANGE_CONFIRM) and (not pi.range_exist(pi.L_RANGE_PENDING)) then
                                pi.commit_input()
                        end
                elseif default ~= 0 and (si.get_setting_value(si.settings.SPACE_GET_NEXTWORD) or ca.get_item_source(ca.get_item(default)) == ca.SOURCE_EXTERNALCAND) then
                        if ca.get_item_source(ca.get_item(default)) == ca.SOURCE_TOUCHCORRECTCAND then
                                ca.clear()
                        si.input_keycode(_G.config.L_KEYCODE_SPACE)
                        else
                                ca.confirm_item_2(default)
                        end
                else
                        ca.clear()
                        si.input_keycode(_G.config.L_KEYCODE_SPACE)
                end
        end

	surface.softkeys["sk_sp"] = sk_sp
	
	-- enter key
	local sk_ent = si.new_softkey()
	surface.softkeys["sk_ent"] = sk_ent
	sk_ent.on_click = function ()
		fi.clear()
		if not pi.empty() and not ca.empty() then
			if pi.range_exist(pi.L_RANGE_CURVE) then
				ca.confirm_item_2(ca.get_default_index())
			end
			pi.commit_input()
		elseif not pi.empty() then
			pi.commit_input()
		else
			si.input_keycode(_G.config.L_KEYCODE_ENTER)
		end
	end
	
	-- backspace key
	local sk_bk = si.new_softkey()
	surface.softkeys["sk_bk"] = sk_bk
	sk_bk.on_click = function ()
		if pi.range_exist(pi.L_RANGE_CURVE) then
	 		pi.delete_range()
		elseif not pi.stroke_filter_empty() then
			pi.delete_stroke()
		elseif pi.range_exist(pi.L_RANGE_PENDING) or pi.get_signal_code() ~= 0 then
			pi.delete_character()
		elseif not pi.empty() then
			pi.delete_range()
		elseif not ca.empty() then
			if not pi.context_empty() then
				si.input_keycode(_G.config.L_KEYCODE_BACKSPACE)
			end
			ca.clear()
		else
			si.input_keycode(_G.config.L_KEYCODE_BACKSPACE)
		end
	end
	sk_bk.on_slide_left = function ()
		if not pi.empty() then
			if pi.range_exist(pi.L_RANGE_PENDING) then
				pi.delete_range()
			else
				while not pi.empty() do
					pi.delete_range()
				end
			end
        elseif pi.get_signal_code() ~= 0 then
            pi.delete_character()
		elseif not ca.empty() then
			if not pi.context_empty() then
				si.input_keycode(_G.config.L_KEYCODE_BACKSPACE)
			end
			ca.clear()
		else
			si.input_keycode(_G.config.L_KEYCODE_BACKSPACE)
		end
	end
	sk_bk.on_long_press_multi = function ()
		if pi.range_exist(pi.L_RANGE_CURVE) then
	 		pi.delete_range()
		elseif not pi.stroke_filter_empty() then
			pi.delete_stroke()
		elseif pi.range_exist(pi.L_RANGE_PENDING) then
			pi.delete_character()
		elseif not pi.empty() then
			pi.delete_range()
		elseif not ca.empty() then
			ca.clear()
			si.input_keycode(_G.config.L_KEYCODE_BACKSPACE)
		else
			si.input_keycode(_G.config.L_KEYCODE_BACKSPACE)
		end
	end
	
	-- shift key
	local sk_sft = si.new_softkey()
	surface.softkeys["sk_sft"] = sk_sft
	sk_sft.on_click = function ()
		ts.set_tri_status(ts.CAPSLOCK, ts.NEXT)
	end
	
	-- more key
	local sk_mo = si.new_softkey()
	surface.softkeys["sk_mo"] = sk_mo
	sk_mo.on_click = function ()
		si.change_surface_by_type(si.surface_type.SOFT_FULLCANDIDATE)
	end
	
	-- symbol key
	local sk_sym = si.new_softkey()
	surface.softkeys["sk_sym"] = sk_sym
	sk_sym.on_click = function()
		si.change_surface_by_type(si.surface_type.SOFT_SYMBOL)
	end	
	
	sk_sym.main_title = ""
	
	-- language key
	local sk_lng = si.new_softkey()
	surface.softkeys["sk_lng"] = sk_lng
	sk_lng.on_click = function()
		if not pi.empty() then
			pi.delete_range()
		end
		local pre = si.get_setting_value(si.settings.PREUSED_LANGUAGE)
		local cur = si.get_setting_value(si.settings.CURRENT_LANGUAGE)
		if pre ~= cur and si.get_language(pre) ~= nil then
			si.set_current_language(pre)
		else
			si.input_keycode(_G.config.L_KEYCODE_LANGUAGE)
		end
	end
	sk_lng.on_long_press_once = function()
		si.input_keycode(_G.config.L_KEYCODE_LANGUAGE)
	end
	
	-- surface op
	if surface.surface_type == si.surface_type.SOFT_KEYBOARD then
		surface.on_slip_left = function()
			local st = surface.surface_subtype + 1
			if st > si.surface_subtype.KEYBOARD_TPLUS then
				st = si.surface_subtype.KEYBOARD_PHONEPAD
			end
			si.change_surface_by_subtype(st)
		end
	
		surface.on_slip_right = function()
			local st = surface.surface_subtype - 1
			if st < si.surface_subtype.KEYBOARD_PHONEPAD then
				st = si.surface_subtype.KEYBOARD_TPLUS
			end
			si.change_surface_by_subtype(st)
		end
	end
	
	-- edit key
	local sk_edit = si.new_softkey()
	surface.softkeys["sk_edit"] = sk_edit
	sk_edit.on_click = function()
		if not pi.empty() then
			pi.delete_range()
		end
		si.change_surface_by_id("edit.sur.png")
	end

	-- voice key
	local sk_voice = si.new_softkey()
	surface.softkeys["sk_voice"] = sk_voice
	sk_voice.on_click = function()
		if not pi.empty() then
			pi.delete_range()
		end
		si.change_surface_by_id("voice.sur.png")
		si.input_keycode(_G.config.L_KEYCODE_VOICE)
	end
	
	
	-- iphone earth key
	local sk_iphone_earth = si.new_softkey()
	surface.softkeys["sk_iphone_earth"] = sk_iphone_earth
	sk_iphone_earth.on_click = function()
		si.input_keycode(_G.config.L_KEYCODE_IPHONE_EARTH)
	end
	sk_iphone_earth.on_long_press_once = function()
		si.input_keycode(_G.config.L_KEYCODE_IPHONE_EARTH)
	end
	
	-- back key
	local sk_back = si.new_softkey()
	sk_back.on_click = function ()
		si.back_to_previous()
	end
	surface.softkeys["sk_back"] = sk_back
	
	
	-- abc key
	local sk_abc = si.new_softkey()
	sk_abc.on_click = function ()
		if not pi.empty() then
			pi.delete_range()
		end
		ca.clear()
		si.change_surface_by_id("chs_abc.sur")
	end
	surface.softkeys["sk_abc"] = sk_abc
	
	-- number key in symbol
	local sk_num = si.new_softkey()
	sk_num.on_click = function()
		surface.param = "number"
		si.change_surface_by_type(si.surface_type.SOFT_SYMBOL)
		surface.param = nil
	end
	surface.softkeys["sk_num"] = sk_num
	
	-- number key in normal pad
	local sk_number = si.new_softkey()
	sk_number.on_click = function()
		si.change_surface_by_id("number.sur")
	end
	surface.softkeys["sk_number"] = sk_number
	
	local sk_number_left = si.new_softkey()
    sk_number_left.on_click = function()
		si.change_surface_by_id("number_left.sur")
	end
	surface.softkeys["sk_number_left"] = sk_number_left
	
	local sk_number_only = si.new_softkey()
    sk_number_only.on_click = function()
		si.change_surface_by_id("number_only.sur")
	end
    surface.softkeys["sk_number_only"] = sk_number_only
	
    local sk_emoji = si.new_softkey()
    sk_emoji.on_click = function()
        si.change_surface_by_id("chs_sym_number.sur")
    end
    surface.softkeys["sk_emoji"] = sk_emoji
	
	setup_dpad_keys(surface)
	if common_key_type == COMMON_KEY_TYPE.WESTERN then
		setup_western(surface)
	elseif common_key_type == COMMON_KEY_TYPE.CHS then
		setup_chs(surface)
	end
	
end
