require "bit"

local P = {}
P._G = _G

if _REQUIREDNAME == nil then
	smartinput = P
else
	_G[_REQUIREDNAME] = P
end
setfenv(1, P)

if _G.config == nil then
	_G.config = {}
	_G.config.L_KEYCODE_ENTER = 131213
	_G.config.L_KEYCODE_SPACE = 131200
	_G.config.L_KEYCODE_BACKSPACE = 131080
	_G.config.L_KEYCODE_LANGUAGE = 3145761
	_G.config.L_KEYCODE_PREDICT = 3145729
	_G.config.L_PATH = ""
	_G.config.L_KEYCODE_CLOSE = 3145740
	_G.config.L_KEYCODE_PREV =3145762
	_G.config.L_KEYCODE_NEXT = 3145763
	_G.config.L_KEYCODE_DOUBLE_SPACE = 3145764
	_G.config.L_KEYCODE_BACK = 3145765
	_G.config.L_KEYCODE_VOICE = 3145766
	_G.config.L_KEYCODE_CANCEL_VOICE = 3145767
	_G.config.L_KEYCODE_FUN_CANDIDATE_UP = 3145768
	_G.config.L_KEYCODE_FUN_CANDIDATE_DOWN = 3145769
	_G.config.L_KEYCODE_FUN_CANDIDATE_LEFT = 3145770
	_G.config.L_KEYCODE_FUN_CANDIDATE_RIGHT = 3145771
	--**************************************
	-- EDIT
	_G.config.L_KEYCODE_EDIT_KEY_BEGIN = 3211265 
	_G.config.L_KEYCODE_EDIT_COPY = 3211265 
	_G.config.L_KEYCODE_EDIT_COPY = 3211265 
	_G.config.L_KEYCODE_EDIT_PASTE = 3211266 
	_G.config.L_KEYCODE_EDIT_CUT = 3211267 
	_G.config.L_KEYCODE_EDIT_UP = 3211268 
	_G.config.L_KEYCODE_EDIT_DOWN = 3211269 
	_G.config.L_KEYCODE_EDIT_LEFT = 3211270 
	_G.config.L_KEYCODE_EDIT_RIGHT = 3211271 
	_G.config.L_KEYCODE_EDIT_PDOWN = 3211272 
	_G.config.L_KEYCODE_EDIT_PUP = 3211273 
	_G.config.L_KEYCODE_EDIT_HOME = 3211274 
	_G.config.L_KEYCODE_EDIT_END = 3211275 
	_G.config.L_KEYCODE_EDIT_SELECT = 3211276 
	_G.config.L_KEYCODE_EDIT_DEL = 3211277 
	_G.config.L_KEYCODE_EDIT_SELECTALL = 3211278 
	_G.config.L_KEYCODE_EDIT_SPACE = 3211279 
	_G.config.L_KEYCODE_EDIT_DONE = 3211280
	_G.config.L_KEYCODE_EDIT_ADD_NEW_WORD = 3211281 
	_G.config.L_KEYCODE_EDIT_OPEN_OPERATION = 3211282 
	_G.config.L_KEYCODE_EDIT_KEY_END = 3211282
	--**************************************
	
	_G.config.L_KEYCODE_IPHONE_EARTH = 80000
end

function new_softkey()
	local key = {}
	key.case_sensitive = false
	return key
end

function new_expandkey(code)
	local title = u16char(code)
	local key = new_softkey()
	-- TODO: update title case according to shift state
	key.main_title = title
	key.main_input = title
   	print(title)
	key.on_click = function ()
		input_precise(key.main_input, "", "", is_shift_pressed())
	end
	return key
end

function new_hardkey()
	return {}
end

function new_surface(name)
	local surface = {}
	surface.name = name
	surface.softkeys = {}
	surface.hardkeys = {}
	surface.default_nextword = true
	return surface
end

function u16_iter (str)
	local i = 0
	return function ()
		i = i + 1
		return u16code(str, i)
	end
end

function is_empty(str)
	if str == nil then
		return true
	end
	
	return #str == 0
end

function get_accents(code)
	local accents = ""
	local cur = get_current_language()
	if cur.get_traits().get_accent_letters == nil then
		return accents
	end
	local str = cur.get_traits().get_accent_letters(code)
	if str ~= nil then
		accents = _G.string.format("%s%s", accents, str)
	end

	local mix = get_mixed_languages()
	for i, v in _G.ipairs(mix) do
		local lang = get_language(v)
		if lang.get_traits().get_accent_letters == nil then
			return accents
		end
		local str = lang.get_traits().get_accent_letters(code)
		if str ~= nil then
			accents = _G.string.format("%s%s", accents, str)
		end
	end
	print ("code = ", code, "accent letters", accents)
	return accents
end

function new_language(short_name, full_name)
	local l = {}
	l.short_name = short_name
	l.full_name = full_name
	l.categories = {}
--	_G.setmetatable(l, language.mt)
	return l
end

function new_engine(engine_t, dict_t)
	local engine = {}
	engine.engine_type = engine_t
	engine.dict_type = dict_t
	return engine 
end

function new_language_traits()
	return {}
end

function keycode_on_click(keycode)
	input_keycode(keycode)
end

title_case = {
	LOWER = 1,
	UPPER = 2,
	CHANGE = 3,
	NO_CHANGE = 4;
}

surface_type = {
	SOFT_KEYBOARD = 1,
	SOFT_SYMBOL = 2,
	SOFT_FULLCANDIDATE = 3,
	SOFT_SPECIAL = 4,
	HARD_KEYBOARD = 5,
	HARD_SYMBOL = 6,
	POPUP_EXPAND = 7
}

surface_subtype = {
	KEYBOARD_PHONEPAD = 1,
	KEYBOARD_FULL = 2,
	KEYBOARD_TPLUS = 3,
	KEYBOARD_OTHER = 4,
		KEYBOARD_HARD = 5,

	SYMBOL_NUMBER		= 0;
	SYMBOL_PUNCTUATION	= 1;
	SYMBOL_WEB			= 2;
	SYMBOL_EMOTION		= 3;
	SYMBOL_ACCENT		= 4;
	SYMBOL_NUMBEREXT	= 5;
	SYMBOL_PUNCEXT		= 6;
	SYMBOL_MATH			= 7;
	SYMBOL_PATTERN		= 8;
	SYMBOL_STROKE		= 9;
	SYMBOL_LETTER		= 10;
	SYMBOL_HIRAGANA		= 11;
	SYMBOL_KATAKANA		= 12;
}

surface_layout = {
	QW = 1,
	AZ = 2,
	QZ = 3,		
}

context = {
	OTHER = 0,
	TEXT = 0,
	NUMBER = 1,
	PHONE = 2,
	URI = 4,
	EMAIL = 8,
	DATE = 16,
	PASSWORD = 32,
	MATH = 64,
}

input_mode = {
	FUZZY = 1,
	MULTITAP = 2,
	PREDICT = 4,
	PRECISE = 8,
	AUTO_DISABLE_PREDICT = 16,
}

inline_strategy = {
	NONE = 0,
	DEFAULT_CANDIDATE = 1,
	PREDICT_EVIDENCE = 2,
	RANDOM_INLINE = 3,
	PRECISE_INPUT = 4,
	DEFAULT_CURVE = 5,
}

additional_item_source = {
	PRECISE = 1,
	RANDOM = 2,
}

additional_item_position = {
	FRONT = 1,
	EMPTY = 2,
}

keyboard_type = {
	HARD_KEYBOARD = 1,
	SOFT_KEYBOARD = 2,
}

pending_input = {
	empty = function ()
		return not pending_input.range_exist(pending_input.L_RANGE_CURVE + pending_input.L_RANGE_PENDING + pending_input.L_RANGE_CONFIRM)
	end;

	L_RANGE_CURVE =   1024, 
	L_RANGE_PENDING = 2048,
	L_RANGE_CONFIRM = 4096,
	L_RANGE_COMMMIT = 8192,
}

candidates = {
    confirm_item_2 = function (index)
        if get_cache_input() > 0 then
            set_transaction(TRANSACTION_END)
        end
        if (index ~= 0) then
            candidates.confirm_item(index)
        end
    end;

	SOURCE_EXTERNALCAND	 = 106,
	SOURCE_TOUCHCORRECTCAND = 108,
	SOURCE_CONSTSYMBOL = 116,
}

current_focus = {
	NONE = 0,
	FILTER = 1,
	CAND = 2,
	BACK = 3,
}

dictionary = {}
dictionary.load_mode = {
	PURE_FILE = 1,
	PURE_ARRAY = 2,
	COMP_ARRAY = 3,
	MMAP_ARRAY = 4,
}

dictionary.dict_type = {
	WESTERN = 0,
	CHS_PINYIN = 1,
	CHS_STROKE = 2,
	KOR = 3,
	CHT_BOPOMOFO = 4,
	JPN = 5,
	CHS_ASPECT = 6,
	HINDI = 7,
}

dictionary.image_type = {
	ROM = 1,
	RAM = 2,
	USR = 3,
    CELL = 4,
    BIGRAM = 5,
}

dictionary.image_tag = {
	QWERTY = 1, 
	AZERTY = 2, 
	QWERTZ = 4, 
	SIMPLIFIED = 8,
	TRANDITIONAL = 16,
	PHONEPAD = 128,
	FULL = 256,
	TPLUS = 512,
}

dictionary.engine_type = {
	OCEAN = 1,
	CURVE = 2,
	HANDWRITE = 1001,
	MULTIHW = 1002,
	CLOUDHW = 1003,
}

file = {
	NONE = 0,
	READ = 1,
	READWRITE = 2,
}

curve_dict = {}
curve_dict.engine_type = {
	CHS_PINYIN = 0,
	JPN = 1,
	WESTERN = 2,
}

tri_status = {
	CAPSLOCK = 0,
	SEPERATOR = 1,
	SURLOCK = 2,

	NORMAL = 1,
	TOGGLED = 2,
	LOCKED = 3,
	NEXT = 4,
	AUTO = 5,
}

word_filter = {
	ALL = 0, 
	SINGLE = 1,
	MULTI = 2,
}

editor = {
	NUMBER = 0x1;
}

OKINAWA_MAX_SETTING = 44

settings = {
	WORD_PREDICTION = 1,
	DOWNSLIDE_SYMBOL = 7,
	CURRENT_LANGUAGE = 10,
	PREUSED_LANGUAGE = 11,
	HANDWRITE_RECOG_RANGE = 29,
	CURVE_ENABLED = 31,
	SPACE_GET_NEXTWORD = 36,
	AUTO_SPACE = 37,
	SYMBOL_LOCK = 38,
	SYMBOL_CURRENT_TAB = 49,
	SYMBOL_CURRENT_PAGE = 50,
}

settings_type = {
	SETTING_BOOL = 1,
	SETTING_INT = 2,
	SETTING_STRING = 3,
}

handwrite_recog = {
	RECOG_RANGE_ZH = 0x3ff00;
	RECOG_RANGE_LETTER = 0x6;
	RECOG_RANGE_NUMBER = 0x1;
	RECOG_RANGE_SYMBOL = 0x8;
	RECOG_RANGE_ALL = 0x3ff0f;
	RECOG_RANGE_LETTER_NUMBER = 0x7;
	RECOG_RANGE_LETTER_SYMBOL = 0xe;
	RECOG_RANGE_NUMBER_SYMBOL = 0x9;
	RECOG_RANGE_ZH_SYMBOL = 0x3ff08;
	RECOG_RANGE_ZH_LETTER = 0x3ff06;
	
}

hard_keycode = {
	HARD_KEYCODE_DPAD_UP		 = 19,
	HARD_KEYCODE_DPAD_DOWN	   = 20,
	HARD_KEYCODE_DPAD_LEFT	   = 21,
	HARD_KEYCODE_DPAD_RIGHT	  = 22,
	HARD_KEYCODE_DPAD_CENTER	 = 23,
}

bg_lang_list = {
	"chinese_pinyin"
}

language = {}
language.mt = {}
language.mt.__newindex = function (t, k, v)
	if k == "surfaces" then
		--[[
        s_meta_set = {}
		i = 1
		mode = 0
		for _, s_id in _G.pairs(v) do
			local s = _G.dofile(s_id)
			local meta = {}
			meta.surface_type = s.surface_type
			meta.surface_subtype = s.surface_subtype
			meta.surface_layout = s.surface_layout
			meta.support_mode = s.support_mode
			meta.surface_id = s_id
			meta.surface_display_name = s.name
			s_meta_set[i] = meta
			if (meta.support_mode ~= nil) then
				mode = _G.bit:_or(mode, meta.support_mode)
			end
			i = i + 1
		end

		_G.rawset(t, k, s_meta_set)
		_G.rawset(t, "support_mode", mode)
        ]]--
	else
		_G.rawset(t, k, v)
	end
end

language.category = {
	FASTSWITCH = 0,
	LAYOUT = 1,
	MIXINPUT = 2,
	CELLDICT = 3,
	NEXTWORD = 4,
	CURVE = 5,
	USERWORD = 6,
	MISTYPING = 7,
	RECOGRANGE = 8,
}

chinese_charset = {
	NONE = 0,
	SIMPLIFIED = 1,
	TRADITIONAL = 2,
}


return P

