require "string"
require "smartinput"
require "common_key"

local P = {}
P._G = _G

if _REQUIREDNAME == nil then
	surface_factory = P
else
	_G[_REQUIREDNAME] = P
end
setfenv(1, P)

local string = _G.string
local si = _G.smartinput
local ck = _G.common_key

TITLE_CASE = {
	LOWER = 1,
	UPPER = 2,
	CHANGE = 3,
	NO_CHANGE = 4;
}

COMMON_KEY_TYPE = ck.COMMON_KEY_TYPE

function new_full_keyboard(name, main_input, alt_title, alt_input, case, mistyping, common_key_type, longpress_flag, shift_input)
        local surface = si.new_surface(name)
        surface.surface_layout = si.surface_layout.QW -- set default as QW
        surface.surface_type = si.surface_type.SOFT_KEYBOARD
        surface.surface_subtype = si.surface_subtype.KEYBOARD_FULL
        surface.multi_input_type = si.input_mode.FUZZY + si.input_mode.MULTITAP
        surface.precise_input_type = si.input_mode.PREDICT + si.input_mode.PRECISE + si.input_mode.AUTO_DISABLE_PREDICT
        if longpress_flag == nil then
                longpress_flag = 0
        end
        
        for i = 1, #main_input do
                for j = 1, #main_input[i] do
                        local key = si.new_softkey()
                        
                        -- main title & input
                        key.main_input = main_input[i][j];
                        if case == TITLE_CASE.UPPER then
                                key.main_title = string.upper(key.main_input)
                        elseif case == TITLE_CASE.LOWER then
                                key.main_title = string.lower(key.main_input)
                        else
                                key.main_title = key.main_input
                                if case == TITLE_CASE.CHANGE then
                                        key.case_sensitive = true
                                end
                        end
                        
                        -- alt title & input
                        if si.get_setting_value(si.settings.DOWNSLIDE_SYMBOL) == true and alt_input and alt_input[i] then
                                key.alt_title = alt_title[i][j]
                                key.alt_input = alt_input[i][j]
                        end
                        
                        -- shift title & input
                        if si.get_setting_value(si.settings.DOWNSLIDE_SYMBOL) == true and shift_input and shift_input[i] then
                                key.shift_title = shift_input[i][j]
                                key.shift_input = shift_input[i][j]
                        end
                        
                        -- long press order flag
                        if j == #main_input[i] and longpress_flag % 2 == 1 then
                                key.longpress_order = true
                        else
                                key.longpress_order = false
                        end
                        
                        -- title case for expand key
                        key.title_case = case
                        
                        -- full keyboard mistyping
                        if mistyping then
                                if j == 1 then
                                        key.mistyping = main_input[i][j + 1]
                                elseif j == #main_input[i] then
                                        key.mistyping = main_input[i][j - 1]
                                else
                                        key.mistyping = main_input[i][j - 1] .. main_input[i][j + 1]
                                end
                        else
                                key.mistyping = ""
                        end
                        
                        -- op function
                        key.on_click = full_on_click
                        key.on_slide_up = full_on_slide_up
                        if key.alt_input then
                                key.on_slide_down = on_slide_down
                        end
                        if key.alt_input or key.shift_input then
                                key.on_long_press_once = on_long_press_once
                        end
                        
                        surface.softkeys["sk_" .. i .. "_" .. j] = key
                end
                longpress_flag = longpress_flag / 2
        end

        ck.setup_common_sk(surface, common_key_type)
        
        return surface
end


function new_tplus_keyboard(name, left_input, right_input, alt_title, alt_input, case, common_key_type)
	local surface = si.new_surface(name)
	surface.surface_layout = si.surface_layout.QW -- set default as QW
	surface.surface_type = si.surface_type.SOFT_KEYBOARD
	surface.surface_subtype = si.surface_subtype.KEYBOARD_TPLUS
	surface.multi_input_type = si.input_mode.FUZZY + si.input_mode.MULTITAP
	surface.precise_input_type = si.input_mode.PREDICT + si.input_mode.PRECISE
	
	for i = 1, #left_input do
		for j = 1, #left_input[i] do
			local key = si.new_softkey()
			
			-- left/right title & input
			key.left_input = left_input[i][j]
			key.right_input = right_input[i][j]
			if si.is_empty(key.left_input) or si.is_empty(key.right_input) then
				key.main_title = key.left_input ..key.right_input
				if case == TITLE_CASE.UPPER then
					key.main_title = string.upper(key.main_title)
				elseif case == TITLE_CASE.LOWER then
					key.main_tilte = string.lower(key.main_title)
				else
					key.main_title = key.main_title
					if case == TITLE_CASE.CHANGE then
						key.case_sensitive = true
					end
				end
			else
				if case == TITLE_CASE.UPPER then
					key.left_title = string.upper(key.left_input)
					key.right_title = string.upper(key.right_input)
				elseif case == TITLE_CASE.LOWER then
					key.left_title = string.lower(key.left_input)
					key.right_title = string.lower(key.right_input)
				else
					key.left_title = key.left_input
					key.right_title = key.right_input
					if case == TITLE_CASE.CHANGE then
						key.case_sensitive = true
					end
				end
			end
			
			-- alt title & input
			if si.get_setting_value(si.settings.DOWNSLIDE_SYMBOL) == true and alt_input and alt_input[i] then
				key.alt_title = alt_title[i][j]
				key.alt_input = alt_input[i][j]
			end
			
			-- title case for expand key
			key.title_case = case
			
			-- op function
			key.on_click = tplus_on_click
			key.on_slide_up = tplus_on_slide_up
			if key.alt_input then
				key.on_slide_down = on_slide_down
			end
			if not (si.is_empty(key.left_input) or si.is_empty(key.right_input)) then
				key.on_slide_left = tplus_on_slide_left
				key.on_slide_right = tplus_on_slide_right
				key.on_slide_upleft = tplus_on_slide_upleft
				key.on_slide_upright = tplus_on_slide_upright
			end
			key.on_long_press_once = on_long_press_once
			
			surface.softkeys["sk_" .. i .. "_" .. j] = key
		end
	end
	
	ck.setup_common_sk(surface, common_key_type)

	return surface
end

function new_phonepad_keyboard(name, main_input, alt_title, alt_input, case, common_key_type)
	local surface = si.new_surface(name)
	surface.surface_type = si.surface_type.SOFT_KEYBOARD
	surface.surface_subtype = si.surface_subtype.KEYBOARD_PHONEPAD
	surface.multi_input_type = si.input_mode.FUZZY + si.input_mode.MULTITAP
	surface.precise_input_type = si.input_mode.PREDICT + si.input_mode.PRECISE
	
	for i = 1, #main_input do
		for j = 1, #main_input[i] do
			local key = si.new_softkey()
			
			-- main title & input
			key.main_input = main_input[i][j];
			if case == TITLE_CASE.UPPER then
				key.main_title = string.upper(key.main_input)
			elseif case == TITLE_CASE.LOWER then
				key.main_tilte = string.lower(key.main_input)
			else
				key.main_title = key.main_input
				if case == TITLE_CASE.CHANGE then
					key.case_sensitive = true
				end
			end
			
			-- alt title & input
			if si.get_setting_value(si.settings.DOWNSLIDE_SYMBOL) == true and alt_input and alt_input[i] then
				key.alt_title = alt_title[i][j]
				key.alt_input = alt_input[i][j]
			end
			
			-- title case for expand key
			key.title_case = case
			
			-- op function
			key.on_click = phonepad_on_click
			key.on_slide_up = phonepad_on_slide_up
			if key.alt_input then
				key.on_slide_down = on_slide_down
			end
			key.on_long_press_once = on_long_press_once
			
			surface.softkeys["sk_" .. i .. "_" .. j] = key
		end
	end

	ck.setup_common_sk(surface, common_key_type)
	
	return surface
end

function full_on_click(sk)
	si.input_precise(sk.main_input, sk.mistyping, sk.alt_input, si.is_shift_pressed())
end

function full_on_slide_up(sk)
        if sk.shift_input == nil then
                si.input_precise(sk.main_input, sk.mistyping, sk.alt_input, not si.is_shift_pressed())
        else
                si.input_precise(sk.shift_input, "", "", not si.is_shift_pressed())
        end
end

function tplus_on_click(sk)
	if si.is_empty(sk.left_input) or si.is_empty(sk.right_input) then
		si.input_precise(sk.left_input .. sk.right_input, "", sk.alt_input, si.is_shift_pressed())
	else
		si.input_multi(sk.left_input .. sk.right_input, sk.alt_input, si.is_shift_pressed())
	end
end

function tplus_on_slide_up(sk)
	si.input_multi(sk.left_input .. sk.right_input, sk.alt_input, not si.is_shift_pressed())
end

function tplus_on_slide_left(sk)
	si.input_multi(sk.left_input, nil, si.is_shift_pressed())
end

function tplus_on_slide_upleft(sk)
	si.input_multi(sk.left_input, nil, not si.is_shift_pressed())
end

function tplus_on_slide_right(sk)
	si.input_multi(sk.right_input, nil, si.is_shift_pressed())
end

function tplus_on_slide_upright(sk)
	si.input_multi(sk.right_input, nil, not si.is_shift_pressed())
end

function phonepad_on_click(sk)
	if #sk.main_input < 2 then
		si.input_precise(sk.main_input, "", sk.alt_input, si.is_shift_pressed())
	else
		si.input_multi(sk.main_input, sk.alt_input, si.is_shift_pressed())
	end
end

function phonepad_on_slide_up(sk)
	if #sk.main_input < 2 then
		si.input_precise(sk.main_input, "", sk.alt_input, not si.is_shift_pressed())
	else
		si.input_multi(sk.main_input, sk.alt_input, not si.is_shift_pressed())
	end
end

function on_slide_down(sk)
	--if #sk.alt_input < 2 then
	--	si.input_precise(sk.alt_input, "", "", false)
	--else
		si.input_string(sk.alt_input)
	--end
end

local expand_sur = si.new_surface("expand")
expand_sur.surface_type = si.surface_type.POPUP_EXPAND

local function new_expandkey(code, case)
	local key = si.new_expandkey(code)
	-- TODO:upper case the title when the softkey is uppercase
	-- DONE:in 5.1 version
	if case == TITLE_CASE.UPPER then
		key.main_title = string.upper(key.main_title)
	elseif case == TITLE_CASE.LOWER then
		key.main_tilte = string.lower(key.main_title)
	end
	return key
end

function on_long_press_once(sk)
	expand_sur.softkeys = {}
	
	local case = sk.title_case
	local index = 1
	
	-- TODO: don't use u16 convertor in C lib
	if sk.alt_input and si.get_setting_value(si.settings.DOWNSLIDE_SYMBOL) == true then
		for c in si.u16_iter(sk.alt_input) do
			expand_sur.softkeys[index] = new_expandkey(c, case)
			index = index + 1
		end
	end

	if sk.main_input then
		for c in si.u16_iter(sk.main_input) do
			expand_sur.softkeys[index] = new_expandkey(c, case)
			index = index + 1
			local accents = si.get_accents(c)
			for c in si.u16_iter(accents) do
				expand_sur.softkeys[index] = new_expandkey(c, case)
				index = index + 1
			end
		end
	end
	if sk.left_input then
		for c in si.u16_iter(sk.left_input) do
			expand_sur.softkeys[index] = new_expandkey(c, case)
			index = index + 1
			local accents = si.get_accents(c, case)
			for c in si.u16_iter(accents) do
				expand_sur.softkeys[index] = new_expandkey(c, case)
				index = index + 1
			end
		end
	end
	if sk.right_input then
		for c in si.u16_iter(sk.right_input) do
			expand_sur.softkeys[index] = new_expandkey(c, case)
			index = index + 1
			local accents = si.get_accents(c, case)
			for c in si.u16_iter(accents) do
				expand_sur.softkeys[index] = new_expandkey(c, case)
				index = index + 1
			end
		end
	end

	si.popup_surface(expand_sur)
end

function add_edit_surface(surface)
	sk_editors = {"copy", "paste", "cut", "up", "down",  "left", "right", "pdown", "pup", "home", 
		  "end", "select", "del", "selectall", "space", "done", "edit_addword", "edit_op"}

	for i, title in _G.pairs(sk_editors) do
		key = new_softkey()
		key.main_title = "@string/edit_" .. title
		key.case_sensitive = false
		surface.softkeys["sk_" .. title] = key
		function key.on_click()
			input_keycode(_G.config.L_KEYCODE_EDIT_KEY_BEGIN + i - 1)
		end
	end	
	
	surface.softkeys["sk_up"].main_title = nil
	surface.softkeys["sk_down"].main_title = nil
	surface.softkeys["sk_left"].main_title = nil
	surface.softkeys["sk_right"].main_title = nil
	
	ck.setup_common_sk(surface)
end
