/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.Globals;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class SigningInfo {
    private static Certificate[] verifyAllEntriesSigned(JarFile jarFile, URL uRL, String string, CacheEntry cacheEntry) throws JARSigningException {
        boolean bl = false;
        boolean bl2 = false;
        Certificate[] certificateArray = null;
        HashMap hashMap = null;
        Certificate[] certificateArray2 = null;
        try {
            if (cacheEntry != null) {
                hashMap = cacheEntry.getCertificateMap();
                certificateArray2 = cacheEntry.getCertificates();
            }
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string2 = jarEntry.getName();
                if (string2.startsWith("META-INF/") || string2.endsWith("/") || jarEntry.getSize() == 0L) continue;
                Certificate[] certificateArray3 = null;
                if (hashMap == null && certificateArray2 == null) {
                    certificateArray3 = jarEntry.getCertificates();
                } else {
                    int[] nArray = (int[])hashMap.get(string2);
                    if (nArray != null) {
                        certificateArray3 = new Certificate[nArray.length];
                        for (int i = 0; i < nArray.length; ++i) {
                            certificateArray3[i] = certificateArray2[nArray[i]];
                        }
                    }
                }
                if (certificateArray3 != null && certificateArray3.length == 0) {
                    certificateArray3 = null;
                }
                boolean bl3 = false;
                if (certificateArray3 != null) {
                    bl3 = true;
                    if (certificateArray == null) {
                        certificateArray = certificateArray3;
                    } else if (!SigningInfo.equalChains(certificateArray, certificateArray3)) {
                        throw new JARSigningException(uRL, string, 1);
                    }
                }
                bl = bl || bl3;
                bl2 = bl2 || !bl3;
            }
        }
        catch (SecurityException securityException) {
            throw new JARSigningException(uRL, string, 2, (Exception)securityException);
        }
        catch (IOException iOException) {
            throw new JARSigningException(uRL, string, 2, (Exception)iOException);
        }
        if (bl && bl2) {
            throw new JARSigningException(uRL, string, 3);
        }
        return certificateArray;
    }

    private static void verifyAllSignedEntriesPresent(JarFile jarFile, CacheEntry cacheEntry, URL uRL, String string) throws JARSigningException {
        Manifest manifest = null;
        try {
            manifest = cacheEntry == null ? jarFile.getManifest() : cacheEntry.getManifest();
            Set<Map.Entry<String, Attributes>> set = manifest.getEntries().entrySet();
            Iterator<Map.Entry<String, Attributes>> iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Attributes> entry = iterator.next();
                String string2 = entry.getKey();
                if (!SigningInfo.isSignedManifestEntry(manifest, string2) || jarFile.getEntry(string2) != null) continue;
                throw new JARSigningException(uRL, string, 4, string2);
            }
        }
        catch (IOException iOException) {
            throw new JARSigningException(uRL, string, 2, (Exception)iOException);
        }
    }

    public static Certificate[] checkSigning(URL uRL, String string) throws JARSigningException {
        CacheEntry cacheEntry = Cache.getCacheEntry((URL)uRL, null, (String)string);
        JarFile jarFile = null;
        Certificate[] certificateArray = null;
        try {
            jarFile = new JarFile(cacheEntry.getResourceFilename(), false);
            certificateArray = SigningInfo.verifyAllEntriesSigned(jarFile, uRL, string, cacheEntry);
            if (certificateArray != null) {
                SigningInfo.verifyAllSignedEntriesPresent(jarFile, cacheEntry, uRL, string);
            }
        }
        catch (IOException iOException) {
            throw new JARSigningException(uRL, string, 2, (Exception)iOException);
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        return certificateArray;
    }

    public static Certificate[] checkSigning(URL uRL, String string, JarFile jarFile) throws JARSigningException {
        Certificate[] certificateArray = SigningInfo.verifyAllEntriesSigned(jarFile, uRL, string, null);
        if (certificateArray != null) {
            SigningInfo.verifyAllSignedEntriesPresent(jarFile, null, uRL, string);
        }
        return certificateArray;
    }

    public static CodeSource getCodeSourceFromCache(URL uRL, String string) {
        CacheEntry cacheEntry = Cache.getCacheEntry((URL)uRL, null, (String)string);
        if (cacheEntry == null) {
            return null;
        }
        JarFile jarFile = cacheEntry.getJarFile();
        if (jarFile == null) {
            return null;
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string2 = jarEntry.getName();
            Trace.println((String)(" ... name=" + string2), (TraceLevel)TraceLevel.SECURITY);
            if (string2.startsWith("META-INF/") || string2.endsWith("/") || jarEntry.getSize() == 0L) continue;
            if (Globals.isJavaVersionAtLeast15()) {
                return new CodeSource(uRL, cacheEntry.getCodeSigners());
            }
            return new CodeSource(uRL, cacheEntry.getCertificates());
        }
        return null;
    }

    public static CodeSource getCodeSourceFromJarFile(URL uRL, JarFile jarFile) {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        byte[] byArray = new byte[32768];
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName();
            Trace.println((String)(" ... name=" + string), (TraceLevel)TraceLevel.SECURITY);
            if (string.startsWith("META-INF/") || string.endsWith("/") || jarEntry.getSize() == 0L) continue;
            try {
                int n;
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                }
                inputStream.close();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
            if (Globals.isJavaVersionAtLeast15()) {
                return new CodeSource(uRL, jarEntry.getCodeSigners());
            }
            return new CodeSource(uRL, jarEntry.getCertificates());
        }
        return null;
    }

    public static boolean equalChains(Certificate[] certificateArray, Certificate[] certificateArray2) {
        if (certificateArray.length != certificateArray2.length) {
            return false;
        }
        for (int i = 0; i < certificateArray.length; ++i) {
            if (certificateArray[i].equals(certificateArray2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isSignedManifestEntry(Manifest manifest, String string) {
        Attributes attributes = manifest.getAttributes(string);
        if (attributes != null) {
            Iterator<Object> iterator = attributes.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().toString();
                if (!(string2 = string2.toUpperCase(Locale.ENGLISH)).endsWith("-DIGEST") && string2.indexOf("-DIGEST-") == -1) continue;
                return true;
            }
        }
        return false;
    }
}

