/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message.saaj;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.XMLStreamException2;
import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.bind.unmarshaller.DOMScanner;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.message.AttachmentUnmarshallerImpl;
import com.sun.xml.internal.ws.message.saaj.SAAJHeader;
import com.sun.xml.internal.ws.streaming.DOMStreamReader;
import com.sun.xml.internal.ws.util.DOMUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAAJMessage
extends Message {
    private final SOAPMessage sm;
    private HeaderList headers;
    private String payloadLocalName;
    private String payloadNamspace;
    private List<Element> bodyParts;
    private Element payload;
    private boolean parsedHeader;

    public SAAJMessage(SOAPMessage sOAPMessage) {
        this.sm = sOAPMessage;
        try {
            SOAPBody sOAPBody = sOAPMessage.getSOAPBody();
            this.bodyParts = DOMUtil.getChildElements(sOAPBody);
            Element element = this.payload = this.bodyParts.size() > 0 ? this.bodyParts.get(0) : null;
            if (this.payload != null) {
                this.payloadLocalName = this.payload.getLocalName();
                this.payloadNamspace = this.payload.getNamespaceURI();
            }
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
    }

    private SAAJMessage(HeaderList headerList, AttachmentSet attachmentSet, SOAPMessage sOAPMessage) {
        this(sOAPMessage);
        this.headers = headerList;
        this.attachmentSet = attachmentSet;
    }

    @Override
    public boolean hasHeaders() {
        return this.getHeaders().size() > 0;
    }

    @Override
    public HeaderList getHeaders() {
        if (this.parsedHeader) {
            return this.headers;
        }
        if (this.headers == null) {
            this.headers = new HeaderList();
        }
        try {
            SOAPHeader sOAPHeader = this.sm.getSOAPHeader();
            if (sOAPHeader != null) {
                Iterator iterator = sOAPHeader.examineAllHeaderElements();
                while (iterator.hasNext()) {
                    this.headers.add(new SAAJHeader((SOAPHeaderElement)iterator.next()));
                }
            }
            this.parsedHeader = true;
        }
        catch (SOAPException sOAPException) {
            sOAPException.printStackTrace();
        }
        return this.headers;
    }

    @Override
    @NotNull
    public AttachmentSet getAttachments() {
        if (this.attachmentSet == null) {
            this.attachmentSet = new SAAJAttachmentSet(this.sm);
        }
        return this.attachmentSet;
    }

    @Override
    protected boolean hasAttachments() {
        return !this.getAttachments().isEmpty();
    }

    @Override
    public String getPayloadLocalPart() {
        return this.payloadLocalName;
    }

    @Override
    public String getPayloadNamespaceURI() {
        return this.payloadNamspace;
    }

    @Override
    public boolean hasPayload() {
        return this.payloadNamspace != null;
    }

    @Override
    public Source readEnvelopeAsSource() {
        try {
            SOAPEnvelope sOAPEnvelope = this.sm.getSOAPPart().getEnvelope();
            return new DOMSource(sOAPEnvelope);
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
    }

    @Override
    public Source readPayloadAsSource() {
        return this.payload != null ? new DOMSource(this.payload) : null;
    }

    @Override
    public SOAPMessage readAsSOAPMessage() {
        return this.sm;
    }

    @Override
    public SOAPMessage readAsSOAPMessage(Packet packet, boolean bl) throws SOAPException {
        return this.sm;
    }

    @Override
    public <T> T readPayloadAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        try {
            Node node = this.sm.getSOAPBody().getFirstChild();
            if (node != null) {
                return (T)unmarshaller.unmarshal(node);
            }
            return null;
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
    }

    @Override
    public <T> T readPayloadAsJAXB(Bridge<T> bridge) throws JAXBException {
        try {
            Node node = this.sm.getSOAPBody().getFirstChild();
            if (node != null) {
                return bridge.unmarshal(node, (AttachmentUnmarshaller)new AttachmentUnmarshallerImpl(this.getAttachments()));
            }
            return null;
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
    }

    @Override
    public XMLStreamReader readPayload() throws XMLStreamException {
        if (this.payload == null) {
            return null;
        }
        DOMStreamReader dOMStreamReader = new DOMStreamReader();
        dOMStreamReader.setCurrentNode(this.payload);
        dOMStreamReader.nextTag();
        assert (dOMStreamReader.getEventType() == 1);
        return dOMStreamReader;
    }

    @Override
    public void writePayloadTo(XMLStreamWriter xMLStreamWriter) {
        try {
            for (Element element : this.bodyParts) {
                DOMUtil.serializeNode(element, xMLStreamWriter);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
    }

    @Override
    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        DOMScanner dOMScanner = new DOMScanner();
        dOMScanner.setContentHandler(contentHandler);
        dOMScanner.scan(this.sm.getSOAPPart());
    }

    @Override
    public Message copy() {
        try {
            SOAPBody sOAPBody = this.sm.getSOAPPart().getEnvelope().getBody();
            SOAPMessage sOAPMessage = SOAPVersion.fromNsUri((String)sOAPBody.getNamespaceURI()).saajMessageFactory.createMessage();
            SOAPBody sOAPBody2 = sOAPMessage.getSOAPPart().getEnvelope().getBody();
            for (Element element : this.bodyParts) {
                Node node = sOAPBody2.getOwnerDocument().importNode(element, true);
                sOAPBody2.appendChild(node);
            }
            return new SAAJMessage(this.getHeaders(), this.getAttachments(), sOAPMessage);
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
    }

    @Override
    public void writeTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        try {
            xMLStreamWriter.writeStartDocument();
            SOAPEnvelope sOAPEnvelope = this.sm.getSOAPPart().getEnvelope();
            DOMUtil.writeTagWithAttributes(sOAPEnvelope, xMLStreamWriter);
            if (this.hasHeaders()) {
                xMLStreamWriter.writeStartElement(sOAPEnvelope.getPrefix(), "Header", sOAPEnvelope.getNamespaceURI());
                int n = this.headers.size();
                for (int i = 0; i < n; ++i) {
                    this.headers.get(i).writeTo(xMLStreamWriter);
                }
                xMLStreamWriter.writeEndElement();
            }
            DOMUtil.serializeNode(this.sm.getSOAPBody(), xMLStreamWriter);
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndDocument();
            xMLStreamWriter.flush();
        }
        catch (SOAPException sOAPException) {
            throw new XMLStreamException2(sOAPException);
        }
    }

    private class SAAJAttachment
    implements Attachment {
        AttachmentPart ap;

        public SAAJAttachment(AttachmentPart attachmentPart) {
            this.ap = attachmentPart;
        }

        public String getContentId() {
            return this.ap.getContentId();
        }

        public String getContentType() {
            return this.ap.getContentType();
        }

        public byte[] asByteArray() {
            try {
                return this.ap.getRawContentBytes();
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }

        public DataHandler asDataHandler() {
            try {
                return this.ap.getDataHandler();
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }

        public Source asSource() {
            try {
                return new StreamSource(this.ap.getRawContent());
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }

        public InputStream asInputStream() {
            try {
                return this.ap.getRawContent();
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            outputStream.write(this.asByteArray());
        }

        public void writeTo(SOAPMessage sOAPMessage) {
            sOAPMessage.addAttachmentPart(this.ap);
        }

        AttachmentPart asAttachmentPart() {
            return this.ap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SAAJAttachmentSet
    implements AttachmentSet {
        private Map<String, Attachment> attMap;
        private Iterator attIter;

        public SAAJAttachmentSet(SOAPMessage sOAPMessage) {
            this.attIter = sOAPMessage.getAttachments();
        }

        @Override
        public Attachment get(String string) {
            if (this.attMap == null) {
                if (!this.attIter.hasNext()) {
                    return null;
                }
                this.attMap = this.createAttachmentMap();
            }
            if (string.charAt(0) != '<') {
                return this.attMap.get('<' + string + '>');
            }
            return this.attMap.get(string);
        }

        @Override
        public boolean isEmpty() {
            if (this.attMap != null) {
                return this.attMap.isEmpty();
            }
            return !this.attIter.hasNext();
        }

        @Override
        public Iterator<Attachment> iterator() {
            if (this.attMap == null) {
                this.attMap = this.createAttachmentMap();
            }
            return this.attMap.values().iterator();
        }

        private Map<String, Attachment> createAttachmentMap() {
            HashMap<String, Attachment> hashMap = new HashMap<String, Attachment>();
            while (this.attIter.hasNext()) {
                AttachmentPart attachmentPart = (AttachmentPart)this.attIter.next();
                hashMap.put(attachmentPart.getContentId(), new SAAJAttachment(attachmentPart));
            }
            return hashMap;
        }

        @Override
        public void add(Attachment attachment) {
            this.attMap.put('<' + attachment.getContentId() + '>', attachment);
        }
    }
}

