/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.txw2.output;

import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class IndentingXMLFilter
extends XMLFilterImpl
implements LexicalHandler {
    private LexicalHandler lexical;
    private static final char[] NEWLINE = new char[]{'\n'};
    private static final Object SEEN_NOTHING = new Object();
    private static final Object SEEN_ELEMENT = new Object();
    private static final Object SEEN_DATA = new Object();
    private Object state = SEEN_NOTHING;
    private Stack<Object> stateStack = new Stack();
    private String indentStep = "";
    private int depth = 0;

    public IndentingXMLFilter() {
    }

    public IndentingXMLFilter(ContentHandler contentHandler) {
        this.setContentHandler(contentHandler);
    }

    public IndentingXMLFilter(ContentHandler contentHandler, LexicalHandler lexicalHandler) {
        this.setContentHandler(contentHandler);
        this.setLexicalHandler(lexicalHandler);
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexical;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexical = lexicalHandler;
    }

    public int getIndentStep() {
        return this.indentStep.length();
    }

    public void setIndentStep(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        while (n > 0) {
            stringBuilder.append(' ');
            --n;
        }
        this.setIndentStep(stringBuilder.toString());
    }

    public void setIndentStep(String string) {
        this.indentStep = string;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.stateStack.push(SEEN_ELEMENT);
        this.state = SEEN_NOTHING;
        if (this.depth > 0) {
            this.writeNewLine();
        }
        this.doIndent();
        super.startElement(string, string2, string3, attributes);
        ++this.depth;
    }

    private void writeNewLine() throws SAXException {
        super.characters(NEWLINE, 0, NEWLINE.length);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.depth;
        if (this.state == SEEN_ELEMENT) {
            this.writeNewLine();
            this.doIndent();
        }
        super.endElement(string, string2, string3);
        this.state = this.stateStack.pop();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.state = SEEN_DATA;
        super.characters(cArray, n, n2);
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.depth > 0) {
            this.writeNewLine();
        }
        this.doIndent();
        if (this.lexical != null) {
            this.lexical.comment(cArray, n, n2);
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        if (this.lexical != null) {
            this.lexical.startDTD(string, string2, string3);
        }
    }

    public void endDTD() throws SAXException {
        if (this.lexical != null) {
            this.lexical.endDTD();
        }
    }

    public void startEntity(String string) throws SAXException {
        if (this.lexical != null) {
            this.lexical.startEntity(string);
        }
    }

    public void endEntity(String string) throws SAXException {
        if (this.lexical != null) {
            this.lexical.endEntity(string);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.lexical != null) {
            this.lexical.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.lexical != null) {
            this.lexical.endCDATA();
        }
    }

    private void doIndent() throws SAXException {
        if (this.depth > 0) {
            char[] cArray = this.indentStep.toCharArray();
            for (int i = 0; i < this.depth; ++i) {
                this.characters(cArray, 0, cArray.length);
            }
        }
    }
}

