/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet.analysis;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import java.util.StringTokenizer;
import jj2000.j2k.ModuleSpec;
import jj2000.j2k.quantization.QuantTypeSpec;
import jj2000.j2k.wavelet.analysis.AnWTFilter;
import jj2000.j2k.wavelet.analysis.AnWTFilterFloatLift9x7;
import jj2000.j2k.wavelet.analysis.AnWTFilterIntLift5x3;

public class AnWTFilterSpec
extends ModuleSpec {
    private static final String REV_FILTER_STR = "w5x3";
    private static final String NON_REV_FILTER_STR = "w9x7";

    public AnWTFilterSpec(int n, int n2, byte by, QuantTypeSpec quantTypeSpec, J2KImageWriteParamJava j2KImageWriteParamJava, String string) {
        super(n, n2, by);
        int n3;
        int n4;
        String string2 = this.specified = string;
        boolean bl = true;
        if (string == null) {
            bl = false;
            if (j2KImageWriteParamJava.getLossless()) {
                this.setDefault(this.parseFilters(REV_FILTER_STR));
                return;
            }
            for (int i = n - 1; i >= 0; --i) {
                block17: for (int j = n2 - 1; j >= 0; --j) {
                    switch (quantTypeSpec.getSpecValType(i, j)) {
                        case 0: {
                            if (this.getDefault() == null) {
                                if (j2KImageWriteParamJava.getLossless()) {
                                    this.setDefault(this.parseFilters(REV_FILTER_STR));
                                }
                                if (((String)quantTypeSpec.getDefault()).equals("reversible")) {
                                    this.setDefault(this.parseFilters(REV_FILTER_STR));
                                } else {
                                    this.setDefault(this.parseFilters(NON_REV_FILTER_STR));
                                }
                            }
                            this.specValType[i][j] = 0;
                            continue block17;
                        }
                        case 1: {
                            if (!this.isCompSpecified(j)) {
                                if (((String)quantTypeSpec.getCompDef(j)).equals("reversible")) {
                                    this.setCompDef(j, this.parseFilters(REV_FILTER_STR));
                                } else {
                                    this.setCompDef(j, this.parseFilters(NON_REV_FILTER_STR));
                                }
                            }
                            this.specValType[i][j] = 1;
                            continue block17;
                        }
                        case 2: {
                            if (!this.isTileSpecified(i)) {
                                if (((String)quantTypeSpec.getTileDef(i)).equals("reversible")) {
                                    this.setTileDef(i, this.parseFilters(REV_FILTER_STR));
                                } else {
                                    this.setTileDef(i, this.parseFilters(NON_REV_FILTER_STR));
                                }
                            }
                            this.specValType[i][j] = 2;
                            continue block17;
                        }
                        case 3: {
                            if (!this.isTileCompSpecified(i, j)) {
                                if (((String)quantTypeSpec.getTileCompVal(i, j)).equals("reversible")) {
                                    this.setTileCompVal(i, j, this.parseFilters(REV_FILTER_STR));
                                } else {
                                    this.setTileCompVal(i, j, this.parseFilters(NON_REV_FILTER_STR));
                                }
                            }
                            this.specValType[i][j] = 3;
                            continue block17;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported specification type");
                        }
                    }
                }
            }
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        int n5 = 0;
        boolean[] blArray = null;
        boolean[] blArray2 = null;
        block18: while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            switch (string3.charAt(0)) {
                case 'T': 
                case 't': {
                    blArray = AnWTFilterSpec.parseIdx(string3, this.nTiles);
                    if (n5 == 1) {
                        n5 = 3;
                        continue block18;
                    }
                    n5 = 2;
                    continue block18;
                }
                case 'C': 
                case 'c': {
                    blArray2 = AnWTFilterSpec.parseIdx(string3, this.nComp);
                    if (n5 == 2) {
                        n5 = 3;
                        continue block18;
                    }
                    n5 = 1;
                    continue block18;
                }
                case 'W': 
                case 'w': {
                    if (j2KImageWriteParamJava.getLossless() && string3.equalsIgnoreCase(NON_REV_FILTER_STR)) {
                        throw new IllegalArgumentException("Cannot use non reversible wavelet transform with '-lossless' option");
                    }
                    AnWTFilter[][] anWTFilterArray = this.parseFilters(string3);
                    if (n5 == 0) {
                        this.setDefault(anWTFilterArray);
                    } else if (n5 == 2) {
                        for (n4 = blArray.length - 1; n4 >= 0; --n4) {
                            if (!blArray[n4]) continue;
                            this.setTileDef(n4, anWTFilterArray);
                        }
                    } else if (n5 == 1) {
                        for (n4 = blArray2.length - 1; n4 >= 0; --n4) {
                            if (!blArray2[n4]) continue;
                            this.setCompDef(n4, anWTFilterArray);
                        }
                    } else {
                        for (n4 = blArray.length - 1; n4 >= 0; --n4) {
                            for (n3 = blArray2.length - 1; n3 >= 0; --n3) {
                                if (!blArray[n4] || !blArray2[n3]) continue;
                                this.setTileCompVal(n4, n3, anWTFilterArray);
                            }
                        }
                    }
                    n5 = 0;
                    blArray = null;
                    blArray2 = null;
                    continue block18;
                }
            }
            throw new IllegalArgumentException("Bad construction for parameter: " + string3);
        }
        if (this.getDefault() == null) {
            n4 = 0;
            for (n3 = n - 1; n3 >= 0; --n3) {
                for (int i = n2 - 1; i >= 0; --i) {
                    if (this.specValType[n3][i] != 0) continue;
                    ++n4;
                }
            }
            if (n4 != 0) {
                if (((String)quantTypeSpec.getDefault()).equals("reversible")) {
                    this.setDefault(this.parseFilters(REV_FILTER_STR));
                } else {
                    this.setDefault(this.parseFilters(NON_REV_FILTER_STR));
                }
            } else {
                this.setDefault(this.getTileCompVal(0, 0));
                switch (this.specValType[0][0]) {
                    case 2: {
                        for (n3 = n2 - 1; n3 >= 0; --n3) {
                            if (this.specValType[0][n3] != 2) continue;
                            this.specValType[0][n3] = 0;
                        }
                        this.tileDef[0] = null;
                        break;
                    }
                    case 1: {
                        for (n3 = n - 1; n3 >= 0; --n3) {
                            if (this.specValType[n3][0] != 1) continue;
                            this.specValType[n3][0] = 0;
                        }
                        this.compDef[0] = null;
                        break;
                    }
                    case 3: {
                        this.specValType[0][0] = 0;
                        this.tileCompVal.put("t0c0", null);
                    }
                }
            }
        }
        for (n4 = n - 1; n4 >= 0; --n4) {
            for (n3 = n2 - 1; n3 >= 0; --n3) {
                if (((String)quantTypeSpec.getTileCompVal(n4, n3)).equals("reversible")) {
                    if (this.isReversible(n4, n3)) continue;
                    if (!bl) {
                        this.setTileCompVal(n4, n3, this.parseFilters(REV_FILTER_STR));
                        continue;
                    }
                    throw new IllegalArgumentException("Filter of tile-component (" + n4 + "," + n3 + ") does" + " not allow " + "reversible " + "quantization. " + "Specify '-Qtype " + "expounded' or " + "'-Qtype derived'" + "in " + "the command line.");
                }
                if (!this.isReversible(n4, n3)) continue;
                if (!bl) {
                    this.setTileCompVal(n4, n3, this.parseFilters(NON_REV_FILTER_STR));
                    continue;
                }
                throw new IllegalArgumentException("Filter of tile-component (" + n4 + "," + n3 + ") does" + " not allow " + "non-reversible " + "quantization. " + "Specify '-Qtype " + "reversible' in " + "the command line");
            }
        }
    }

    private AnWTFilter[][] parseFilters(String string) {
        AnWTFilter[][] anWTFilterArray = new AnWTFilter[2][1];
        if (string.equalsIgnoreCase(REV_FILTER_STR)) {
            anWTFilterArray[0][0] = new AnWTFilterIntLift5x3();
            anWTFilterArray[1][0] = new AnWTFilterIntLift5x3();
            return anWTFilterArray;
        }
        if (string.equalsIgnoreCase(NON_REV_FILTER_STR)) {
            anWTFilterArray[0][0] = new AnWTFilterFloatLift9x7();
            anWTFilterArray[1][0] = new AnWTFilterFloatLift9x7();
            return anWTFilterArray;
        }
        throw new IllegalArgumentException("Non JPEG 2000 part I filter: " + string);
    }

    public int getWTDataType(int n, int n2) {
        AnWTFilter[][] anWTFilterArray = (AnWTFilter[][])this.getSpec(n, n2);
        return anWTFilterArray[0][0].getDataType();
    }

    public AnWTFilter[] getHFilters(int n, int n2) {
        AnWTFilter[][] anWTFilterArray = (AnWTFilter[][])this.getSpec(n, n2);
        return anWTFilterArray[0];
    }

    public AnWTFilter[] getVFilters(int n, int n2) {
        AnWTFilter[][] anWTFilterArray = (AnWTFilter[][])this.getSpec(n, n2);
        return anWTFilterArray[1];
    }

    public String toString() {
        String string = "";
        string = string + "nTiles=" + this.nTiles + "\nnComp=" + this.nComp + "\n\n";
        for (int i = 0; i < this.nTiles; ++i) {
            for (int j = 0; j < this.nComp; ++j) {
                int n;
                AnWTFilter[][] anWTFilterArray = (AnWTFilter[][])this.getSpec(i, j);
                string = string + "(t:" + i + ",c:" + j + ")\n";
                string = string + "\tH:";
                for (n = 0; n < anWTFilterArray[0].length; ++n) {
                    string = string + " " + anWTFilterArray[0][n];
                }
                string = string + "\n\tV:";
                for (n = 0; n < anWTFilterArray[1].length; ++n) {
                    string = string + " " + anWTFilterArray[1][n];
                }
                string = string + "\n";
            }
        }
        return string;
    }

    public boolean isReversible(int n, int n2) {
        AnWTFilter[] anWTFilterArray = this.getHFilters(n, n2);
        AnWTFilter[] anWTFilterArray2 = this.getVFilters(n, n2);
        for (int i = anWTFilterArray.length - 1; i >= 0; --i) {
            if (anWTFilterArray[i].isReversible() && anWTFilterArray2[i].isReversible()) continue;
            return false;
        }
        return true;
    }
}

