/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.javafx;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jpedal.render.output.FontMapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class JavaFXFontMapper
implements FontMapper {
    private static final boolean STORE_UNIQUE_FONTS = false;
    private static final boolean DEBUG = false;
    private static boolean createXMLTemplate = false;
    private static final String DEFAULT_FONT = "DEFAULT_FONT";
    String style = "normal";
    String weight = "normal";
    private String fontID;
    private int fontMode = 3;
    private boolean isFontEmbedded = false;
    private static Set<String> fontsInPdf = new HashSet<String>();
    private static Map<String, String> userXMLTemplate = null;
    public static Map<String, String> fontMappings = new HashMap<String, String>();
    public static Map<String, Integer> fontSizeAdjustments = new HashMap<String, Integer>();
    private static Map<String, String> fontStyle = new HashMap<String, String>();
    private static Map<String, String> fontWeight = new HashMap<String, String>();
    private static String defaultFonts = "/org/jpedal/examples/html/defaultHTMLFontMap.xml";

    public JavaFXFontMapper(String string) {
        this.init(string);
    }

    public JavaFXFontMapper(String string, int n, boolean bl) {
        this.fontMode = n;
        this.isFontEmbedded = bl;
        this.init(string);
    }

    private void init(String string) {
        String string2;
        if (this.isFontEmbedded && (this.fontMode == 6 || this.fontMode == 7)) {
            this.fontID = string;
        } else if (!(this.directMapFont(string) || this.mapFont(string2 = this.findAttributes(string)) || this.hasSimiliarMapping(string2))) {
            switch (this.fontMode) {
                case 3: {
                    this.fontID = DEFAULT_FONT;
                    break;
                }
                case 2: {
                    throw new RuntimeException("Font " + string + " not mapped");
                }
            }
        }
        if (createXMLTemplate) {
            userXMLTemplate.put(string, this.fontID);
        }
    }

    private String findAttributes(String string) {
        String string2 = string;
        int n = string.indexOf(",");
        if (n == -1) {
            n = string.indexOf("-");
        }
        if (n == -1) {
            for (int i = string.length() - 1; i >= 0; --i) {
                int n2 = string.codePointAt(i);
                if (n2 < 48 || n2 > 57) continue;
                if (i >= string.length() - 1) break;
                n = i - 1;
                break;
            }
        }
        if (n != -1) {
            String string3 = string.substring(n + 1, string.length()).toLowerCase();
            string2 = string.substring(0, n);
            if (string3.contains("heavy")) {
                this.weight = "900";
            } else if (string3.endsWith("black")) {
                this.weight = "bolder";
            } else if (string3.contains("light")) {
                this.weight = "lighter";
            } else if (string3.contains("condensed")) {
                this.weight = "100";
            } else if (string3.contains("bold")) {
                this.weight = "bold";
            }
            if (string3.equals("it") || string3.contains("italic") || string3.contains("kursiv") || string3.contains("oblique")) {
                this.style = "italic";
            }
        }
        return string2;
    }

    private boolean mapFont(String string) {
        if (fontMappings.get(string) != null) {
            this.fontID = string;
            return true;
        }
        return false;
    }

    private boolean directMapFont(String string) {
        boolean bl = this.mapFont(string);
        if (!bl) {
            return false;
        }
        if (fontStyle.containsKey(string)) {
            this.style = fontStyle.get(string);
        }
        if (fontWeight.containsKey(string)) {
            this.weight = fontWeight.get(string);
        }
        return true;
    }

    private boolean hasSimiliarMapping(String string) {
        Set<String> set = fontMappings.keySet();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : set) {
            String string3;
            String string4 = string2.toLowerCase();
            if (string4.equals(string3 = string.toLowerCase())) {
                this.fontID = string2;
                return true;
            }
            if (!string4.contains(string3) && !string3.contains(string4)) continue;
            hashSet.add(string2);
        }
        if (!hashSet.isEmpty()) {
            String[] stringArray = new String[hashSet.size()];
            stringArray = hashSet.toArray(stringArray);
            this.fontID = stringArray[0];
            if (hashSet.size() > 1) {
                for (int i = 1; i < stringArray.length; ++i) {
                    if (stringArray[i].length() >= this.fontID.length()) continue;
                    this.fontID = stringArray[i];
                }
            }
            return true;
        }
        return false;
    }

    public String getFont() {
        if (this.isFontEmbedded && (this.fontMode == 6 || this.fontMode == 7)) {
            return this.fontID;
        }
        String string = fontMappings.get(this.fontID);
        return string == null ? "" : string;
    }

    public String getStyle() {
        return this.style;
    }

    public String getWeight() {
        return this.weight;
    }

    public int getFontSizeAdjustment() {
        int n = fontSizeAdjustments.get(this.fontID) != null ? fontSizeAdjustments.get(this.fontID) : 0;
        return n;
    }

    public static void loadCustomFontMappings(InputStream inputStream) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("font");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String string = JavaFXFontMapper.getTagValue("rawFont", element);
                if (string.length() == 0) {
                    throw new RuntimeException("A font element with no name?");
                }
                String string2 = JavaFXFontMapper.getTagValue("sizeAdjust", element);
                int n = string2.length() == 0 ? 0 : Integer.valueOf(string2);
                String string3 = JavaFXFontMapper.getTagValue("mappedTo", element);
                String string4 = JavaFXFontMapper.getTagValue("style", element);
                String string5 = JavaFXFontMapper.getTagValue("weight", element);
                if (string3.length() > 0) {
                    fontMappings.put(string, string3);
                }
                if (n != 0) {
                    fontSizeAdjustments.put(string, n);
                }
                if (string4.length() > 0) {
                    fontStyle.put(string, string4);
                }
                if (string5.length() <= 0) continue;
                fontWeight.put(string, string5);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String getTagValue(String string, Element element) {
        Node node = element.getElementsByTagName(string).item(0);
        if (node == null) {
            return "";
        }
        NodeList nodeList = node.getChildNodes();
        Node node2 = nodeList.item(0);
        return node2 != null ? node2.getNodeValue() : "";
    }

    public static void showFoundFonts() {
        for (String string : fontsInPdf) {
            System.out.println(string);
        }
    }

    public static void setXMLTemplate(boolean bl) {
        createXMLTemplate = bl;
        userXMLTemplate = createXMLTemplate ? new HashMap<String, String>() : null;
    }

    public static void createXMLTemplate(String string) {
        if (userXMLTemplate == null) {
            throw new AssertionError((Object)"XML Template is null.");
        }
        try {
            Object object;
            Object object2;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("fontMappings");
            document.appendChild(element);
            for (String object32 : userXMLTemplate.keySet()) {
                object2 = document.createElement("font");
                element.appendChild((Node)object2);
                object = document.createElement("rawFont");
                object2.appendChild((Node)object);
                Text text = document.createTextNode(object32);
                object.appendChild(text);
                object = document.createElement("sizeAdjust");
                object2.appendChild((Node)object);
                Integer n = fontSizeAdjustments.get(userXMLTemplate.get(object32));
                text = document.createTextNode(n != null ? n.toString() : "");
                object.appendChild(text);
                object = document.createElement("mappedTo");
                object2.appendChild((Node)object);
                String string2 = fontMappings.get(userXMLTemplate.get(object32));
                text = document.createTextNode(string2 != null ? string2 : "");
                object.appendChild(text);
                object = document.createElement("style");
                object2.appendChild((Node)object);
                String string3 = fontStyle.get(userXMLTemplate.get(object32));
                text = document.createTextNode(string3 != null ? string3 : "");
                object.appendChild(text);
                object = document.createElement("weigth");
                object2.appendChild((Node)object);
                String string4 = fontWeight.get(userXMLTemplate.get(object32));
                text = document.createTextNode(string4 != null ? string4 : "");
                object.appendChild(text);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
            object2 = new DOMSource(document);
            object = new StreamResult(new File(string));
            transformer.transform((Source)object2, (Result)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
    }

    static {
        String string = "Arial, Helvetica, sans-serif";
        String string2 = "'Arial Black', Gadget, sans-serif";
        String string3 = "'Comic Sans MS', Textile, cursive";
        String string4 = "'Courier New', Courier, monospace";
        String string5 = "Georgia, 'Times New Roman', Times, serif";
        String string6 = "Impact, Charcoal, sans-serif";
        String string7 = "'Lucida Console', Monaco, monospace";
        String string8 = "'Lucida Sans Unicode', 'Lucida Grande', sans-serif";
        String string9 = "'Palatino Linotype', 'Book Antiqua', Palatino, serif";
        String string10 = "Tahoma, Geneva, sans-serif";
        String string11 = "'Times New Roman', Times, serif";
        String string12 = "'Trebuchet MS', Helvetica, sans-serif";
        String string13 = "Verdana, Geneva, sans-serif";
        String string14 = "Symbol";
        String string15 = "Webdings";
        String string16 = "Wingdings, 'Zapf Dingbats'";
        String string17 = "'MS Sans Serif', Geneva, sans-serif";
        String string18 = "'MS Serif', 'New York', serif";
        String string19 = "Helvetica, Arial, sans-serif";
        if (fontMappings.keySet().isEmpty()) {
            fontMappings.put("Arial", string);
            fontMappings.put("ArialBlack", string2);
            fontMappings.put("ComicSansMS", string3);
            fontMappings.put("CourierNew", string4);
            fontMappings.put("Georgia", string5);
            fontMappings.put("Impact", string6);
            fontMappings.put("LucidaConsole", string7);
            fontMappings.put("LucidaSansUnicode", string8);
            fontMappings.put("PalatinoLinotype", string9);
            fontMappings.put("Tahoma", string10);
            fontMappings.put("TimesNewRoman", string11);
            fontMappings.put("Trebuchet", string12);
            fontMappings.put("Verdana", string13);
            fontMappings.put("Symbol", string14);
            fontMappings.put("Webdings", string15);
            fontMappings.put("Wingdings", string16);
            fontMappings.put("MSSansSerif", string17);
            fontMappings.put("MSSerif", string18);
            fontMappings.put("Helvetica", string19);
            fontMappings.put("ZapfDingbats", string16);
            fontMappings.put(DEFAULT_FONT, string11);
            fontSizeAdjustments.put(DEFAULT_FONT, -1);
        }
        try {
            InputStream inputStream = JavaFXFontMapper.class.getResourceAsStream(defaultFonts);
            if (inputStream != null) {
                JavaFXFontMapper.loadCustomFontMappings(inputStream);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

