/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.util.Hashtable;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class CMAP
extends Table {
    protected int[][] glyphIndexToChar;
    private int[] glyphToIndex;
    private boolean hasSix = false;
    private int winScore = 0;
    private int macScore = 0;
    private int segCount = 0;
    private int fontMapping = 0;
    protected int[] endCode;
    protected int[] startCode;
    protected int[] idDelta;
    protected int[] idRangeOffset;
    protected int[] glyphIdArray;
    private int[] f6glyphIdArray;
    private int[] offset;
    int nGroups;
    private int[] startCharCode;
    private int[] endCharCode;
    private int[] startGlyphCode;
    protected int[] CMAPformats;
    protected int[] CMAPlength;
    protected int[] CMAPlang;
    protected int[] CMAPsegCount;
    protected int[] CMAPsearchRange;
    protected int[] CMAPentrySelector;
    protected int[] CMAPrangeShift;
    protected int[] CMAPreserved;
    private boolean maybeWinEncoded = false;
    protected int[] platformID;
    private static Hashtable exceptions = new Hashtable();
    private int formatToUse;
    private int encodingToUse = 0;
    private static boolean WINchecked;
    protected int id;
    protected int numberSubtables;
    protected int[] CMAPsubtables;
    protected int[] platformSpecificID;

    public CMAP(FontFile2 fontFile2, int n, Glyf glyf) {
        if (n == 0) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("No CMAP table found");
            }
        } else {
            int n2;
            this.id = fontFile2.getNextUint16();
            this.numberSubtables = fontFile2.getNextUint16();
            this.CMAPsubtables = new int[this.numberSubtables];
            this.platformID = new int[this.numberSubtables];
            this.platformSpecificID = new int[this.numberSubtables];
            this.CMAPformats = new int[this.numberSubtables];
            this.CMAPsearchRange = new int[this.numberSubtables];
            this.CMAPentrySelector = new int[this.numberSubtables];
            this.CMAPrangeShift = new int[this.numberSubtables];
            this.CMAPreserved = new int[this.numberSubtables];
            this.CMAPsegCount = new int[this.numberSubtables];
            this.CMAPlength = new int[this.numberSubtables];
            this.CMAPlang = new int[this.numberSubtables];
            this.glyphIndexToChar = new int[this.numberSubtables][256];
            this.glyphToIndex = new int[256];
            for (n2 = 0; n2 < this.numberSubtables; ++n2) {
                this.platformID[n2] = fontFile2.getNextUint16();
                this.platformSpecificID[n2] = fontFile2.getNextUint16();
                this.CMAPsubtables[n2] = fontFile2.getNextUint32();
            }
            for (n2 = 0; n2 < this.numberSubtables; ++n2) {
                int n3;
                int n4;
                int n5;
                int n6;
                fontFile2.selectTable(2);
                fontFile2.skip(this.CMAPsubtables[n2]);
                this.CMAPformats[n2] = fontFile2.getNextUint16();
                this.CMAPlength[n2] = fontFile2.getNextUint16();
                this.CMAPlang[n2] = fontFile2.getNextUint16();
                if (this.CMAPformats[n2] == 6) {
                    this.hasSix = true;
                }
                if (this.CMAPformats[n2] == 0 && this.CMAPlength[n2] == 262) {
                    StandardFonts.checkLoaded(2);
                    StandardFonts.checkLoaded(0);
                    for (n6 = 0; n6 < 256; ++n6) {
                        this.glyphIndexToChar[n2][n6] = n5 = fontFile2.getNextUint8();
                        this.glyphToIndex[n5] = n6;
                        if (n5 <= 0) continue;
                        n4 = StandardFonts.isValidMacEncoding(n6) ? 1 : 0;
                        if (n4 != (n3 = (int)(StandardFonts.isValidWinEncoding(n6) ? 1 : 0))) {
                            this.maybeWinEncoded = true;
                        }
                        if (n4 != 0) {
                            ++this.macScore;
                        }
                        if (n3 == 0) continue;
                        ++this.winScore;
                    }
                    continue;
                }
                if (this.CMAPformats[n2] == 4) {
                    this.CMAPsegCount[n2] = fontFile2.getNextUint16();
                    this.segCount = this.CMAPsegCount[n2] / 2;
                    this.CMAPsearchRange[n2] = fontFile2.getNextUint16();
                    this.CMAPentrySelector[n2] = fontFile2.getNextUint16();
                    this.CMAPrangeShift[n2] = fontFile2.getNextUint16();
                    this.endCode = new int[this.segCount];
                    for (n4 = 0; n4 < this.segCount; ++n4) {
                        this.endCode[n4] = fontFile2.getNextUint16();
                    }
                    this.CMAPreserved[n2] = fontFile2.getNextUint16();
                    this.startCode = new int[this.segCount];
                    for (n4 = 0; n4 < this.segCount; ++n4) {
                        this.startCode[n4] = fontFile2.getNextUint16();
                    }
                    this.idDelta = new int[this.segCount];
                    for (n4 = 0; n4 < this.segCount; ++n4) {
                        this.idDelta[n4] = fontFile2.getNextUint16();
                    }
                    this.idRangeOffset = new int[this.segCount];
                    for (n4 = 0; n4 < this.segCount; ++n4) {
                        this.idRangeOffset[n4] = fontFile2.getNextUint16();
                    }
                    this.offset = new int[this.segCount];
                    n3 = 0;
                    for (n6 = 0; n6 < this.segCount; ++n6) {
                        if (this.idDelta[n6] != 0) continue;
                        this.offset[n6] = n3;
                        n4 = 1 + this.endCode[n6] - this.startCode[n6];
                        if (this.startCode[n6] == this.endCode[n6] && this.idRangeOffset[n6] == 0) {
                            n4 = 0;
                        }
                        n3 += n4;
                    }
                    n6 = (this.CMAPlength[n2] - 16 - this.segCount * 8) / 2;
                    this.glyphIdArray = new int[n6];
                    for (n5 = 0; n5 < n6; ++n5) {
                        this.glyphIdArray[n5] = fontFile2.getNextUint16();
                    }
                    continue;
                }
                if (this.CMAPformats[n2] == 6) {
                    n4 = fontFile2.getNextUint16();
                    n3 = fontFile2.getNextUint16();
                    this.f6glyphIdArray = new int[n4 + n3];
                    for (n6 = 0; n6 < n3; ++n6) {
                        this.f6glyphIdArray[n6 + n4] = fontFile2.getNextUint16();
                    }
                    continue;
                }
                if (this.CMAPformats[n2] == 12) {
                    fontFile2.getNextUint16();
                    fontFile2.getNextUint32();
                    this.nGroups = fontFile2.getNextUint32();
                    this.startCharCode = new int[this.nGroups];
                    this.endCharCode = new int[this.nGroups];
                    this.startGlyphCode = new int[this.nGroups];
                    for (n4 = 0; n4 < this.nGroups; ++n4) {
                        this.startCharCode[n4] = fontFile2.getNextUint32();
                        this.endCharCode[n4] = fontFile2.getNextUint32();
                        this.startGlyphCode[n4] = fontFile2.getNextUint32();
                    }
                    continue;
                }
                this.CMAPformats[n2] = -1;
            }
        }
    }

    public CMAP() {
    }

    public int convertIndexToCharacterCode(String string, int n, boolean bl, boolean bl2, String[] stringArray) {
        int n2 = -1;
        int n3 = n;
        int n4 = this.CMAPformats[this.formatToUse];
        if ((this.fontMapping == 1 || !bl && this.fontMapping == 4) && string != null && !string.equals("notdef")) {
            n = StandardFonts.getAdobeMap(string);
        } else if (this.fontMapping == 2) {
            StandardFonts.checkLoaded(this.encodingToUse);
            if (this.encodingToUse == 0) {
                Object var10_9 = null;
                if (string != null) {
                    var10_9 = exceptions.get(string);
                }
                if (var10_9 == null) {
                    if (string != null && !bl2) {
                        n = StandardFonts.lookupCharacterIndex(string, this.encodingToUse);
                    }
                } else if (stringArray == null || stringArray[n] == null) {
                    try {
                        n = Integer.parseInt(var10_9);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string != null) {
                    if (!WINchecked) {
                        StandardFonts.checkLoaded(2);
                        WINchecked = true;
                    }
                    n2 = StandardFonts.lookupCharacterIndex(string, 2);
                }
            } else if (string != null) {
                n = StandardFonts.lookupCharacterIndex(string, this.encodingToUse);
            }
        }
        int n5 = -1;
        if (bl && n4 > 0 && n4 != 6) {
            n += 61440;
        }
        if (n4 == 0) {
            if (n > 255) {
                n = 0;
            }
            if ((n5 = this.glyphIndexToChar[this.formatToUse][n]) == 0 && n2 != -1) {
                n5 = this.glyphIndexToChar[this.formatToUse][n2];
            }
            if (n3 == 128 && this.endCode != null && string.equals("Euro")) {
                n5 = this.getFormat4Value(8364, false, n5);
            }
        } else if (n4 == 4) {
            if ((n5 = this.getFormat4Value(n, false, n5)) == -1) {
                n5 = n > 61440 ? this.getFormat4Value(n - 61440, false, n5) : this.getFormat4Value(n + 61440, false, n5);
            }
        } else if (n4 == 12) {
            n5 = this.getFormat12Value(n, false, n5);
        }
        if (n5 == -1 && this.hasSix) {
            n = n3;
            n4 = 6;
        }
        if (n4 == 6) {
            n5 = n >= this.f6glyphIdArray.length ? 0 : this.f6glyphIdArray[n];
        }
        return n5;
    }

    private int getFormat12Value(int n, boolean bl, int n2) {
        for (int i = 0; i < this.nGroups; ++i) {
            if (bl) {
                System.out.println("table=" + i + " start=" + this.startCharCode[i] + " " + n + " end=" + this.endCharCode[i] + " glypgStartCode[i]=" + this.startGlyphCode[i]);
            }
            if (this.endCharCode[i] < n || this.startCharCode[i] > n) continue;
            n2 = this.startGlyphCode[i] + n - this.startCharCode[i];
            i = this.nGroups;
        }
        return n2;
    }

    private int getFormat4Value(int n, boolean bl, int n2) {
        for (int i = 0; i < this.segCount; ++i) {
            if (bl) {
                System.out.println("Segtable=" + i + " start=" + this.startCode[i] + " " + n + " end=" + this.endCode[i] + " idRangeOffset[i]=" + this.idRangeOffset[i] + " offset[i]=" + this.offset[i] + " idRangeOffset[i]=" + this.idRangeOffset[i] + " idDelta[i]=" + this.idDelta[i]);
            }
            if (this.endCode[i] < n || this.startCode[i] > n) continue;
            if (this.idRangeOffset[i] == 0) {
                if (bl) {
                    System.out.println("xxx=" + (this.idDelta[i] + n));
                }
                n2 = (this.idDelta[i] + n) % 65536;
                i = this.segCount;
                continue;
            }
            int n3 = this.offset[i] + (n - this.startCode[i]);
            n2 = this.glyphIdArray[n3];
            if (bl) {
                System.out.println("value=" + n2 + " idx=" + n3 + " glyphIdArrays=" + this.glyphIdArray[0] + " " + this.glyphIdArray[1] + " " + this.glyphIdArray[2] + " offset[i]=" + this.offset[i] + " index=" + n + " startCode[" + i + "]=" + this.startCode[i] + " i=" + i);
            }
            i = this.segCount;
        }
        return n2;
    }

    public void setEncodingToUse(boolean bl, int n, boolean bl2, boolean bl3) {
        int n2;
        int n3;
        int n4;
        this.formatToUse = -1;
        int n5 = this.platformID.length;
        if (!(bl2 || this.macScore >= 207 || this.glyphToIndex != null && this.macScore > 90 && !this.maybeWinEncoded || this.glyphToIndex != null && this.macScore > 205 && this.glyphToIndex[138] != 0 && this.glyphToIndex[228] == 0)) {
            if (n5 > 0 && this.winScore > this.macScore) {
                this.encodingToUse = 2;
            }
            if (this.macScore > 80 && bl && n == 2 && this.winScore >= this.macScore) {
                this.encodingToUse = 2;
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            if (this.platformID[n4] != 3 || this.CMAPformats[n4] != 1 && this.CMAPformats[n4] != 0) continue;
            this.formatToUse = n4;
            this.fontMapping = 1;
            n4 = n5;
        }
        n4 = 0;
        if (this.formatToUse == -1 && this.CMAPformats[0] != 12 && (this.macScore > 0 && this.winScore > 0 || this.CMAPformats.length == 1) && !bl3 && (!bl2 || this.CMAPformats.length == 1 && this.CMAPformats[0] == 0)) {
            for (n3 = 0; n3 < n5; ++n3) {
                if (this.platformID[n3] != 1 || this.CMAPformats[n3] != 0) continue;
                this.formatToUse = n3;
                this.fontMapping = bl || n == 2 ? 2 : 3;
                n3 = n5;
                n4 = 1;
            }
        }
        n3 = 0;
        if (this.formatToUse == -1) {
            for (n2 = 0; n2 < n5; ++n2) {
                if (this.CMAPformats[n2] != 6) continue;
                this.formatToUse = n2;
                if (!bl && n == 2) {
                    this.fontMapping = 2;
                    StandardFonts.checkLoaded(0);
                } else {
                    this.fontMapping = 6;
                }
                n3 = 1;
                n2 = n5;
            }
        }
        if (this.formatToUse == -1 || n3 != 0 || n4 != 0 && (this.glyphIndexToChar[this.formatToUse][223] == 0 || this.getFormat4Value(223, false, 0) != 0)) {
            for (n2 = 0; n2 < n5; ++n2) {
                if (this.CMAPformats[n2] != 4) continue;
                this.formatToUse = n2;
                this.fontMapping = 4;
                n2 = n5;
            }
        }
        if (this.formatToUse == -1) {
            for (n2 = 0; n2 < n5; ++n2) {
                if (this.CMAPformats[n2] != 12) continue;
                this.formatToUse = n2;
                if (!bl && n == 2) {
                    this.fontMapping = 2;
                    StandardFonts.checkLoaded(0);
                } else {
                    this.fontMapping = 12;
                }
                n2 = n5;
            }
        }
        if (n == 5) {
            this.fontMapping = 2;
        }
        if (this.encodingToUse == 2 && this.macScore == this.winScore && this.glyphIndexToChar[this.formatToUse][146] == 0 && this.glyphIndexToChar[this.formatToUse][213] != 0) {
            this.encodingToUse = 0;
        }
        if (this.encodingToUse == 2 && this.macScore == this.winScore && this.glyphIndexToChar[this.formatToUse][228] == 0 && this.glyphIndexToChar[this.formatToUse][138] != 0) {
            this.encodingToUse = 0;
        }
    }

    static {
        String[] stringArray = new String[]{"notequal", "173", "infinity", "176", "lessequal", "178", "greaterequal", "179", "partialdiff", "182", "summation", "183", "product", "184", "pi", "185", "integral", "186", "Omega", "189", "radical", "195", "approxequal", "197", "Delta", "198", "lozenge", "215", "Euro", "219", "apple", "240"};
        for (int i = 0; i < stringArray.length; i += 2) {
            exceptions.put(stringArray[i], stringArray[i + 1]);
        }
    }
}

