/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashSet;
import org.jpedal.color.PdfPaint;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.PathSerializer;
import org.jpedal.utils.repositories.Vector_Double;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Path;
import org.jpedal.utils.repositories.Vector_Short;

public class TTGlyph
implements PdfGlyph,
Serializable {
    public static boolean useHinting = false;
    public static boolean redecodePage = false;
    private static HashSet testedFonts;
    private boolean containsBrokenGlyfData = false;
    private boolean ttHintingRequired = false;
    private short minX;
    private short minY;
    private short maxX;
    private short maxY;
    int BPoint1;
    int BPoint2;
    int BP1x = -1;
    int BP2x = -1;
    int BP1y = -1;
    int BP2y = -1;
    private short compMinX;
    private short compMinY;
    private short compMaxX;
    private short compMaxY;
    private int[] scaledX;
    private int[] scaledY;
    private short leftSideBearing;
    private Vector_Int xtranslateValues = new Vector_Int(5);
    private Vector_Int ytranslateValues = new Vector_Int(5);
    private Vector_Double xscaleValues = new Vector_Double(5);
    private Vector_Double yscaleValues = new Vector_Double(5);
    private Vector_Double scale01Values = new Vector_Double(5);
    private Vector_Double scale10Values = new Vector_Double(5);
    private int xtranslate;
    private int ytranslate;
    private double xscale = 1.0;
    private double yscale = 1.0;
    private double scale01 = 0.0;
    private double scale10 = 0.0;
    private int[] instructions;
    private int currentInstructionDepth = Integer.MAX_VALUE;
    private Vector_Object glyfX = new Vector_Object(5);
    private Vector_Object glyfY = new Vector_Object(5);
    private Vector_Object curves = new Vector_Object(5);
    private Vector_Object contours = new Vector_Object(5);
    private Vector_Int endPtIndices = new Vector_Int(5);
    private int contourCount = 0;
    private float unitsPerEm = 64.0f;
    public boolean debug = false;
    private transient Vector_Path paths = new Vector_Path(10);
    private int compCount = 1;
    private boolean isComposite = false;
    String glyfName = "";
    private double pixelSize;
    int existingXTranslate = 0;
    int existingYTranslate = 0;
    int depth = 0;
    Area glyphShape = null;
    BufferedImage img = null;

    public void setPaths(Vector_Path vector_Path) {
        this.paths = vector_Path;
    }

    public void writePathsToStream(ObjectOutput objectOutput) throws IOException {
        if (this.paths != null) {
            int n;
            GeneralPath[] generalPathArray = this.paths.get();
            int n2 = 0;
            for (n = 0; n < generalPathArray.length; ++n) {
                if (generalPathArray[n] != null) continue;
                n2 = n;
                break;
            }
            objectOutput.writeObject(new Integer(n2));
            for (n = 0; n < n2; ++n) {
                PathIterator pathIterator = generalPathArray[n].getPathIterator(new AffineTransform());
                PathSerializer.serializePath(objectOutput, pathIterator);
            }
        }
    }

    public TTGlyph() {
    }

    public TTGlyph(String string, boolean bl, Glyf glyf, FontFile2 fontFile2, Hmtx hmtx, int n, float f, String string2) {
        Object object;
        this.debug = bl;
        this.glyfName = string;
        this.leftSideBearing = hmtx.getLeftSideBearing(n);
        this.unitsPerEm = f;
        int n2 = glyf.getCharString(n);
        fontFile2.setPointer(n2);
        this.readGlyph(glyf, fontFile2);
        for (int i = 0; i < this.compCount; ++i) {
            object = (int[])this.glyfX.elementAt(i);
            int[] nArray = (int[])this.glyfY.elementAt(i);
            boolean[] blArray = (boolean[])this.curves.elementAt(i);
            boolean[] blArray2 = (boolean[])this.contours.elementAt(i);
            int n3 = this.endPtIndices.elementAt(i);
            if (this.isComposite) {
                this.xtranslate = this.xtranslateValues.elementAt(i);
                this.ytranslate = this.ytranslateValues.elementAt(i);
                this.xscale = this.xscaleValues.elementAt(i);
                this.yscale = this.yscaleValues.elementAt(i);
                this.scale01 = this.scale01Values.elementAt(i);
                this.scale10 = this.scale10Values.elementAt(i);
                if (this.BPoint1 != -1 && this.BPoint2 != -1) {
                    if (this.BP1x == -1 && this.BP2x == -1 && this.BP1y == -1 && this.BP2y == -1) {
                        this.BP1x = (int)object[this.BPoint1];
                        this.BP1y = nArray[this.BPoint1];
                    } else {
                        this.BP2x = (int)object[this.BPoint2];
                        this.BP2y = nArray[this.BPoint2];
                        int n4 = this.BP1x - this.BP2x;
                        int n5 = this.BP1y - this.BP2y;
                        int n6 = ((Object)object).length;
                        for (int j = 0; j < n6; ++j) {
                            object[j] = object[j] + n4;
                            if (bl) {
                                System.out.println(nArray[j] + " " + n5 + " BP1y=" + this.BP1y + " BP1y=" + this.BP1y);
                            }
                            nArray[j] = nArray[j] + n5;
                        }
                        this.BP1x = -1;
                        this.BP2x = -1;
                        this.BP1y = -1;
                        this.BP2y = -1;
                    }
                }
            }
            this.createPaths((int[])object, nArray, blArray, blArray2, n3, bl);
        }
        if (bl) {
            try {
                System.out.println("debugging" + n);
                BufferedImage bufferedImage = new BufferedImage(700, 700, 2);
                object = bufferedImage.createGraphics();
                for (int i = 0; i < this.paths.size() - 1; ++i) {
                    if (i == 0) {
                        ((Graphics)object).setColor(Color.red);
                    } else {
                        ((Graphics)object).setColor(Color.blue);
                    }
                    ((Graphics2D)object).fill(this.paths.elementAt(i));
                    ((Graphics2D)object).draw(this.paths.elementAt(i).getBounds());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void readGlyph(Glyf glyf, FontFile2 fontFile2) {
        this.contourCount = fontFile2.getNextUint16();
        this.minX = (short)fontFile2.getNextUint16();
        this.minY = (short)fontFile2.getNextUint16();
        this.maxX = (short)fontFile2.getNextUint16();
        this.maxY = (short)fontFile2.getNextUint16();
        if (this.debug) {
            System.out.println("------------------------------------------------------------");
            System.out.println("min=" + this.minX + ' ' + this.minY + " max=" + this.maxX + ' ' + this.maxY + " contourCount=" + this.contourCount);
        }
        if (this.contourCount != 65535) {
            this.readSimpleGlyph(fontFile2);
        } else {
            this.compMinX = this.minX;
            this.compMinY = this.minY;
            this.compMaxX = this.maxX;
            this.compMaxY = this.maxY;
            if (this.debug) {
                System.out.println("XXmain=" + this.minX + " " + this.minY + " " + this.maxX + " " + this.maxY);
            }
            this.readComplexGlyph(glyf, fontFile2);
        }
    }

    private final void readComplexGlyph(Glyf glyf, FontFile2 fontFile2) {
        this.isComposite = true;
        this.xtranslateValues.pull();
        this.ytranslateValues.pull();
        this.xscaleValues.pull();
        this.yscaleValues.pull();
        this.scale01Values.pull();
        this.scale10Values.pull();
        this.BPoint1 = -1;
        this.BPoint2 = -1;
        boolean bl = false;
        int n = glyf.getGlypfCount();
        while (true) {
            int n2 = fontFile2.getNextUint16();
            int n3 = fontFile2.getNextUint16();
            if (this.debug) {
                System.err.println("Index=" + n3 + " flag=" + n2 + " " + n);
            }
            if (n3 >= n) {
                this.containsBrokenGlyfData = true;
                break;
            }
            boolean bl2 = (n2 & 1) == 1;
            boolean bl3 = (n2 & 2) == 2;
            boolean bl4 = (n2 & 8) == 8;
            boolean bl5 = (n2 & 0x40) == 64;
            boolean bl6 = (n2 & 0x80) == 128;
            boolean bl7 = bl = bl || (n2 & 0x100) == 256;
            if (bl2 && bl3) {
                this.xtranslate = fontFile2.getNextInt16();
                this.ytranslate = fontFile2.getNextInt16();
            } else if (!bl2 && bl3) {
                this.xtranslate = fontFile2.getNextint8();
                this.ytranslate = fontFile2.getNextint8();
            } else if (bl2 && !bl3) {
                this.BPoint1 = fontFile2.getNextUint16();
                this.BPoint2 = fontFile2.getNextUint16();
                this.xtranslate = 0;
                this.ytranslate = 0;
            } else if (!bl2 && !bl3) {
                this.BPoint1 = fontFile2.getNextUint8();
                this.BPoint2 = fontFile2.getNextUint8();
                this.xtranslate = 0;
                this.ytranslate = 0;
            }
            this.xscale = 1.0;
            this.scale01 = 0.0;
            this.scale10 = 0.0;
            this.yscale = 1.0;
            if (bl4 || bl5 || bl6) {
                if (bl4 && !bl5 && !bl6) {
                    this.xscale = fontFile2.getF2Dot14();
                    this.scale01 = 0.0;
                    this.scale10 = 0.0;
                    this.yscale = this.xscale;
                } else if (!bl4 && bl5 && !bl6) {
                    this.xscale = fontFile2.getF2Dot14();
                    this.scale01 = 0.0;
                    this.scale10 = 0.0;
                    this.yscale = fontFile2.getF2Dot14();
                } else if (!bl4 && !bl5 && bl6) {
                    this.xscale = fontFile2.getF2Dot14();
                    this.scale01 = fontFile2.getF2Dot14();
                    this.scale10 = fontFile2.getF2Dot14();
                    this.yscale = fontFile2.getF2Dot14();
                }
            }
            int n4 = this.xtranslate;
            int n5 = this.ytranslate;
            this.xtranslate += this.existingXTranslate;
            this.ytranslate += this.existingYTranslate;
            this.xtranslateValues.addElement(this.xtranslate);
            this.ytranslateValues.addElement(this.ytranslate);
            this.xscaleValues.addElement(this.xscale);
            this.yscaleValues.addElement(this.yscale);
            this.scale01Values.addElement(this.scale01);
            this.scale10Values.addElement(this.scale10);
            int n6 = fontFile2.getPointer();
            int n7 = glyf.getCharString(n3);
            if (n7 != -1) {
                if (n7 < 0) {
                    n7 = -n7;
                }
                fontFile2.setPointer(n7);
                this.existingXTranslate = this.xtranslate;
                this.existingYTranslate = this.ytranslate;
                ++this.depth;
                this.readGlyph(glyf, fontFile2);
                --this.depth;
                this.existingXTranslate -= n4;
                this.existingYTranslate -= n5;
            } else {
                System.err.println("Wrong value in complex");
            }
            fontFile2.setPointer(n6);
            if ((n2 & 0x20) == 0) {
                if (bl) {
                    int n8 = fontFile2.getNextUint16();
                    int[] nArray = new int[n8];
                    for (int i = 0; i < n8; ++i) {
                        nArray[i] = fontFile2.getNextUint8();
                    }
                    if (this.depth > this.currentInstructionDepth) break;
                    this.instructions = nArray;
                    this.currentInstructionDepth = this.depth;
                    break;
                }
                if (this.depth > this.currentInstructionDepth) break;
                this.instructions = new int[0];
                this.currentInstructionDepth = this.depth;
                break;
            }
            ++this.compCount;
        }
    }

    private void readSimpleGlyph(FontFile2 fontFile2) {
        int n;
        int n2 = 1;
        Vector_Int vector_Int = new Vector_Int(50);
        Vector_Int vector_Int2 = new Vector_Int(50);
        Vector_Short vector_Short = new Vector_Short(50);
        Vector_Short vector_Short2 = new Vector_Short(50);
        if (this.debug) {
            System.out.println("endPoints");
            System.out.println("---------");
        }
        int n3 = 0;
        for (n = 0; n < this.contourCount; ++n) {
            n3 = fontFile2.getNextUint16();
            if (this.debug) {
                System.out.println(n + " " + n3);
            }
            vector_Int2.addElement(n3);
        }
        if (fontFile2.hasValuesLeft()) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            n = fontFile2.getNextUint16();
            int[] nArray = new int[n];
            for (n10 = 0; n10 < n; ++n10) {
                nArray[n10] = fontFile2.getNextUint8();
            }
            if (this.depth < this.currentInstructionDepth) {
                this.instructions = nArray;
            }
            if (this.debug) {
                System.out.println("Instructions");
                System.out.println("------------");
                System.out.println("count=" + n);
            }
            n10 = n3 + 1;
            for (n9 = 0; n9 < n10; ++n9) {
                n8 = fontFile2.getNextUint8();
                vector_Int.addElement(n8);
                ++n2;
                if ((n8 & 8) != 8) continue;
                n7 = fontFile2.getNextUint8();
                for (n6 = 1; n6 <= n7; ++n6) {
                    vector_Int.addElement(n8);
                    ++n2;
                }
                n9 += n7;
            }
            for (n9 = 0; n9 < n10; ++n9) {
                short s;
                n8 = vector_Int.elementAt(n9);
                if ((n8 & 0x10) != 0) {
                    if ((n8 & 2) != 0) {
                        s = (short)fontFile2.getNextUint8();
                        vector_Short.addElement(s);
                        continue;
                    }
                    vector_Short.addElement((short)0);
                    continue;
                }
                if ((n8 & 2) != 0) {
                    s = (short)(-fontFile2.getNextUint8());
                    vector_Short.addElement(s);
                    continue;
                }
                s = fontFile2.getNextSignedInt16();
                vector_Short.addElement(s);
            }
            for (n9 = 0; n9 < n10; ++n9) {
                n8 = vector_Int.elementAt(n9);
                if ((n8 & 0x20) != 0) {
                    if ((n8 & 4) != 0) {
                        vector_Short2.addElement((short)fontFile2.getNextUint8());
                        continue;
                    }
                    vector_Short2.addElement((short)0);
                    continue;
                }
                if ((n8 & 4) != 0) {
                    vector_Short2.addElement((short)(-fontFile2.getNextUint8()));
                    continue;
                }
                n7 = fontFile2.getNextSignedInt16();
                vector_Short2.addElement((short)n7);
            }
            n9 = 0;
            n7 = 0;
            n6 = 0;
            int[] nArray2 = vector_Int.get();
            int[] nArray3 = vector_Int2.get();
            short[] sArray = vector_Short.get();
            short[] sArray2 = vector_Short2.get();
            n10 = sArray.length;
            int[] nArray4 = new int[n10 + 2];
            int[] nArray5 = new int[n10 + 2];
            boolean[] blArray = new boolean[n10 + 2];
            boolean[] blArray2 = new boolean[n10 + 2];
            int n11 = 0;
            if (this.debug) {
                System.out.println("Points");
                System.out.println("------");
            }
            for (n5 = 0; n5 < n10; ++n5) {
                int n12 = n4 = nArray3[n9] == n5 ? 1 : 0;
                if (n4 != 0) {
                    ++n9;
                    n11 = n5 + 1;
                }
                nArray4[n5] = n7 += sArray[n5];
                nArray5[n5] = n6 += sArray2[n5];
                blArray[n5] = n5 < n2 && (nArray2[n5] & 1) != 0;
                blArray2[n5] = n4;
                if (!this.debug) continue;
                System.out.println(n5 + " " + nArray4[n5] + ' ' + nArray5[n5] + " on curve=" + blArray[n5] + " endOfContour[i]=" + blArray2[n5]);
            }
            for (n5 = 0; n5 < nArray4.length; ++n5) {
                n4 = nArray4[n5];
                int n13 = nArray5[n5];
                nArray4[n5] = !this.isComposite ? (!useHinting ? (int)((float)n4 / this.unitsPerEm) : n4) : (!useHinting ? (int)(((double)n4 * this.xscale + (double)n13 * this.scale10 + (double)this.xtranslate) / (double)this.unitsPerEm) : (int)((double)n4 * this.xscale + (double)n13 * this.scale10 + (double)this.xtranslate));
                if (!this.isComposite) {
                    if (!useHinting) {
                        nArray5[n5] = (int)((float)n13 / this.unitsPerEm);
                        continue;
                    }
                    nArray5[n5] = n13;
                    continue;
                }
                nArray5[n5] = !useHinting ? (int)(((double)n4 * this.scale01 + (double)n13 * this.yscale + (double)this.ytranslate) / (double)this.unitsPerEm) : (int)((double)n4 * this.scale01 + (double)n13 * this.yscale + (double)this.ytranslate);
            }
            this.glyfX.addElement(nArray4);
            this.glyfY.addElement(nArray5);
            this.curves.addElement(blArray);
            this.contours.addElement(blArray2);
            this.endPtIndices.addElement(n11);
        }
    }

    public void render(int n, Graphics2D graphics2D, float f, boolean bl) {
        AffineTransform affineTransform = graphics2D.getTransform();
        BasicStroke basicStroke = (BasicStroke)graphics2D.getStroke();
        float f2 = basicStroke.getLineWidth();
        if (f2 < 0.0f) {
            f2 = -f2;
        }
        if (useHinting) {
            graphics2D.scale(0.01, 0.01);
            f2 *= 100.0f;
        }
        graphics2D.setStroke(new BasicStroke(f2, 0, 1, basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase()));
        for (int i = 0; i < this.paths.size() - 1; ++i) {
            if ((n & 2) == 2) {
                graphics2D.fill(this.paths.elementAt(i));
                continue;
            }
            if ((n & 1) != 1) continue;
            graphics2D.draw(this.paths.elementAt(i));
        }
        if (useHinting) {
            graphics2D.setStroke(basicStroke);
            graphics2D.setTransform(affineTransform);
        }
    }

    public Area getShape() {
        if (this.glyphShape == null) {
            GeneralPath generalPath = this.paths.elementAt(0);
            for (int i = 1; i < this.paths.size() - 1; ++i) {
                generalPath.append(this.paths.elementAt(i), false);
            }
            this.glyphShape = new Area(generalPath);
        }
        return this.glyphShape;
    }

    public String getGlyphName() {
        return null;
    }

    public void scaler(int[] nArray, int[] nArray2) {
        this.scaledX = new int[nArray.length];
        this.scaledY = new int[nArray2.length];
        double d = this.pixelSize / (double)(this.unitsPerEm * 1000.0f) * 64.0;
        for (int i = 0; i < nArray.length; ++i) {
            this.scaledX[i] = (int)(d * (double)nArray[i] + 0.5);
            this.scaledY[i] = (int)(d * (double)nArray2[i] + 0.5);
        }
        this.scaledX[nArray.length - 2] = 0;
        this.scaledY[nArray2.length - 2] = 0;
        this.scaledX[nArray.length - 1] = (int)(d * (double)this.leftSideBearing + 0.5);
        this.scaledY[nArray2.length - 1] = 0;
    }

    public void createPaths(int[] nArray, int[] nArray2, boolean[] blArray, boolean[] blArray2, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (blArray2 == null) {
            return;
        }
        int n7 = blArray2.length;
        int n8 = 0;
        int n9 = -1;
        for (n6 = 0; n6 < n7; ++n6) {
            if (blArray2[n6]) {
                if (!(n9 == -1 || blArray[n8] && blArray[n6])) {
                    int n10 = n9 - n8;
                    n5 = nArray.length;
                    int[] nArray3 = new int[n5];
                    System.arraycopy(nArray, 0, nArray3, 0, n5);
                    int[] nArray4 = new int[n5];
                    System.arraycopy(nArray2, 0, nArray4, 0, n5);
                    boolean[] blArray3 = new boolean[n5];
                    System.arraycopy(blArray, 0, blArray3, 0, n5);
                    for (n4 = n8; n4 < n6 + 1; ++n4) {
                        n3 = n4 + n10;
                        if (n3 > n6) {
                            n3 -= n6 - n8 + 1;
                        }
                        nArray[n4] = nArray3[n3];
                        nArray2[n4] = nArray4[n3];
                        blArray[n4] = blArray3[n3];
                    }
                }
                n8 = n6 + 1;
                n9 = -1;
                continue;
            }
            if (!blArray[n6] || n9 != -1) continue;
            n9 = n6;
        }
        n6 = 1;
        GeneralPath generalPath = new GeneralPath(1);
        n3 = nArray.length;
        n5 = -1;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!blArray2[n2]) continue;
            n5 = n2 + 1;
            n2 = n3;
        }
        int n11 = 0;
        n4 = 0;
        int n12 = 0;
        int n13 = 0;
        n2 = nArray[0];
        int n14 = nArray2[0];
        if (this.debug) {
            System.out.println(nArray[0] + " " + nArray2[0] + " move to x1,y1=" + n2 + " " + n14);
        }
        generalPath.moveTo(n2, n14);
        if (this.debug) {
            System.out.println("first contour=" + n5 + "====================================" + nArray[0] + ' ' + nArray2[0]);
        }
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            int n18;
            int n19 = i % n5;
            int n20 = (i + 1) % n5;
            int n21 = (i + 2) % n5;
            int n22 = (i - 1) % n5;
            if (i == 0) {
                n22 = n5 - 1;
            }
            if (n20 < n17) {
                n20 += n17;
            }
            if (n21 < n17) {
                n21 += n17;
            }
            if (bl) {
                System.out.println("points=" + n17 + '/' + n5 + ' ' + n22 + ' ' + n19 + ' ' + n20 + ' ' + n21 + " j=" + i + " endOfContour[j]=" + blArray2[i]);
            }
            if (blArray2[i]) {
                bl2 = true;
                if (blArray[n5]) {
                    n15 = nArray[n5];
                    n16 = nArray2[n5];
                } else {
                    n15 = nArray[i + 1];
                    n16 = nArray2[i + 1];
                }
                n17 = n5;
                for (n18 = i + 1; n18 < n3; ++n18) {
                    if (!blArray2[n18]) continue;
                    n5 = n18 + 1;
                    n18 = n3;
                }
                if (bl) {
                    System.out.println("End of contour. next=" + i + ' ' + n5 + ' ' + n17);
                }
            }
            if (bl) {
                if (i > 0) {
                    System.out.println("curves=" + blArray[n19] + ' ' + blArray[n20] + ' ' + blArray[n21] + " EndOfContour j-1=" + blArray2[i - 1] + " j=" + blArray2[i] + " j+1=" + blArray2[i + 1]);
                } else {
                    System.out.println("curves=" + blArray[n19] + ' ' + blArray[n20] + ' ' + blArray[n21] + " EndOfContour j=" + blArray2[i] + " j+1=" + blArray2[i + 1]);
                }
            }
            if (n17 == n5 && blArray[n19]) {
                i = n3;
                if (!bl) continue;
                System.out.println("last 2 match");
                continue;
            }
            if (bl) {
                System.out.println(n5 + " " + n22 + ' ' + n19 + ' ' + n20 + ' ' + n21);
            }
            if (blArray[n19] && blArray[n20]) {
                n12 = nArray[n20];
                n13 = nArray2[n20];
                generalPath.lineTo(n12, n13);
                if (bl) {
                    System.out.println(n19 + " pt,pt " + n12 + ' ' + n13 + " (lineTo)");
                }
                n6 = 0;
            } else if (i < n3 - 3 && (n5 - n17 > 1 || n5 == n17)) {
                n18 = 0;
                if (blArray[n19] && !blArray[n20] && blArray[n21]) {
                    n2 = nArray[n19];
                    n14 = nArray2[n19];
                    n11 = nArray[n20];
                    n4 = nArray2[n20];
                    n12 = nArray[n21];
                    n13 = nArray2[n21];
                    ++i;
                    n18 = 1;
                    if (bl) {
                        System.out.println(n19 + " pt,cv,pt " + n2 + ' ' + n14 + ' ' + n11 + ' ' + n4 + ' ' + n12 + ' ' + n13);
                    }
                } else if (blArray[n19] && !blArray[n20] && !blArray[n21]) {
                    n2 = nArray[n19];
                    n14 = nArray2[n19];
                    n11 = nArray[n20];
                    n4 = nArray2[n20];
                    n12 = TTGlyph.midPt(nArray[n20], nArray[n21]);
                    n13 = TTGlyph.midPt(nArray2[n20], nArray2[n21]);
                    ++i;
                    n18 = 1;
                    if (bl) {
                        System.out.println(n19 + " pt,cv,cv " + n2 + ' ' + n14 + ' ' + n11 + ' ' + n4 + ' ' + n12 + ' ' + n13);
                    }
                } else if (!(blArray[n19] || blArray[n20] || blArray2[n21] && n5 - n21 != 1)) {
                    n2 = TTGlyph.midPt(nArray[n22], nArray[n19]);
                    n14 = TTGlyph.midPt(nArray2[n22], nArray2[n19]);
                    n11 = nArray[n19];
                    n4 = nArray2[n19];
                    n12 = TTGlyph.midPt(nArray[n19], nArray[n20]);
                    n13 = TTGlyph.midPt(nArray2[n19], nArray2[n20]);
                    if (bl) {
                        System.out.println(n19 + " cv,cv1 " + n2 + ' ' + n14 + ' ' + n11 + ' ' + n4 + ' ' + n12 + ' ' + n13);
                    }
                } else if (!blArray[n19] && blArray[n20]) {
                    n2 = TTGlyph.midPt(nArray[n22], nArray[n19]);
                    n14 = TTGlyph.midPt(nArray2[n22], nArray2[n19]);
                    n11 = nArray[n19];
                    n4 = nArray2[n19];
                    n12 = nArray[n20];
                    n13 = nArray2[n20];
                    if (bl) {
                        System.out.println(n19 + " cv,pt " + n2 + ' ' + n14 + ' ' + n11 + ' ' + n4 + ' ' + n12 + ' ' + n13);
                    }
                }
                if (n6 != 0) {
                    generalPath.moveTo(n2, n14);
                    n6 = 0;
                    if (bl) {
                        System.out.println("first draw move to " + n2 + " " + n14);
                    }
                }
                if (!blArray2[n19] || n19 <= 0 || !blArray2[n19 - 1]) {
                    generalPath.curveTo(n2, n14, n11, n4, n12, n13);
                }
                if (bl) {
                    System.out.println("curveto " + n2 + " " + n14 + " " + n11 + " " + n4 + " " + n12 + " " + n13);
                }
                if (n18 != 0 && blArray2[i]) {
                    bl2 = true;
                    n15 = nArray[n5];
                    n16 = nArray2[n5];
                    n17 = n5;
                    for (int j = i + 1; j < n3; ++j) {
                        if (!blArray2[j]) continue;
                        n5 = j + 1;
                        j = n3;
                    }
                    if (bl) {
                        System.out.println("Curve");
                    }
                }
            }
            if (blArray2[n19]) {
                generalPath.closePath();
            }
            if (bl) {
                System.out.println("x2 " + n15 + ' ' + n16 + ' ' + bl2);
            }
            if (bl2) {
                generalPath.moveTo(n15, n16);
                bl2 = false;
                if (bl) {
                    System.out.println("Move to " + n15 + ' ' + n16);
                }
            }
            if (!bl) continue;
            try {
                if (this.img == null) {
                    this.img = new BufferedImage(800, 800, 2);
                }
                Graphics2D graphics2D = this.img.createGraphics();
                graphics2D.setColor(Color.green);
                graphics2D.draw(generalPath);
                String string = String.valueOf(n19);
                ShowGUIMessage.showGUIMessage(string, this.img, string);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.paths.addElement(generalPath);
        if (bl) {
            System.out.println("Ends at " + n2 + ' ' + n14 + " x=" + this.minX + "," + this.maxX + " y=" + this.minY + "," + this.maxY + " glyph x=" + this.compMinX + "," + this.compMaxX + " y=" + this.compMinY + "," + this.compMaxY);
        }
    }

    private static int midPt(int n, int n2) {
        return n + (n2 - n) / 2;
    }

    public float getmaxWidth() {
        return 0.0f;
    }

    public int getmaxHeight() {
        return 0;
    }

    public void lockColors(PdfPaint pdfPaint, PdfPaint pdfPaint2) {
    }

    public boolean ignoreColors() {
        return false;
    }

    public void flushArea() {
        this.glyphShape = null;
    }

    public void setWidth(float f) {
    }

    public int getFontBB(int n) {
        if (this.isComposite) {
            if (n == 1) {
                return this.compMinX;
            }
            if (n == 2) {
                return this.compMinY;
            }
            if (n == 3) {
                return this.compMaxX;
            }
            if (n == 4) {
                return this.compMaxY;
            }
            return 0;
        }
        if (n == 1) {
            return this.minX;
        }
        if (n == 2) {
            return this.minY;
        }
        if (n == 3) {
            return this.maxX;
        }
        if (n == 4) {
            return this.maxY;
        }
        return 0;
    }

    public void setStrokedOnly(boolean bl) {
    }

    public boolean containsBrokenData() {
        return this.containsBrokenGlyfData;
    }

    static {
        String string = System.getProperty("org.jpedal.useTTFontHinting");
        if (string != null) {
            useHinting = string.toLowerCase().equals("true");
        }
        testedFonts = new HashSet();
    }
}

