/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output;

import java.awt.Rectangle;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.output.FontMapper;
import org.jpedal.render.output.OutputDisplay;

public class TextBlock {
    private float xCoord;
    private float yCoord;
    private float yAdjust;
    private float lastXCoord;
    private float lastYCoord;
    private float stringWidth;
    boolean putTextOnCanvas;
    private Rectangle cropBox;
    private int fontSize;
    private String font = "";
    private String weight = "normal";
    private String style = "normal";
    private float spaceWidth;
    private int fontAdjust = 0;
    private String text;
    private int textColRGB;
    private float[][] matrix;
    private float pageRotationInRadians;
    private float[][] Trm;
    private float lastYUsed;
    private float lastX = 0.0f;
    private int maxSpacesAllowed = 3;
    private float[][] ctm;
    boolean convertSpacesTonbsp;
    int altFontSize;
    int fontCondition = -1;

    public TextBlock(boolean bl) {
        this.putTextOnCanvas = bl;
        this.text = "";
        this.textColRGB = -1;
        this.stringWidth = 0.0f;
    }

    private TextBlock() {
    }

    public int getAltFontSize() {
        return this.altFontSize;
    }

    public TextBlock(String string, int n, FontMapper fontMapper, float[][] fArray, float f, float f2, float f3, int n2, float f4, Rectangle rectangle, boolean bl, float f5, float[][] fArray2, float[][] fArray3, int n3, int n4) {
        this.text = string;
        this.matrix = fArray;
        this.xCoord = f;
        this.yCoord = f2;
        this.stringWidth = f3;
        this.lastXCoord = f + f3;
        this.fontSize = n;
        this.font = fontMapper.getFont();
        this.weight = fontMapper.getWeight();
        this.style = fontMapper.getStyle();
        this.fontAdjust = fontMapper.getFontSizeAdjustment();
        this.textColRGB = n2;
        this.spaceWidth = f4;
        this.putTextOnCanvas = bl;
        this.cropBox = rectangle;
        this.pageRotationInRadians = f5;
        this.Trm = fArray2;
        this.ctm = fArray3;
        this.altFontSize = n3;
        this.fontCondition = n4;
        this.lastX = fArray2[2][0];
        if (!rectangle.contains(f + f3, f2)) {
            this.text = "";
        }
    }

    public boolean isEmpty() {
        return this.text.length() == 0;
    }

    public float getX() {
        return this.xCoord;
    }

    public float getY() {
        return this.yCoord + this.yAdjust;
    }

    public void adjustY(float f) {
        this.yAdjust = f;
    }

    private void setWidth(float f) {
        this.stringWidth = f;
    }

    public float getWidth() {
        return this.stringWidth;
    }

    private void setLastX(float f) {
        this.lastXCoord = f;
    }

    public float getLastX() {
        return this.lastXCoord;
    }

    public int getFontSize() {
        if (this.matrix != null && this.matrix[0][0] * this.matrix[0][1] != 0.0f) {
            float f;
            float f2;
            float f3;
            float f4 = this.matrix[0][0];
            if (f4 < 0.0f) {
                f4 = -f4;
            }
            if ((f3 = this.matrix[0][1]) < 0.0f) {
                f3 = -f3;
            }
            float f5 = (f2 = f4 + (float)this.fontSize * f3) > (f = (float)this.fontSize * f4 + f3) ? f2 : f;
            return (int)Math.ceil(Math.abs(f5) / (float)this.fontSize);
        }
        return this.fontSize;
    }

    public String getFont() {
        return this.font;
    }

    public String getWeight() {
        return this.weight;
    }

    public int getColor() {
        return this.textColRGB;
    }

    private boolean compareTrm(float[][] fArray) {
        if (this.matrix == null) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 2; ++j) {
                if (fArray[j][i] == this.matrix[j][i]) continue;
                return false;
            }
        }
        return true;
    }

    public float getRotationAngle() {
        float f = Math.abs(this.matrix[0][0]) + Math.abs(this.matrix[0][1]);
        float f2 = (float)Math.acos(this.matrix[0][0] / f);
        if (f2 != 0.0f && this.matrix[1][0] < 0.0f && this.matrix[0][1] > 0.0f) {
            f2 = -f2;
        }
        return f2 + this.pageRotationInRadians;
    }

    public int getRotationAngleInDegrees() {
        int n;
        for (n = (int)((double)(this.getRotationAngle() * 180.0f) / Math.PI); n < 0; n += 360) {
        }
        return n;
    }

    private void concat(String string) {
        if (this.putTextOnCanvas) {
            String[] stringArray = new String[]{"\""};
            for (int i = 0; i < stringArray.length; ++i) {
                string = string.replace(stringArray[i], "\\" + stringArray[i]);
            }
        }
        this.text = this.text + string;
    }

    public String getOutputString(boolean bl) {
        String string = this.text;
        if (bl && OutputDisplay.Helper != null) {
            string = OutputDisplay.Helper.tidyText(string);
            if (this.convertSpacesTonbsp) {
                string = string.replaceAll(" ", "&nbsp;");
            }
        }
        return string;
    }

    public boolean isSameFont(int n, FontMapper fontMapper, float[][] fArray, int n2) {
        float f = this.fontSize < 18 || n < 18 ? 0.0f : (this.fontSize < n ? (float)this.fontSize / (float)n : (float)n / (float)this.fontSize);
        return (this.compareTrm(fArray) && this.fontSize == n || f > 0.8f) && this.compareFontMapper(fontMapper) && this.textColRGB == n2;
    }

    private boolean compareFontMapper(FontMapper fontMapper) {
        return fontMapper.getFont().equals(this.font) && fontMapper.getWeight().equals(this.weight);
    }

    public boolean appendText(int n, String string, float f, float f2, float f3, boolean bl, boolean bl2, boolean bl3) {
        if (!this.cropBox.contains(f2, f3)) {
            return false;
        }
        float f4 = this.yCoord - f3;
        if (Math.abs(f4) < 0.001f) {
            f4 = 0.0f;
        }
        float f5 = f2 - this.lastXCoord;
        if (!bl2 && string.equals(" ") && f4 == 0.0f && f5 < -f) {
            return true;
        }
        if (!bl2 && !bl && string.equals(" ")) {
            return false;
        }
        if (f5 < 0.0f && f5 > -f) {
            f5 = 0.0f;
        }
        if (this.Trm[0][0] == 0.0f && this.Trm[1][1] == 0.0f && this.Trm[0][1] > 0.0f && this.Trm[1][0] < 0.0f) {
            if (this.ctm[0][0] == 0.0f && this.ctm[1][1] == 0.0f) {
                int n2 = (int)Math.abs(this.lastX - f2);
                if (n2 > 2) {
                    return false;
                }
                this.lastX = f2;
            } else {
                float f6 = (this.lastYUsed - f3) / (float)this.fontSize;
                if ((double)f6 > 1.5) {
                    return false;
                }
                if (!(this.Trm[0][0] == 0.0f && this.Trm[1][1] == 0.0f && this.lastX == f2 && n == 0 || f4 == 0.0f && !(f5 < -1.5f) || n != 0)) {
                    return false;
                }
            }
        } else if (f4 != 0.0f || f5 < -1.5f) {
            return false;
        }
        String string2 = "";
        int n3 = (int)(f5 / this.spaceWidth);
        float f7 = f5 % this.spaceWidth;
        f7 /= this.spaceWidth;
        if (f7 > PdfStreamDecoder.currentThreshold) {
            ++n3;
        }
        if ((bl3 || n3 > this.maxSpacesAllowed) && (!bl ? n3 > 2 || n3 > 0 && this.matrix[0][0] == 0.0f && this.matrix[1][1] == 0.0f : n3 > 3 || f7 > 0.25f && f7 < PdfStreamDecoder.currentThreshold)) {
            return false;
        }
        while (n3-- > 0) {
            string2 = string2 + " ";
        }
        string2 = string2 + string;
        this.concat(string2);
        if (this.Trm[0][0] == 0.0f && this.Trm[1][1] == 0.0f && this.Trm[0][1] > 0.0f && this.Trm[1][0] < 0.0f) {
            this.stringWidth = this.yCoord - f3 + f;
            this.lastYCoord = f3 + f;
        } else {
            this.stringWidth = f2 - this.xCoord + f;
            this.lastXCoord = f2 + f;
        }
        this.lastYUsed = f3;
        return true;
    }

    public boolean hasSameFont(TextBlock textBlock) {
        return this.font.equals(textBlock.font) && this.weight.equals(textBlock.weight) && this.getFontSize() == textBlock.getFontSize();
    }

    public String getStyle() {
        return this.style;
    }

    public String toString() {
        String string = "text[" + this.text + "]\tfontSize[" + this.fontSize + "]\tspaceWidth[" + this.spaceWidth + "]\tcoord[" + this.xCoord + ", " + this.yCoord + "]";
        return string;
    }

    public int getFontAdjustment() {
        return this.fontAdjust;
    }

    public static boolean ignoreGlyf(String string) {
        return string.codePointAt(0) == 65533;
    }

    public void convertSpacesTonbsp(boolean bl) {
        this.convertSpacesTonbsp = bl;
    }

    public int getFontCondition() {
        return this.fontCondition;
    }
}

