/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.model;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public final class CropFinder {
    private static final double RATIO_LOOK_AHEAD_SATISFY = 0.85;
    private static final int LOOK_AHEAD_PIXEL_NR = 30;
    private static final int SD_CALC_SIZE_NR = 5;
    private static final float SD_THRESHOLD_TO_BE_COUNTED = 0.2f;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int ORIENTATION_LEFT = 0;
    public static final int ORIENTATION_TOP = 1;
    public static final int ORIENTATION_RIGHT = 2;
    public static final int ORIENTATION_BOTTOM = 3;

    private CropFinder() {
    }

    public static Float[] getAutoCropFloats(BufferedImage image) {
        WritableRaster raster = image.getRaster();
        double[] sumX = CropFinder.sumFrom2dTo1d(raster, 0);
        double[] sumY = CropFinder.sumFrom2dTo1d(raster, 1);
        double[] derivationX = CropFinder.createDerivation(sumX);
        double[] derivationY = CropFinder.createDerivation(sumY);
        double[] sdOfDerivationX = CropFinder.createSdOfDerivation(derivationX);
        double[] sdOfDerivationY = CropFinder.createSdOfDerivation(derivationY);
        int positionXLeft = CropFinder.findPosition(sdOfDerivationX, 0);
        int positionYTop = CropFinder.findPosition(sdOfDerivationY, 1);
        int positionXRight = CropFinder.findPosition(sdOfDerivationX, 2);
        int positionYBottom = CropFinder.findPosition(sdOfDerivationY, 3);
        Float[] result = new Float[]{Float.valueOf((float)positionXLeft / (float)image.getWidth()), Float.valueOf((float)(image.getHeight() - positionYBottom) / (float)image.getHeight()), Float.valueOf((float)(image.getWidth() - positionXRight) / (float)image.getWidth()), Float.valueOf((float)positionYTop / (float)image.getHeight())};
        return result;
    }

    private static double[] sumFrom2dTo1d(WritableRaster raster, int axis) {
        if (axis == 0) {
            double[] values = new double[raster.getWidth()];
            int i = 0;
            while (i < raster.getWidth()) {
                int[] tmp = null;
                int[] nArray = tmp = raster.getPixels(i, 0, 1, raster.getHeight(), tmp);
                int n = tmp.length;
                int n2 = 0;
                while (n2 < n) {
                    int element = nArray[n2];
                    int n3 = i;
                    values[n3] = values[n3] + (double)element;
                    ++n2;
                }
                int n4 = i++;
                values[n4] = values[n4] / (double)raster.getHeight();
            }
            return values;
        }
        if (axis == 1) {
            double[] values = new double[raster.getHeight()];
            int i = 0;
            while (i < raster.getHeight()) {
                int[] tmp = null;
                int[] nArray = tmp = raster.getPixels(0, i, raster.getWidth(), 1, tmp);
                int n = tmp.length;
                int n5 = 0;
                while (n5 < n) {
                    int element = nArray[n5];
                    int n6 = i;
                    values[n6] = values[n6] + (double)element;
                    ++n5;
                }
                int n7 = i++;
                values[n7] = values[n7] / (double)raster.getWidth();
            }
            return values;
        }
        return null;
    }

    private static double[] createDerivation(double[] values) {
        double[] derivedValues = new double[values.length - 1];
        int i = 0;
        while (i < derivedValues.length) {
            derivedValues[i] = values[i + 1] - values[i];
            ++i;
        }
        return derivedValues;
    }

    private static int findPosition(double[] sds, int orientationLeft) {
        int position = 0;
        block0 : switch (orientationLeft) {
            case 1: {
                int i = 0;
                while (i < sds.length - 30) {
                    int cnt = CropFinder.diffCounter(sds, i, i + 30);
                    if ((double)cnt > 25.5) {
                        position = i;
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 0: {
                int i = 0;
                while (i < sds.length - 30) {
                    int cnt = CropFinder.diffCounter(sds, i, i + 30);
                    if ((double)cnt > 25.5) {
                        position = i;
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 3: {
                int i = sds.length - 1;
                while (i >= 30) {
                    int cnt = CropFinder.diffCounter(sds, i - 30, i);
                    if ((double)cnt > 25.5) {
                        position = i;
                        break block0;
                    }
                    --i;
                }
                break;
            }
            case 2: {
                int i = sds.length - 1;
                while (i >= 30) {
                    int cnt = CropFinder.diffCounter(sds, i - 30, i);
                    if ((double)cnt > 25.5) {
                        position = i;
                        break block0;
                    }
                    --i;
                }
                break;
            }
        }
        return position;
    }

    private static double[] createSdOfDerivation(double[] diffOut) {
        double[] sds = new double[diffOut.length];
        int i = 0;
        while (i < diffOut.length) {
            double[] tmp = new double[5];
            int j = 0;
            while (j < tmp.length) {
                tmp[j] = i + j < diffOut.length ? diffOut[i + j] : 0.0;
                ++j;
            }
            sds[i] = CropFinder.sd(tmp);
            ++i;
        }
        return sds;
    }

    private static int diffCounter(double[] values, int start, int end) {
        int cnt = 0;
        int i = start;
        while (i < end) {
            if (values[i] > (double)0.2f) {
                ++cnt;
            }
            ++i;
        }
        return cnt;
    }

    private static double sd(double[] values) {
        double mean = 0.0;
        double sum = 0.0;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            sum += value;
            ++n2;
        }
        mean = sum / (double)values.length;
        double sd = 0.0;
        double[] dArray2 = values;
        int n3 = values.length;
        int n4 = 0;
        while (n4 < n3) {
            double value = dArray2[n4];
            sd += (value - mean) * (value - mean);
            ++n4;
        }
        sd = Math.sqrt(sd / (double)values.length);
        return sd;
    }
}

