#ifndef TRAYHOTKEY_H
    #define TRAYHOTKEY_H
    #define _UNICODE
    #define UNICODE
    #define _WIN32_WINNT 0x0500
    #define _WIN32_IE 0x0500
    #ifndef WINDOWS_H
        #include <windows.h>
    #endif
    #ifndef TCHAR_H
        #include <tchar.h>
    #endif
    #define EXPORT __declspec(dllexport)

#define WM_TRAYMESSAGE WM_USER+0x1000
#define WINMAX 64
#define PATHMAX 256
#define TITLEMAX 15
#define IDM_SYS_TOP 0x08

static BOOL  minimizeToFm = FALSE; /* 最小化交换内存 */
static BOOL  singleMode = FALSE; /* 单窗口模式 */
static HWND  singlehWnd = 0; /* 单窗口模式下的活动窗口句柄 */
static BOOL  hotKeyState, trayState, foreground;
static BOOL  alawysShowTray, minimizeToTray, closeToTray;
static BOOL  transState = FALSE;  /* 鼠标穿透选项 */
static BOOL  transStatus = FALSE; /* 鼠标穿透状态 */
static TCHAR icoPath[PATHMAX] = {L'\0'};
static HWND  msghWnd;
static DWORD keyCode, transKC;
static BOOL  windowState = TRUE; /* 1(true):show or 0(false):hide */
static HICON hIcon; /* 托盘图标句柄 */
static ATOM  hotKeyID, transID;
static int   wincount;// hwincount; /* 当前窗口数 */
static TCHAR trayStr[6][PATHMAX] = {{L'\0'}};
static TCHAR winTitle[WINMAX][TITLEMAX+5] = {{L'\0'}};
static BOOL  hotKeyChecked, opacityChecked, transChecked;
static BYTE  opacityValue, transValue;
static WNDPROC lpfnOldWndProc = 0;
static LONG  lpSubClassFun;

static BOOL  windTop = FALSE; /* TRUE: 启用 FALSE: 禁用 */

typedef struct {
    HWND hWnd; /* 窗口句柄 */
    BOOL hidden; /* 窗口状态 TRUE:隐藏 FALSE:显示 */
    BOOL occupied; /* 是否占用该结构 */
    BOOL subclassed; /* 窗口是否已子类化 */
} WIN;
static WIN win[WINMAX] = {{0, FALSE, FALSE, FALSE}};

/* struce */
static WNDCLASS wndclass;
static NOTIFYICONDATA nid;

LRESULT CALLBACK WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK SubClassFunc(HWND, UINT, WPARAM, LPARAM);

void EXPORT init(void);
void EXPORT initWin(void);
BOOL EXPORT initOpacity(BOOL, WORD, BOOL, DWORD);
BOOL EXPORT trayHotKey(TCHAR [], TCHAR [][PATHMAX], BYTE, BOOL, DWORD);
BOOL EXPORT setHotKey(BYTE, DWORD);
void EXPORT setOpacity(BOOL, BYTE, int); /* TRUE:OPACITY FALSE:TRANSHOTKEY */
/* BYTE
 * @0x01 : alawysShowTray change
 * @0x02 : minimizeToTray change
 * @0x04 : closeToTray    change
 * @0x08 : foreground     change
 */
void EXPORT setTray(BYTE, BOOL);
void EXPORT quit(void);
BOOL EXPORT onWinTop(TCHAR []);
void setMinimizeToFm(BOOL);

void quitApp(void);
void onSingleWin(void);
void onHotKey(void);
void onTrans(void);
void onTray(int);
void initPopupMenu(LPARAM);
void updatehWnds(void);
void closeWin(HWND);
void ToTray(HWND);
void winSubClass(void);
void addMenu(HWND, HMENU);
void setWinTop(HWND);
void fixMinimizeWinTop(HWND);
void updataTopChecked(HWND);
BOOL _strcmp(TCHAR * title);
int  winIndex(HWND);

#endif
