local assets =
{
	Asset("ANIM", "data/anim/gravestones.zip"),
}

local prefabs = 
{
	"ghost",
	"mound", 
}
local buildsound="dontstarve/common/place_structure_stone"
local destroysound="dontstarve/common/destroy_stone"
local function onsave(inst, data)
	
	if inst.mound then
		data.mounddata = inst.mound:GetSaveRecord()
	end

	if inst.setepitaph then
		data.setepitaph = inst.setepitaph
	end
end	

local function onload(inst, data, newents)
	if data then
		if inst.mound and data.mounddata then
	        if newents and data.mounddata.id then
	            newents[data.mounddata.id] = {entity=inst.mound, data=data.mounddata} 
	        end
			inst.mound:SetPersistData(data.mounddata.data, newents)
		end

		if data.setepitaph then	
			--this handles custom epitaphs set in the tile editor		
	    	inst.components.inspectable:SetDescription("'"..data.setepitaph.."'")
	    	inst.setepitaph = data.setepitaph
		end
	end
end	

local function onhit(inst)
	--inst.SoundEmitter:PlaySound(destroysound)		
end

local function onhammered(inst, worker)
	local pt=Point(inst.Transform:GetWorldPosition())
	
	if math.random() < 0.8 then
		inst.components.lootdropper:DropLoot(pt)
	end

	if math.random() < 0.3 then
		local player=GetPlayer()
		local player_pt=Point(player.Transform:GetWorldPosition())
		local x=math.random(-5,5)
		local y=math.random(-5,5)
		player_pt.x=player_pt.x+x
		player_pt.y=player_pt.y+y
		GetWorld().components.seasonmanager:DoLightningStrike(player_pt)
		local range = math.sqrt(x*x+y*x)
		if range<=3 then
			local damage=math.random(10,50)
			local data={
				oldpercent=player.components.health:GetPercent()
			}
			local currenthealth=player.components.health.currenthealth-damage
			if currenthealth<=0 then
				inst.SoundEmitter:PlaySound(destroysound)
				inst:Remove()		
			end
			player.components.health:SetVal(currenthealth)
			data.newpercent=player.components.health:GetPercent()
			player:PushEvent("healthdelta",data)
		end
	end
	inst.SoundEmitter:PlaySound(destroysound)
	inst:Remove()
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local minimap = inst.entity:AddMiniMapEntity()
	inst.entity:AddSoundEmitter()

	minimap:SetIcon( "gravestones.png" )

    MakeObstaclePhysics(inst, .25)
    
    anim:SetBank("gravestone")
    anim:SetBuild("gravestones")
    anim:PlayAnimation("grave" .. tostring( math.random(4)))

    inst:AddComponent("inspectable")	
    inst.components.inspectable:SetDescription( STRINGS.EPITAPHS[math.random(#STRINGS.EPITAPHS)] )	    	
    
	inst:AddTag("grave")
	--lootdropper
	inst:AddComponent("lootdropper") 
	inst.components.lootdropper:SetLoot({"rocks"}) --Add other loot?
	inst.components.lootdropper:AddChanceLoot("marble", 0.6)
	inst.components.lootdropper:AddChanceLoot("rocks", 0.8)
	inst.components.lootdropper:AddChanceLoot("marble", 0.4)
	inst.components.lootdropper:AddChanceLoot("redgem", 0.2)
	inst.components.lootdropper:AddChanceLoot("bluegem", 0.2)
	--workable
	inst:AddComponent("workable")
	inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
	inst.components.workable:SetWorkLeft(3)
	inst.components.workable:SetOnFinishCallback(onhammered)
	inst.components.workable:SetOnWorkCallback(onhit) 

    inst.mound = inst:SpawnChild("mound")

    --local pos = Vector3(0,0,0)
    --pos.x = pos.x -.407
    --pos.z = pos.z -.407
    
	inst.OnLoad = onload
	inst.OnSave = onsave
    
    inst.mound.Transform:SetPosition((TheCamera:GetDownVec()*.5):Get())
     
    return inst
end

return Prefab( "common/objects/gravestone", fn, assets, prefabs )
