require("tuning")
local MakeVegStats = function(seedweight, hunger, health, perish_time, sanity, cooked_hunger, cooked_health, cooked_perish_time, cooked_sanity)
  return {
    health = health,
    hunger = hunger,
    cooked_health = cooked_health,
    cooked_hunger = cooked_hunger,
    seed_weight = seedweight,
    perishtime = perish_time,
    cooked_perishtime = cooked_perish_time,
    sanity = sanity,
    cooked_sanity = cooked_sanity
  }
end
local COMMON = 3
local UNCOMMON = 1
local RARE = 0.5
VEGGIES = {
  carrot = MakeVegStats(COMMON, TUNING.CALORIES_SMALL, TUNING.HEALING_TINY, TUNING.PERISH_MED, 0, TUNING.CALORIES_SMALL, TUNING.HEALING_SMALL, TUNING.PERISH_FAST, 0),
  corn = MakeVegStats(COMMON, TUNING.CALORIES_MED, TUNING.HEALING_SMALL, TUNING.PERISH_MED, 0, TUNING.CALORIES_SMALL, TUNING.HEALING_SMALL, TUNING.PERISH_SLOW, 0),
  pumpkin = MakeVegStats(UNCOMMON, TUNING.CALORIES_LARGE, TUNING.HEALING_SMALL, TUNING.PERISH_MED, 0, TUNING.CALORIES_LARGE, TUNING.HEALING_MEDSMALL, TUNING.PERISH_FAST, 0),
  eggplant = MakeVegStats(UNCOMMON, TUNING.CALORIES_MED, TUNING.HEALING_MEDSMALL, TUNING.PERISH_MED, 0, TUNING.CALORIES_MED, TUNING.HEALING_MED, TUNING.PERISH_FAST, 0),
  durian = MakeVegStats(RARE, TUNING.CALORIES_MED, -TUNING.HEALING_SMALL, TUNING.PERISH_MED, -TUNING.SANITY_TINY, TUNING.CALORIES_MED, 0, TUNING.PERISH_FAST, -TUNING.SANITY_TINY),
  pomegranate = MakeVegStats(RARE, TUNING.CALORIES_TINY, TUNING.HEALING_SMALL, TUNING.PERISH_FAST, 0, TUNING.CALORIES_SMALL, TUNING.HEALING_MED, TUNING.PERISH_SUPERFAST, 0),
  dragonfruit = MakeVegStats(RARE, TUNING.CALORIES_TINY, TUNING.HEALING_SMALL, TUNING.PERISH_FAST, 0, TUNING.CALORIES_SMALL, TUNING.HEALING_MED, TUNING.PERISH_SUPERFAST, 0),
  berries = MakeVegStats(0, TUNING.CALORIES_TINY, 0, TUNING.PERISH_FAST, 0, TUNING.CALORIES_SMALL, TUNING.HEALING_TINY, TUNING.PERISH_SUPERFAST, 0)
}
local MakeVeggie = function(name, has_seeds)
  local assets = {
    Asset("ANIM", "data/anim/" .. name .. ".zip"),
    Asset("IMAGE", "data/inventoryimages/" .. name .. ".tex")
  }
  local assets_cooked = {
    Asset("ANIM", "data/anim/" .. name .. ".zip"),
    Asset("IMAGE", "data/inventoryimages/" .. name .. "_cooked.tex")
  }
  local assets_seeds = {
    Asset("ANIM", "data/anim/seeds.zip"),
    Asset("IMAGE", "data/inventoryimages/" .. name .. "_seeds.tex"),
    Asset("IMAGE", "data/inventoryimages/seeds_cooked.tex")
  }
  local prefabs = {
    name .. "_cooked",
    "spoiled_food"
  }
  if has_seeds then
    table.insert(prefabs, name .. "_seeds")
  end
  local function fn_seeds()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    inst.AnimState:SetBank("seeds")
    inst.AnimState:SetBuild("seeds")
    inst.AnimState:SetRayTestOnBB(true)
    inst:AddComponent("edible")
    inst.components.edible.foodtype = "SEEDS"
    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
    inst:AddComponent("tradable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst.AnimState:PlayAnimation("idle")
    inst.components.edible.healthvalue = TUNING.HEALING_TINY / 2
    inst.components.edible.hungervalue = TUNING.CALORIES_TINY

    inst:AddComponent("cookable")
    inst.components.cookable.product = "seeds_cooked"
    inst:AddComponent("bait")
    inst:AddComponent("plantable")
    inst.components.plantable.growtime = TUNING.SEEDS_GROW_TIME
    inst.components.plantable.product = name
    return inst
  end
  local function fn(Sim)
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    inst.AnimState:SetBank(name)
    inst.AnimState:SetBuild(name)
    inst.AnimState:PlayAnimation("idle")
    inst:AddComponent("edible")
    inst.components.edible.healthvalue = VEGGIES[name].health
    inst.components.edible.hungervalue = VEGGIES[name].hunger
    inst.components.edible.sanityvalue = VEGGIES[name].sanity or 0
    inst.components.edible.foodtype = "VEGGIE"

    inst:AddComponent("stackable")
    local is_big = name == "pumpkin" or name == "eggplant" or name == "durian"
    if not is_big then
      inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
    end
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    MakeSmallBurnable(inst)
    MakeSmallPropagator(inst)
    inst:AddComponent("bait")
    inst:AddComponent("tradable")
    inst:AddComponent("cookable")
    inst.components.cookable.product = name .. "_cooked"
    return inst
  end
  local function fn_cooked(Sim)
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    inst.AnimState:SetBank(name)
    inst.AnimState:SetBuild(name)
    inst.AnimState:PlayAnimation("cooked")

    inst:AddComponent("edible")
    inst.components.edible.healthvalue = VEGGIES[name].cooked_health
    inst.components.edible.hungervalue = VEGGIES[name].cooked_hunger
    inst.components.edible.sanityvalue = VEGGIES[name].cooked_sanity or 0
    inst.components.edible.foodtype = "VEGGIE"
    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    MakeSmallBurnable(inst)
    MakeSmallPropagator(inst)
    inst:AddComponent("bait")
    inst:AddComponent("tradable")
    return inst
  end
  local base = Prefab("common/inventory/" .. name, fn, assets, prefabs)
  local cooked = Prefab("common/inventory/" .. name .. "_cooked", fn_cooked, assets_cooked)
  local seeds = has_seeds and Prefab("common/inventory/" .. name .. "_seeds", fn_seeds, assets_seeds) or nil
  return base, cooked, seeds
end
local prefs = {}
for veggiename, veggiedata in pairs(VEGGIES) do
  local veg, cooked, seeds = MakeVeggie(veggiename, veggiename ~= "berries")
  table.insert(prefs, veg)
  table.insert(prefs, cooked)
  if seeds then
    table.insert(prefs, seeds)
  end
end
return unpack(prefs)
