/*
 * Decompiled with CFR 0.152.
 */
package promidi;

import java.util.ArrayList;
import java.util.List;
import promidi.Controller;
import promidi.MidiIO;
import promidi.MidiOutDevice;
import promidi.Note;
import promidi.Plug;
import promidi.ProgramChange;

class MidiIn {
    final int midiChannel;
    private final MidiIO promidiContext;
    private final List plugEventList;
    private final List plugNoteList;
    private final List plugControllerList;
    private final List plugProgramChangeList;

    MidiIn(int i_midiChannel, MidiIO i_promidiContext) {
        this.midiChannel = i_midiChannel;
        this.promidiContext = i_promidiContext;
        this.plugEventList = new ArrayList();
        this.plugNoteList = new ArrayList();
        this.plugControllerList = new ArrayList();
        this.plugProgramChangeList = new ArrayList();
    }

    public boolean equals(Object object) {
        if (!(object instanceof MidiOutDevice)) {
            return false;
        }
        MidiIn midiOut = (MidiIn)object;
        return this.midiChannel == midiOut.midiChannel;
    }

    void plug(Object i_object, String i_methodName) {
        List plugList;
        Plug plug = new Plug(i_object, i_methodName);
        switch (plug.getParameterKind()) {
            case 0: {
                plugList = this.plugEventList;
                break;
            }
            case 1: {
                plugList = this.plugNoteList;
                break;
            }
            case 2: {
                plugList = this.plugControllerList;
                break;
            }
            case 3: {
                plugList = this.plugProgramChangeList;
                break;
            }
            default: {
                throw new RuntimeException("Error on plug " + i_methodName + " check the given event type");
            }
        }
        plugList.add(plug);
    }

    void sendController(Controller controller, int deviceNumber, int midiChannel) {
        try {
            if (this.promidiContext.controllerMethod != null) {
                this.promidiContext.controllerMethod.invoke((Object)this.promidiContext.parent, controller, new Integer(deviceNumber), new Integer(midiChannel));
            }
        }
        catch (Exception e) {
            System.err.println("Disabling controller() for " + this.promidiContext.parent.getName() + " because of an error.");
            e.printStackTrace();
            this.promidiContext.controllerMethod = null;
        }
        int i = 0;
        while (i < this.plugControllerList.size()) {
            ((Plug)this.plugControllerList.get(i)).callPlug(controller);
            ++i;
        }
    }

    void sendNoteOn(Note note, int deviceNumber, int midiChannel) {
        try {
            if (this.promidiContext.noteOnMethod != null) {
                this.promidiContext.noteOnMethod.invoke((Object)this.promidiContext.parent, note, new Integer(deviceNumber), new Integer(midiChannel));
            }
        }
        catch (Exception e) {
            System.err.println("Disabling noteOn() for " + this.promidiContext.parent.getName() + " because of an error.");
            e.printStackTrace();
            this.promidiContext.noteOnMethod = null;
        }
        int i = 0;
        while (i < this.plugNoteList.size()) {
            ((Plug)this.plugNoteList.get(i)).callPlug(note);
            ++i;
        }
    }

    void sendNoteOff(Note note, int deviceNumber, int midiChannel) {
        note.setToNoteOff();
        this.sendNoteOn(note, deviceNumber, midiChannel);
        try {
            if (this.promidiContext.noteOffMethod != null) {
                this.promidiContext.noteOffMethod.invoke((Object)this.promidiContext.parent, note, new Integer(deviceNumber), new Integer(midiChannel));
            }
        }
        catch (Exception e) {
            System.err.println("Disabling noteOff() for " + this.promidiContext.parent.getName() + " because of an error.");
            e.printStackTrace();
            this.promidiContext.noteOffMethod = null;
        }
        int i = 0;
        while (i < this.plugNoteList.size()) {
            ((Plug)this.plugNoteList.get(i)).callPlug(note);
            ++i;
        }
    }

    void sendProgramChange(ProgramChange programChange, int deviceNumber, int midiChannel) {
        try {
            if (this.promidiContext.programChangeMethod != null) {
                this.promidiContext.programChangeMethod.invoke((Object)this.promidiContext.parent, programChange, new Integer(deviceNumber), new Integer(midiChannel));
            }
        }
        catch (Exception e) {
            System.err.println("Disabling programChange() for " + this.promidiContext.parent.getName() + " because of an error.");
            e.printStackTrace();
            this.promidiContext.programChangeMethod = null;
        }
        int i = 0;
        while (i < this.plugProgramChangeList.size()) {
            ((Plug)this.plugProgramChangeList.get(i)).callPlug(programChange);
            ++i;
        }
    }
}

