/*
 * Decompiled with CFR 0.152.
 */
package promidi;

import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import promidi.Controller;
import promidi.InvalidMidiDataException;
import promidi.MidiDevice;
import promidi.MidiEvent;
import promidi.Note;
import promidi.ProgramChange;

class MidiOutDevice
extends MidiDevice {
    private final Receiver outputReceiver;

    MidiOutDevice(javax.sound.midi.MidiDevice midiDevice, int deviceNumber) throws MidiUnavailableException {
        super(midiDevice, deviceNumber);
        this.outputReceiver = midiDevice.getReceiver();
    }

    public void sendEvent(MidiEvent event) {
        if (event.getChannel() > 15 || event.getChannel() < 0) {
            throw new InvalidMidiDataException("You tried to send to midi channel" + event.getChannel() + ". With midi you only have the channels 0 - 15 available.");
        }
        this.outputReceiver.send(event, -1L);
    }

    public void sendController(Controller controller) {
        block3: {
            try {
                this.sendEvent(controller);
            }
            catch (InvalidMidiDataException e) {
                if (controller.getNumber() > 127 || controller.getNumber() < 0) {
                    throw new InvalidMidiDataException("You tried to send the controller number " + controller.getNumber() + ". With midi you only have the controller numbers 0 - 127 available.");
                }
                if (controller.getValue() <= 127 && controller.getValue() >= 0) break block3;
                throw new InvalidMidiDataException("You tried to send the controller value " + controller.getValue() + ". With midi you only have the controller values 0 - 127 available.");
            }
        }
    }

    public void sendNoteOn(Note note) {
        block3: {
            try {
                this.sendEvent(note);
            }
            catch (InvalidMidiDataException e) {
                if (note.getPitch() > 127 || note.getPitch() < 0) {
                    throw new InvalidMidiDataException("You tried to send a note with the pitch " + note.getPitch() + ". With midi you only have pitch values from 0 - 127 available.");
                }
                if (note.getVelocity() <= 127 && note.getVelocity() >= 0) break block3;
                throw new InvalidMidiDataException("You tried to send a note with the velocity " + note.getVelocity() + ". With midi you only have velocities values from 0 - 127 available.");
            }
        }
    }

    public void sendNoteOff(Note note) {
        note.setToNoteOff();
        this.sendNoteOn(note);
    }

    public void sendProgramChange(ProgramChange programChange) {
        block2: {
            try {
                this.sendEvent(programChange);
            }
            catch (InvalidMidiDataException e) {
                if (programChange.getNumber() <= 127 && programChange.getNumber() >= 0) break block2;
                throw new InvalidMidiDataException("You tried to send the program number " + programChange.getNumber() + ". With midi you only have the program numbers 0 - 127 available.");
            }
        }
    }
}

