/*
 * Decompiled with CFR 0.152.
 */
package promidi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.sound.midi.ShortMessage;
import promidi.MidiEvent;
import promidi.MidiOut;
import promidi.NoteOnCache;
import promidi.Song;
import promidi.TickMapEvents;

public class Pattern {
    private TickMapEvents tickMapEvents = new TickMapEvents();
    Vector controllerStateMessages;
    private HashMap controllerMap = new HashMap();
    private HashSet set = new HashSet();
    private NoteOnCache noteOnCache = new NoteOnCache();
    private String name;
    private Song song;
    private long length;
    private Pattern[] patterns = new Pattern[0];
    private Key[] keys = new Key[0];
    private int patternSize = 0;
    private int quantization = 1;

    public Pattern(String i_name, long i_length) {
        this.name = i_name;
        this.length = i_length;
        this.controllerStateMessages = new Vector();
        this.controllerStateMessages.ensureCapacity(128);
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.patterns.length;
        if (minCapacity > oldCapacity) {
            Pattern[] oldPattern = this.patterns;
            Key[] oldKeys = this.keys;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.patterns = new Pattern[newCapacity];
            this.keys = new Key[newCapacity];
            System.arraycopy(oldPattern, 0, this.patterns, 0, this.patternSize);
            System.arraycopy(oldKeys, 0, this.keys, 0, this.patternSize);
        }
    }

    private void checkLength() {
        this.length = this.tickMapEvents.getMaxTick();
        int i = 0;
        while (i < this.keys.length) {
            this.length = Math.max(this.length, this.keys[i].endTick);
            ++i;
        }
    }

    public void setQuantization(int i_quantization) {
        this.quantization = i_quantization;
    }

    public int getQuantization() {
        return this.quantization;
    }

    public void addPattern(Pattern i_pattern, long i_tick) {
        this.addPattern(i_pattern, i_tick, this.quantization);
    }

    public void addPattern(Pattern i_pattern, long i_tick, int i_quantization) {
        long startTick = (long)i_quantization * i_tick;
        long endTick = startTick + i_pattern.ticks();
        Key key = new Key(startTick, endTick);
        this.length = Math.max(this.length, endTick);
        this.ensureCapacity(this.patternSize + 1);
        this.patterns[this.patternSize] = i_pattern;
        this.keys[this.patternSize] = key;
        ++this.patternSize;
    }

    public void removePattern(Pattern i_pattern, long i_tick) {
        int i = 0;
        while (i < this.patternSize) {
            if (this.patterns[i].equals(i_pattern) && (this.keys[i].startTick == i_tick || i_tick == -1L)) {
                int numMoved = this.patterns.length - i - 1;
                if (numMoved > 0) {
                    System.arraycopy(this.patterns, i + 1, this.patterns, i, numMoved);
                    System.arraycopy(this.keys, i + 1, this.keys, i, numMoved);
                }
                --this.patternSize;
                this.patterns[this.patternSize] = null;
                this.keys[this.patternSize] = null;
            }
            ++i;
        }
        this.checkLength();
    }

    public void removePattern(Pattern i_pattern) {
        this.removePattern(i_pattern, -1L);
    }

    private void addEventToTickMap(MidiEvent i_event, long i_tick) {
        this.length = Math.max(i_tick, this.length);
        this.tickMapEvents.addEvent(i_event, i_tick);
        this.addToControllerMap(i_event, i_tick);
    }

    private void addToControllerMap(MidiEvent i_event, long i_tick) {
        try {
            if (i_event.getCommand() == 176) {
                int ccKey = (i_event.getChannel() & 0xF) << 8 | i_event.getData1() & 0xFF;
                TreeMap<Long, Integer> ccValues = (TreeMap<Long, Integer>)this.controllerMap.get(new Integer(ccKey));
                if (ccValues == null) {
                    ccValues = new TreeMap<Long, Integer>();
                    this.controllerMap.put(new Integer(ccKey), ccValues);
                }
                ccValues.put(new Long(i_tick), new Integer(i_event.getData2()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeFromControllerMap(MidiEvent i_event, long i_tick) {
        try {
            if (i_event.getCommand() == 176) {
                int ccKey = (i_event.getChannel() & 0xF) << 8 | i_event.getData1() & 0xFF;
                ((SortedMap)this.controllerMap.get(new Integer(ccKey))).remove(new Long(i_tick));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void sendEventsForTick(long i_tick, MidiOut i_midiOut) {
        Vector eventsForTick = this.tickMapEvents.getEventsForTick(i_tick);
        if (eventsForTick != null) {
            int j = 0;
            while (j < eventsForTick.size()) {
                MidiEvent event = (MidiEvent)eventsForTick.get(j);
                i_midiOut.sendEvent(event);
                ++j;
            }
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].tickIsInRange(i_tick)) {
                this.patterns[i].sendEventsForTick(i_tick, i_midiOut);
            }
            ++i;
        }
    }

    private synchronized Vector getControllerStateAtTick(long i_tick) {
        this.controllerStateMessages.clear();
        Set controllerMapKeys = this.controllerMap.keySet();
        Iterator it = controllerMapKeys.iterator();
        while (it.hasNext()) {
            int ccKey = (Integer)it.next();
            SortedMap ccValues = (SortedMap)this.controllerMap.get(new Integer(ccKey));
            try {
                int ccValue = (Integer)ccValues.get(ccValues.headMap(new Long(i_tick)).lastKey());
                ShortMessage shm = new ShortMessage();
                shm.setMessage(176, ccKey >> 8 & 0xF, ccKey & 0xFF, ccValue);
                this.controllerStateMessages.add(shm);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.controllerStateMessages;
    }

    void resetControllers(long i_tick, MidiOut i_midiOut) {
        Vector midiMessages = this.getControllerStateAtTick(i_tick);
        int j = 0;
        while (j < midiMessages.size()) {
            i_midiOut.sendEvent((MidiEvent)midiMessages.get(j));
            ++j;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].tickIsInRange(i_tick)) {
                this.patterns[i].resetControllers(i_tick, i_midiOut);
            }
            ++i;
        }
    }

    void flushNoteOnCache(MidiOut i_midiOut) {
        Vector notes = this.noteOnCache.getPendingNoteOffs();
        int i = 0;
        while (i < notes.size()) {
            int note = (Integer)notes.get(i);
            i_midiOut.sendEvent(144, note >> 8 & 0xF, note & 0xFF);
            ++i;
        }
        this.noteOnCache.releasePendingNoteOffs();
        i = 0;
        while (i < this.patterns.length) {
            this.patterns[i].flushNoteOnCache(i_midiOut);
            ++i;
        }
    }

    Song getSong() {
        return this.song;
    }

    void setSong(Song i_song) {
        this.song = i_song;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String i_name) {
        this.name = i_name;
    }

    public boolean addEvent(MidiEvent i_event, long i_tick) {
        if (i_event == null) {
            return false;
        }
        if (!this.set.contains(i_event)) {
            this.addEventToTickMap(i_event, i_tick * (long)this.quantization);
            this.set.add(i_event);
            return true;
        }
        return false;
    }

    public boolean removeEvent(MidiEvent i_event, long i_tick) {
        if (this.set.remove(i_event)) {
            this.tickMapEvents.removeEvent(i_event, i_tick);
            this.removeFromControllerMap(i_event, i_tick);
            this.length = this.tickMapEvents.getMaxTick();
            return true;
        }
        return false;
    }

    public int size() {
        return this.set.size();
    }

    public long ticks() {
        return this.length;
    }

    private static class Key {
        long startTick;
        long endTick;

        Key(long i_startTick, long i_endTick) {
            this.startTick = i_startTick;
            this.endTick = i_endTick;
        }

        boolean tickIsInRange(long i_tick) {
            return i_tick >= this.startTick && i_tick <= this.endTick;
        }
    }
}

