/*
 * Decompiled with CFR 0.152.
 */
package promidi;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import promidi.Song;
import promidi.SongPositionListener;
import promidi.Track;

public class Sequencer
implements Runnable {
    private Song song;
    private int loopCount;
    private long loopStartPoint;
    private long loopEndPoint;
    private float bpm;
    private boolean recording;
    private List songPositionListeners = new ArrayList();
    private boolean running;
    private boolean finished = true;
    static long startTimeMillis;
    private long lastTickPosition;
    private long startTickPosition;
    private long tickPosition;
    private int playedLoops;
    Thread playThread;
    public static final int LOOP_CONTINUOUSLY = -1;

    public void setSong(Song i_song) {
        this.song = i_song;
    }

    public void setSong(InputStream i_stream) throws IOException {
    }

    public Song getSong() {
        return this.song;
    }

    public void recordEnable(Track track, int channel) {
    }

    public void recordDisable(Track track) {
    }

    public float getTempoInBPM() {
        return this.song.getTempo();
    }

    public void setTempoInBPM(float bpm) {
        this.bpm = bpm;
    }

    public long getTickPosition() {
        return this.tickPosition;
    }

    public void setTickPosition(long tickPosition) {
        this.startTickPosition = tickPosition;
        startTimeMillis = System.currentTimeMillis();
        this.lastTickPosition = tickPosition;
    }

    public void setTrackMute(int track, boolean mute) {
    }

    public boolean getTrackMute(int track) {
        return false;
    }

    public void setTrackSolo(int track, boolean solo) {
    }

    public boolean getTrackSolo(int track) {
        return false;
    }

    public void setLoopStartPoint(long tick) {
        this.loopStartPoint = tick;
    }

    public long getLoopStartPoint() {
        return this.loopStartPoint;
    }

    public void setLoopEndPoint(long tick) {
        this.loopEndPoint = tick;
    }

    public long getLoopEndPoint() {
        return this.loopEndPoint;
    }

    public void loop() {
        this.setLoopCount(-1);
    }

    public void noLoop() {
        this.setLoopCount(0);
    }

    public void setLoopCount(int count) {
        this.loopCount = count;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public void addSongPositionListener(SongPositionListener songPositionListener) {
        this.songPositionListeners.add(songPositionListener);
    }

    final void notifySongPositionListeners(long tick) {
        int i = 0;
        while (i < this.songPositionListeners.size()) {
            ((SongPositionListener)this.songPositionListeners.get(i)).notifyTickPosition(tick);
            ++i;
        }
    }

    public void start() {
        this.running = false;
        while (!this.finished) {
            Thread.yield();
        }
        this.finished = false;
        this.running = true;
        this.playedLoops = 0;
        startTimeMillis = System.currentTimeMillis();
        this.tickPosition = this.startTickPosition;
        this.resetControllers();
        this.playThread = new Thread(this);
        this.playThread.setPriority(9);
        this.playThread.start();
    }

    public void stop() {
        this.recording = false;
        this.running = false;
        this.sendMidiPanic(false);
        this.startTickPosition = this.tickPosition;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void startRecording() {
        this.recording = true;
        this.start();
    }

    public void stopRecording() {
        this.stop();
    }

    public boolean isRecording() {
        return this.recording;
    }

    private void timerEvent() {
        long currentTick = this.startTickPosition + (long)((float)(System.currentTimeMillis() - startTimeMillis) * ((float)this.song.resolution * (this.getTempoInBPM() / 60000.0f)));
        long playTick = this.lastTickPosition;
        while (playTick <= currentTick) {
            this.tickPosition = this.getLoopCount() == -1 && this.startTickPosition < this.getLoopEndPoint() ? (playTick - this.getLoopStartPoint()) % (this.getLoopEndPoint() - this.getLoopStartPoint()) + this.getLoopStartPoint() : playTick;
            if (this.tickPosition == this.getLoopEndPoint() - 1L) {
                ++this.playedLoops;
            }
            if (this.playedLoops > 0 && this.tickPosition == this.getLoopStartPoint()) {
                this.flushNoteOnCache();
                this.resetControllers();
            }
            int i = 0;
            while (i < this.song.getNumberOfTracks()) {
                Track track = this.song.getTrack(i);
                track.sendEventsForTick(this.tickPosition);
                ++i;
            }
            this.notifySongPositionListeners(this.tickPosition);
            ++playTick;
        }
        this.lastTickPosition = currentTick + 1L;
    }

    private void resetControllers() {
        int i = 0;
        while (i < this.song.getNumberOfTracks()) {
            this.song.getTrack(i).resetControllers(this.tickPosition);
            ++i;
        }
    }

    private void flushNoteOnCache() {
        int i = 0;
        while (i < this.song.getNumberOfTracks()) {
            this.song.getTrack(i);
            ++i;
        }
    }

    void sendMidiPanic(boolean doControllers) {
        try {
            int i = 0;
            while (i < this.song.getNumberOfTracks()) {
                this.song.getTrack(i).sendMidiPanic(doControllers);
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        while (this.running) {
            try {
                Thread.sleep(1L);
                this.timerEvent();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.finished = true;
    }

    public long getRealTimeTickPosition() {
        long currentTick = this.startTickPosition + (long)((float)(System.currentTimeMillis() - startTimeMillis) * ((float)this.song.resolution * (this.getTempoInBPM() / 60000.0f)));
        if (this.getLoopCount() == -1) {
            currentTick = (currentTick - this.getLoopStartPoint()) % (this.getLoopEndPoint() - this.getLoopStartPoint()) + this.getLoopStartPoint();
        }
        return currentTick;
    }
}

