/*
 * Decompiled with CFR 0.152.
 */
package promidi;

import java.util.Vector;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;

class NoteOnCache {
    private Vector pendingNoteOffs = new Vector();

    NoteOnCache() {
        this.pendingNoteOffs.ensureCapacity(256);
    }

    void interceptMessage(MidiMessage msg) {
        try {
            ShortMessage shm = (ShortMessage)msg;
            if (shm.getCommand() == 144) {
                if (shm.getData2() == 0) {
                    this.pendingNoteOffs.remove(new Integer(shm.getChannel() << 8 | shm.getData1()));
                } else {
                    this.pendingNoteOffs.add(new Integer(shm.getChannel() << 8 | shm.getData1()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    Vector getPendingNoteOffs() {
        return this.pendingNoteOffs;
    }

    void releasePendingNoteOffs() {
        this.pendingNoteOffs.clear();
    }
}

