/*
 * Decompiled with CFR 0.152.
 */
package promidi;

import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import promidi.Track;

public class Song {
    private Vector songTracks = new Vector();
    private SortedMap ticks = new TreeMap();
    private String name = "";
    private float tempo = 120.0f;
    protected int resolution;

    public Song(int resolution) {
        this.resolution = resolution;
    }

    public Song(String name, float tempo) {
        this(128);
        this.name = name;
        this.tempo = tempo;
    }

    public void addTrack(Track i_track) {
        if (!this.songTracks.contains(i_track)) {
            this.songTracks.addElement(i_track);
            i_track.setSong(this);
        }
    }

    public void removeTrack(Track track) {
        this.songTracks.removeElement(track);
    }

    void addTick(long tick) {
        Long objectTick = new Long(tick);
        if (!this.ticks.containsKey(objectTick)) {
            this.ticks.put(objectTick, new Integer(0));
        }
    }

    public int getNumberOfTracks() {
        return this.songTracks.size();
    }

    public Track getTrack(int i) {
        return (Track)this.songTracks.get(i);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public float getTempo() {
        return this.tempo;
    }

    public void setTempo(float tempo) {
        this.tempo = tempo;
    }
}

