/*
 * Decompiled with CFR 0.152.
 */
import javax.media.opengl.GL;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.opengl.PGraphicsOpenGL;
import processing.video.MovieMaker;
import promidi.MidiIO;
import promidi.Note;
import promidi.ProgramChange;

public class musicvis
extends PApplet {
    int WIDTH = 1280;
    int HEIGHT = 720;
    float wCenter;
    float hCenter;
    int selection = 0;
    PFont font;
    int FRAME = 0;
    int MIDI_DEVICE = 0;
    int MIDI_CHANNEL = 0;
    boolean RUNNING = false;
    boolean START_RUNNING = false;
    boolean DEBUG = false;
    boolean RECORD = false;
    MovieMaker mm;
    MidiIO midiIO;
    Pulser pulser;
    boolean outline = false;

    public void setup() {
        if (this.WIDTH > this.screen.width) {
            this.WIDTH = this.screen.width;
        }
        if (this.HEIGHT > this.screen.height) {
            this.HEIGHT = this.screen.height;
        }
        this.size(this.WIDTH, this.HEIGHT, "processing.opengl.PGraphicsOpenGL");
        this.hint(2);
        this.frameRate(30.0f);
        this.background(0);
        this.imageMode(3);
        this.wCenter = this.width / 2;
        this.hCenter = this.height / 2;
        this.midiIO = MidiIO.getInstance((PApplet)this);
        this.font = this.loadFont("Gentium-48.vlw");
        this.textFont(this.font);
        this.noStroke();
    }

    public void postSetup() {
        if (this.RUNNING) {
            return;
        }
        if (!this.RECORD) {
            musicvis.println((String)"Creating new pulse sequence.");
            this.pulser = new Pulser();
            if (this.isValidMidiInputDeviceId(this.MIDI_DEVICE)) {
                this.midiIO.openInput(this.MIDI_DEVICE, this.MIDI_CHANNEL);
            }
        } else {
            String string = this.selectInput("Select a MusicVis session to load");
            musicvis.println((String)("Loading session \"" + string + "\"."));
            int[] nArray = this.stringArrayToIntArray(this.loadStrings(string));
            musicvis.println((String)"Creating Pulser");
            this.pulser = new Pulser(nArray);
            musicvis.println((String)"Creating MovieMaker object");
            String string2 = this.selectOutput("Save the Video");
            this.mm = new MovieMaker((PApplet)this, this.width, this.height, String.valueOf(string2) + ".avi", 30, 1835692129, 1023);
        }
        musicvis.println((String)"Done postSetup()");
        this.RUNNING = true;
    }

    public void keyPressed() {
        block16: {
            block15: {
                if (!this.RUNNING) break block15;
                switch (this.key) {
                    case 'd': {
                        this.DEBUG = !this.DEBUG;
                        break;
                    }
                    case ' ': {
                        if (this.RECORD) break block16;
                        this.pulser.pulse(127);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block16;
            }
            int n = 0;
            switch (this.keyCode) {
                case 40: {
                    if (this.selection < 3) {
                        ++this.selection;
                        break;
                    }
                    this.selection = 0;
                    break;
                }
                case 38: {
                    if (this.selection > 0) {
                        --this.selection;
                        break;
                    }
                    this.selection = 3;
                    break;
                }
                case 37: {
                    n |= 0xFFFFFFFF;
                }
                case 39: {
                    n |= 1;
                }
                case 10: 
                case 13: 
                case 32: {
                    this.actOn(this.selection, n);
                }
            }
        }
    }

    public void actOn(int n, int n2) {
        if (this.RUNNING) {
            return;
        }
        switch (n) {
            case 0: {
                this.RECORD = !this.RECORD;
                break;
            }
            case 1: {
                if (this.MIDI_DEVICE + n2 < 0 || this.MIDI_DEVICE + n2 >= this.midiIO.numberOfInputDevices()) break;
                this.MIDI_DEVICE += n2;
                break;
            }
            case 2: {
                if (this.MIDI_CHANNEL + n2 < 0) break;
                this.MIDI_CHANNEL += n2;
                break;
            }
            case 3: {
                this.START_RUNNING = true;
            }
        }
    }

    public void draw() {
        this.background(0);
        if (this.START_RUNNING) {
            this.postSetup();
        }
        if (this.RUNNING) {
            this.translate(this.wCenter, this.hCenter);
            this.setup_gl();
            this.pulser.run();
            if (this.RECORD) {
                this.mm.addFrame();
            }
            ++this.FRAME;
            this.translate(-this.wCenter, -this.hCenter);
            if (this.DEBUG) {
                this.text("Frame " + musicvis.str((int)this.FRAME) + " - " + musicvis.str((int)musicvis.round((float)this.frameRate)) + " FPS", 20.0f, 50.0f);
            }
        } else {
            String[] stringArray = new String[]{this.RECORD ? "Create Video from Session" : "Record Session", this.safeGetInputDeviceName(this.MIDI_DEVICE), "Midi Channel " + musicvis.str((int)this.MIDI_CHANNEL), "Begin"};
            int n = 60;
            int n2 = (stringArray.length + 1) * n / 2;
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (n3 == this.selection) {
                    this.fill(255);
                } else {
                    this.fill(120);
                }
                this.text(stringArray[n3], 50.0f, (float)((n3 + 1) * n) + (this.hCenter - (float)n2));
                ++n3;
            }
        }
    }

    public void setup_gl() {
        PGraphicsOpenGL pGraphicsOpenGL = (PGraphicsOpenGL)this.g;
        GL gL = pGraphicsOpenGL.beginGL();
        gL.glDepthMask(false);
        gL.glDisable(2929);
        gL.glClear(256);
        gL.glEnable(3042);
        gL.glBlendFunc(770, 1);
        pGraphicsOpenGL.endGL();
    }

    public void stop() {
        if (this.RUNNING) {
            if (this.RECORD) {
                this.mm.finish();
            } else {
                String[] stringArray = this.intArrayToStringArray(this.pulser.pulseHistory);
                String string = this.selectOutput("Save your MusicVis session");
                if (string != null) {
                    this.saveStrings(string, stringArray);
                }
            }
        }
        super.stop();
    }

    public void noteOn(Note note, int n, int n2) {
        if (note.getCommand() != 144) {
            return;
        }
        note.getVelocity();
        note.getPitch();
        this.pulser.pulse(note.getVelocity());
    }

    public void noteOff(Note note, int n, int n2) {
        if (note.getCommand() != 128) {
            return;
        }
        note.getPitch();
    }

    public void programChange(ProgramChange programChange, int n, int n2) {
        programChange.getNumber();
        musicvis.println((Object)programChange);
    }

    public String[] intArrayToStringArray(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        int n = nArray.length - 1;
        while (n >= 0) {
            stringArray[n] = musicvis.str((int)nArray[n]);
            --n;
        }
        return stringArray;
    }

    public int[] stringArrayToIntArray(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        int n = stringArray.length - 1;
        while (n >= 0) {
            nArray[n] = PApplet.parseInt((String)stringArray[n]);
            --n;
        }
        return nArray;
    }

    public boolean isValidMidiInputDeviceId(int n) {
        return n >= 0 && n < this.midiIO.numberOfInputDevices();
    }

    public String safeGetInputDeviceName(int n) {
        if (this.isValidMidiInputDeviceId(n)) {
            return this.midiIO.getInputDeviceName(n);
        }
        return "(No Midi devices found!)";
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#ffffff", "musicvis"});
    }

    final class Pulse
    extends Pulseable {
        public float size;
        public int age;
        private int[] colors;
        private int imageId;
        private int peak;
        private float zoomIncrement;

        public Pulse(Pulser pulser, int n) {
            super(pulser, n);
            this.age = 0;
            this.colors = new int[3];
            this.peak = 8;
            this.zoomIncrement = 1.0f;
        }

        public void reset() {
            super.reset();
            this.size = musicvis.this.random(120.0f, 190.0f);
            this.imageId = musicvis.this.random(8.0f) < 1.0f ? 0 : 1;
        }

        public void draw() {
            if (this.alive) {
                int n = musicvis.round((float)(musicvis.sin((float)((float)musicvis.this.millis() / 1500.0f)) * 3.0f)) - 32;
                musicvis.this.tint(this.colors[0], this.colors[1] + n, this.colors[2] + n);
                this.age();
                this.zoom();
                musicvis.this.image(this.pulser.images[this.imageId], this.x, this.y, this.size, this.size);
            }
        }

        private void age() {
            if (this.age++ < this.peak) {
                this.fadeIn();
            } else {
                this.fadeOut();
            }
        }

        private void zoom() {
            float f = musicvis.sqrt((float)(musicvis.sq((float)this.x) + musicvis.sq((float)this.y)));
            float f2 = musicvis.this.wCenter + this.zoomIncrement;
            float f3 = musicvis.this.hCenter + this.zoomIncrement;
            this.x = musicvis.map((float)this.x, (float)(-musicvis.this.wCenter), (float)musicvis.this.wCenter, (float)(-f2), (float)f2);
            this.y = musicvis.map((float)this.y, (float)(-musicvis.this.hCenter), (float)musicvis.this.hCenter, (float)(-f3), (float)f3);
            float f4 = musicvis.sqrt((float)(musicvis.sq((float)this.x) + musicvis.sq((float)this.y)));
            this.size *= (f4 - f) / 200.0f + 1.0f;
        }

        private void fadeOut() {
            boolean bl = false;
            int n = 0;
            while (n < this.colors.length) {
                if (this.colors[n] > 0) {
                    int n2 = n;
                    this.colors[n2] = this.colors[n2] - 1;
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                this.die();
            }
        }

        private void fadeIn() {
            int n = 0;
            while (n < this.colors.length) {
                int n2 = 6;
                int n3 = n++;
                this.colors[n3] = this.colors[n3] + (int)musicvis.this.random(n2, 34.0f);
            }
        }
    }

    abstract class Pulseable {
        public int id;
        public float x;
        public float y;
        public boolean alive = true;
        public int age = 0;
        protected int velocity;
        protected Pulser pulser;

        public Pulseable(Pulser pulser, int n) {
            this.pulser = pulser;
            this.velocity = n;
            this.reset();
        }

        public void reset() {
            int n = 100;
            this.x = musicvis.this.random(-musicvis.this.wCenter + (float)n, musicvis.this.wCenter - (float)n);
            this.y = musicvis.this.random(-musicvis.this.hCenter + (float)n, musicvis.this.hCenter - (float)n);
        }

        public void draw() {
        }

        protected void die() {
            this.alive = false;
            this.pulser.slots = musicvis.append((int[])this.pulser.slots, (int)this.id);
        }
    }

    final class Pulser {
        public PImage[] images = new PImage[2];
        private int[] timeline = new int[0];
        public int timelinePos = 0;
        public int lastBeat;
        public int[] pulseHistory = new int[0];
        private int lastPulseTime;
        private Pulseable[] pulses;
        private int[] slots;

        public Pulser(int[] nArray) {
            this.lastPulseTime = musicvis.this.millis();
            this.pulses = new Pulseable[2000];
            this.slots = new int[0];
            this.timeline = nArray;
            this.setup();
        }

        public Pulser() {
            this.lastPulseTime = musicvis.this.millis();
            this.pulses = new Pulseable[2000];
            this.slots = new int[0];
            this.setup();
        }

        public void setup() {
            this.images[0] = musicvis.this.loadImage("star.png");
            this.images[1] = musicvis.this.loadImage("flare.png");
            int n = this.pulses.length - 1;
            while (n >= 0) {
                this.slots = musicvis.append((int[])this.slots, (int)n);
                --n;
            }
        }

        public void run() {
            if (this.timeline.length != 0) {
                if (this.timelinePos == this.timeline.length && this.allDead()) {
                    musicvis.this.exit();
                }
                while (this.timelinePos < this.timeline.length && musicvis.this.FRAME >= this.timeline[this.timelinePos]) {
                    this.pulse(0);
                    this.lastPulseTime = musicvis.this.FRAME;
                    ++this.timelinePos;
                }
            }
            int n = 0;
            while (n < this.pulses.length) {
                if (this.pulses[n] != null) {
                    this.pulses[n].draw();
                }
                ++n;
            }
        }

        public void add(Pulseable pulseable) {
            if (this.slots.length > 0) {
                pulseable.id = this.slots[this.slots.length - 1];
                this.pulses[pulseable.id] = pulseable;
                this.pulseHistory = musicvis.append((int[])this.pulseHistory, (int)musicvis.this.FRAME);
                this.slots = musicvis.shorten((int[])this.slots);
            }
        }

        public void pulse(int n) {
            this.add(new Pulse(this, n));
        }

        private boolean allDead() {
            int n = 0;
            while (n < this.pulses.length) {
                if (this.pulses[n] != null && this.pulses[n].alive) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }

    final class Trazo
    extends Pulseable {
        int length;
        int step;
        int start;
        float[][] pos;
        float[] r;
        float[] ang;
        int seed;
        boolean drawing;
        boolean alive;
        float grosor;

        Trazo(Pulser pulser, int n) {
            super(pulser, n);
            this.start = 1;
            this.alive = true;
            this.grosor = 1.0f;
        }

        public void reset() {
            super.reset();
            this.length = musicvis.round((float)musicvis.this.random(100.0f, 200.0f));
            this.pos = new float[this.length][2];
            this.r = new float[this.length];
            this.ang = new float[this.length];
            this.pos[0][0] = this.x;
            this.pos[0][1] = this.y;
            this.ang[0] = musicvis.this.random((float)Math.PI * 2);
            this.r[0] = 0.1f;
            this.drawing = true;
            this.seed = musicvis.round((float)musicvis.this.random(3000.0f));
            this.step = 1;
            int n = 1;
            while (n < this.length) {
                musicvis.this.noiseSeed(this.seed);
                float f = musicvis.map((float)n, (float)1.0f, (float)this.length, (float)0.3f, (float)2.8415928f);
                this.ang[n] = this.ang[n - 1] + (musicvis.this.noise((float)n / 50.0f) - 0.5f) * 0.5f;
                this.r[n] = (this.r[n - 1] + (musicvis.this.noise((float)n / 80.0f) - 0.5f) * this.grosor) * musicvis.sin((float)f) + 0.2f;
                this.pos[n][0] = this.pos[n - 1][0] + musicvis.cos((float)this.ang[n]) * 6.0f;
                this.pos[n][1] = this.pos[n - 1][1] + musicvis.sin((float)this.ang[n]) * 6.0f;
                ++n;
            }
        }

        public void draw() {
            float f;
            float f2;
            if (!this.alive) {
                return;
            }
            if (musicvis.this.outline) {
                musicvis.this.stroke(255, 190.0f);
                musicvis.this.noFill();
            } else {
                musicvis.this.fill(255, 190.0f);
                musicvis.this.noStroke();
            }
            int n = this.drawing ? this.step : this.length;
            musicvis.this.beginShape();
            int n2 = this.start;
            while (n2 < n) {
                f2 = this.pos[n2][0] + musicvis.cos((float)(this.ang[n2] - 1.5707964f)) * this.r[n2];
                f = this.pos[n2][1] + musicvis.sin((float)(this.ang[n2] - 1.5707964f)) * this.r[n2];
                musicvis.this.curveVertex(f2, f);
                ++n2;
            }
            musicvis.this.curveVertex(this.pos[n - 1][0], this.pos[n - 1][1]);
            n2 = n - 2;
            while (n2 > this.start) {
                f2 = this.pos[n2][0] + musicvis.cos((float)(this.ang[n2] + 1.5707964f)) * this.r[n2];
                f = this.pos[n2][1] + musicvis.sin((float)(this.ang[n2] + 1.5707964f)) * this.r[n2];
                musicvis.this.curveVertex(f2, f);
                --n2;
            }
            musicvis.this.endShape();
            if (this.drawing) {
                ++this.step;
                if (this.step == this.length) {
                    this.drawing = false;
                }
            }
            if (this.length - this.step < 70) {
                ++this.start;
            }
            if (this.start >= this.length) {
                this.alive = false;
            }
        }
    }
}

