import processing.core.*; 
import processing.xml.*; 

import javax.media.opengl.*; 
import processing.opengl.*; 
import processing.video.*; 
import promidi.*; 

import java.applet.*; 
import java.awt.*; 
import java.awt.image.*; 
import java.awt.event.*; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class musicvis extends PApplet {






// Screen size
int WIDTH  = 1280;
int HEIGHT = 720;

// Shortcuts
float wCenter;
float hCenter;

// Menu
int selection = 0;
PFont font;

// Enviornment settings
int FRAME = 0;
int MIDI_DEVICE = 0;
int MIDI_CHANNEL = 0;
boolean RUNNING = false;
boolean START_RUNNING = false;
boolean DEBUG = false;
boolean RECORD = false;

// Object declarations
MovieMaker mm;
MidiIO midiIO;
Pulser pulser;

public void setup() {
  // Don't allow window sizes bigger than the screen.
  if (WIDTH > screen.width) WIDTH = screen.width;
  if (HEIGHT > screen.height) HEIGHT = screen.height;

  size(WIDTH, HEIGHT, OPENGL);
  hint(ENABLE_OPENGL_4X_SMOOTH);
  frameRate(30);
  background(0); // black
  imageMode(CENTER); // image origin is it's center

  wCenter = (width/2);
  hCenter = (height/2);

  midiIO = MidiIO.getInstance(this);

  font = loadFont("Gentium-48.vlw");
  textFont(font);
  noStroke();
}

public void postSetup() {
  if (RUNNING) return;
  if (!RECORD) {
    println("Creating new pulse sequence.");
    pulser = new Pulser();

    if (isValidMidiInputDeviceId(MIDI_DEVICE)) {
      midiIO.openInput(MIDI_DEVICE, MIDI_CHANNEL);
    }
  }
  else {
    String pulseFile = selectInput("Select a MusicVis session to load");
    println("Loading session \""+pulseFile+"\".");
    int[] timeline = stringArrayToIntArray(loadStrings(pulseFile));

    println("Creating Pulser");
    pulser = new Pulser(timeline);

    println("Creating MovieMaker object");
    String videoFile = selectOutput("Save the Video");
    mm = new MovieMaker(this, width, height, videoFile + ".avi",
        30, MovieMaker.MOTION_JPEG_A, MovieMaker.BEST);
  }

  println("Done postSetup()");
  RUNNING = true;
}

public void keyPressed() {
  if (RUNNING) {
    switch(key) {
      case 'd':
        DEBUG = !DEBUG;
        break;
      case ' ':
        if (!RECORD) pulser.pulse(127);
        break;
    }
  }
  else { // menu
    int value = 0;

    switch(keyCode) {
      case DOWN:
        if (selection < 3) selection++; else selection = 0;
        break;
      case UP:
        if (selection > 0) selection--; else selection = 3;
        break;
      case LEFT:
        value |= -1;
      case RIGHT:
        value |= 1;
      case RETURN:
      case ENTER:
      case ' ':
        actOn(selection, value);
        break;
    }
  }
}

public void actOn(int id, int value) {
  if (RUNNING) return;
  switch(id) {
    case 0: RECORD = !RECORD; break;
    case 1:
      if (MIDI_DEVICE + value >= 0 &&
          MIDI_DEVICE + value < midiIO.numberOfInputDevices())
        MIDI_DEVICE += value;
      break;
    case 2: if (MIDI_CHANNEL + value >= 0) MIDI_CHANNEL += value; break;
    case 3: START_RUNNING = true; break;
  }
}

public void draw() {
  background(0);

  if (START_RUNNING) {
    postSetup();
  }

  if (RUNNING) {
    translate(wCenter, hCenter);
    setup_gl();
    pulser.run();
    if (RECORD) mm.addFrame(); // Add window's pixels to movie
    FRAME++;
    translate(-wCenter, -hCenter);

    if (DEBUG) {
      text("Frame " + str(FRAME) + " - " + str(round(frameRate)) + " FPS", 20, 50);
    }
  }
  else { // menu
    String[] message = {
      (RECORD) ? "Create Video from Session" : "Record Session",
      safeGetInputDeviceName(MIDI_DEVICE),
      "Midi Channel " + str(MIDI_CHANNEL),
      "Begin",
    };

    int lineHeight = 60;
    int messageHeight = ((message.length+1)*lineHeight)/2;

    for (int i=0;i<message.length;i++) {
      if (i == selection) fill(255); else fill(120);
      text(message[i], 50, ((i+1)*lineHeight) + (hCenter - messageHeight));
    }
  }
}

// Fancy OpenGL effects.
public void setup_gl() {
  PGraphicsOpenGL pgl = (PGraphicsOpenGL) g;  // g may change
  GL gl = pgl.beginGL();  // always use the GL object returned by beginGL

  gl.glDepthMask(false);
  gl.glDisable(GL.GL_DEPTH_TEST);
  gl.glClear(GL.GL_DEPTH_BUFFER_BIT);
  gl.glEnable(GL.GL_BLEND);

  // Fade out old shapes with normal transparency
  /*
  gl.glBlendFunc(GL.GL_SRC_ALPHA, GL.GL_ONE_MINUS_SRC_ALPHA);
  fill(0, 0, 0, 70);
  rect(0, 0, width*2, height*2);
  */

  // Add new shapes with addition transparency
  gl.glBlendFunc(GL.GL_SRC_ALPHA, GL.GL_ONE);

  pgl.endGL();
}

// Clean up.
public void stop() {
  if (RUNNING) {
    if (RECORD) {
      mm.finish();
    }
    else {
      // Convert pulse history to String[] from int[]
      String[] historyStrings = intArrayToStringArray(pulser.pulseHistory);

      String pulseFile = selectOutput("Save your MusicVis session");

      if (pulseFile != null) {
        saveStrings(pulseFile, historyStrings);
      }
    }
  }

  super.stop();
}

public void noteOn(
  Note note,
  int deviceNumber,
  int midiChannel
){
  if (note.getCommand() != 144) return;
  int vel = note.getVelocity();
  int pit = note.getPitch();

  pulser.pulse(note.getVelocity());
}

public void noteOff( // not implemented
  Note note,
  int deviceNumber,
  int midiChannel
){
  if (note.getCommand() != 128) return;
  int pit = note.getPitch();
}

public void programChange( // not implemented
  ProgramChange programChange,
  int deviceNumber,
  int midiChannel
){
  int num = programChange.getNumber();
  println(programChange);
}

//
// Helpers
//

public String[] intArrayToStringArray(int[] ints) {
  String[] strings = new String[ints.length];

  for (int i=ints.length-1;i>=0;i--) {
    strings[i] = str(ints[i]);
  }

  return strings;
}

public int[] stringArrayToIntArray(String[] strings) {
  int[] ints = new int[strings.length];

  for (int i=strings.length-1;i>=0;i--) {
    ints[i] = PApplet.parseInt(strings[i]);
  }

  return ints;
}

public boolean isValidMidiInputDeviceId(int id) {
  return id >= 0 && id < midiIO.numberOfInputDevices();
}

public String safeGetInputDeviceName(int id) {
  if (isValidMidiInputDeviceId(id))
    return midiIO.getInputDeviceName(id);
  else
    return "(No Midi devices found!)";
}
final class Pulse extends Pulseable {

  public float size;
  public int age = 0;

  private int[] colors = new int[3];
  private int imageId;
  private int peak = 8; // in frames
  private float zoomIncrement = 1.0f; // how much to zoom per frame, in pixels

  public Pulse(Pulser pulser, int velocity) {
    super(pulser, velocity);
  }

  public void reset() {
    super.reset();
    size = random(120,190);
    imageId = random(8) < 1 ? 0 : 1;
  }

  public void draw() {
    if (alive == true) {
      int timeTint = round(sin((float) millis() / 1500) * 3) - 32;
      tint(colors[0], colors[1] + timeTint, colors[2] + timeTint);
      age();
      zoom();
      image(pulser.images[imageId], x, y, size, size);
    }
  }

  private void age() {
    if (age++ < peak) {
      fadeIn();
    } else {
      fadeOut();
    }
  }

  private void zoom() {
    float oldDistance = sqrt(sq(x) + sq(y));

    // Zoomed Width/Height Center
    float zwc = wCenter + zoomIncrement;
    float zhc = hCenter + zoomIncrement;

    // Apply movement zoom.
    x = map(x, -wCenter, wCenter, -zwc, zwc);
    y = map(y, -hCenter, hCenter, -zhc, zhc);

    float newDistance = sqrt(sq(x) + sq(y));

    // Apply size zoom.
    size *= (newDistance-oldDistance)/200 + 1;
  }

  private void fadeOut() {
    boolean colored = false;

    for (int i=0;i<colors.length;i++) {
      if (colors[i] > 0) {
        colors[i] -= 1;
        colored = true;
      }
    }

    if (!colored) die();
  }

  private void fadeIn() {
    for (int i=0;i<colors.length;i++) {
      //int m = (i == favorHue) ? 5 : 0;
      int m = 6;
      colors[i] += (int) random(m, 34);
    }
  }

}
abstract class Pulseable {

  public int id;
  public float x;
  public float y;
  public boolean alive = true;
  public int age = 0;

  protected int velocity;
  protected Pulser pulser;

  public Pulseable(Pulser _pulser, int _velocity) {
    pulser = _pulser;
    velocity = _velocity;
    reset();
  }

  public void reset() {
    int padding = 100;
    x = random(-wCenter+padding, wCenter-padding);
    y = random(-hCenter+padding, hCenter-padding);
  }

  public void draw() {}

  protected void die() {
    alive = false;
    pulser.slots = append(pulser.slots, id);
  }

}
final class Pulser {

  public PImage[] images = new PImage[2];
  private int[] timeline = new int[0];
  public int timelinePos = 0;
  //public int beat = 60000 / bpm;
  public int lastBeat;
  public int[] pulseHistory = new int[0];

  private int lastPulseTime = millis();
  private Pulseable[] pulses = new Pulseable[2000];
  private int[] slots = new int[0];

  public Pulser(int[] _timeline) {
    timeline = _timeline;
    setup();
  }
  public Pulser() {
    setup();
  }

  public void setup() {
    images[0] = loadImage("star.png");
    images[1] = loadImage("flare.png");

    for (int i=pulses.length-1;i>=0;i--) {
      slots = append(slots, i);
    }
  }

  public void run() {
    // Check for the end.

    /*
    if (FRAME - lastBeat >= beat) {
      lastBeat += beat;
    }
    */

    if (timeline.length != 0) {
      if (timelinePos == timeline.length && allDead() == true) exit();

      // Add pulses
      while (timelinePos < timeline.length && FRAME >= timeline[timelinePos]) {
        pulse(0);
        lastPulseTime = FRAME;
        timelinePos++;
      }
    }

    // Draw pulses
    for (int i=0;i<pulses.length;i++) {
      if (pulses[i] != null) {
        pulses[i].draw();
      }
    }

    /*
    PGraphicsOpenGL pgl = (PGraphicsOpenGL) g;  // g may change
    GL gl = pgl.beginGL();  // always use the GL object returned by beginGL
    gl.glBlendFunc(GL.GL_SRC_ALPHA, GL.GL_ONE_MINUS_SRC_ALPHA);

    fill(0, map(FRAME-lastBeat, 0, beat, 0, 60));
    rect(-wCenter*2, -hCenter*2, wCenter*4, hCenter*4);

    gl.glBlendFunc(GL.GL_SRC_ALPHA, GL.GL_ONE);
    pgl.endGL();
    */
  }

  public void add(Pulseable pulse) {
    if (slots.length > 0) {
      pulse.id = slots[slots.length-1];
      pulses[pulse.id] = pulse;
      pulseHistory = append(pulseHistory, FRAME);
      slots = shorten(slots);
    }
  }

  public void pulse(int x) {
    /*
    if (random(5) < 2)
      add(new Trazo(this, x));
    else*/
      add(new Pulse(this, x));
  }

  private boolean allDead() {
    for (int i=0;i<pulses.length;i++) {
      if (pulses[i] != null && pulses[i].alive == true) {
        return false;
      }
    }

    return true;
  }

}
// Originally created by Herbert Spencer.
// http://www.openprocessing.org/visuals/?visualID=1248

boolean outline = false;

final class Trazo extends Pulseable {
  int length, step;
  int start = 1;
  float[][] pos;
  float[] r;
  float[] ang;
  int seed;
  boolean drawing;
  boolean alive = true;
  float grosor = 1.0f;

  Trazo(Pulser pulser, int velocity){
    super(pulser, velocity);
  }

  public void reset() {
    super.reset();

    length = round(random(100, 200)); // length
    pos = new float[length][2];
    r = new float[length];
    ang = new float[length];
    pos[0][0] = x;
    pos[0][1] = y;
    ang[0] = random(TWO_PI);
    r[0] = 0.1f;
    //this.ang = ang;
    drawing = true;
    seed = round(random(3000));
    step = 1;

    for(int i = 1; i < length; i++){
      noiseSeed(seed);
      float fac = map(i, 1, length, 0.3f, PI-0.3f);
      ang[i] = ang[i-1] + ((noise((float)i/50.0f) - 0.5f) * 0.5f);  
      r[i]   = (r[i-1]   + (noise((float)i/80) - 0.5f) * grosor) * sin(fac) + 0.2f;
      pos[i][0] = pos[i-1][0] + (cos(ang[i]) * 6);
      pos[i][1] = pos[i-1][1] + (sin(ang[i]) * 6);
    }
  }

  public void draw(){
    if (!alive) return;

    if(outline){
      stroke(255, 190);
      noFill();
    }
    else{
      fill(255, 190);
      noStroke();
    }
    int count = (drawing) ? step : length;

    beginShape();

    for(int i = start; i < count; i++){
      float x = pos[i][0] + (cos(ang[i] - HALF_PI) * r[i]);
      float y = pos[i][1] + (sin(ang[i] - HALF_PI) * r[i]);
      curveVertex(x,y);
    }

    curveVertex(pos[count-1][0], pos[count-1][1]);

    for(int i = count-2; i > start; i--){
      float x = pos[i][0] + (cos(ang[i] + HALF_PI) * r[i]);
      float y = pos[i][1] + (sin(ang[i] + HALF_PI) * r[i]);
      curveVertex(x,y);
    }

    endShape();

    if (drawing) {
      step++;

      if(step == length){
        drawing = false;
      } 
    }

    if (length - step < 70) {
      start++;
    }

    if (start >= length) {
      alive = false;
    }
  }
}

/*
void wiggle(){
  for(int i = trazos.length-1; i >= 0; i--){
    Trazo t = trazos[i];
    noiseSeed(t.seed);
    for(int j = 0; j < t.length; j++){
      t.r[j] += (noise((float)millis()/10.0) - 0.5) * 0.5;
      t.pos[j][0] += noise((float)(millis()+t.seed)/50.0) - 0.5;
      t.pos[j][1] += noise((float)(millis()+t.seed*2)/100.0) - 0.5;
    }
  }
}

void wiggle2(){
  for(int i = trazos.length-1; i >= 0; i--){
    Trazo t = trazos[i];
    noiseSeed(t.seed);
    for(int j = 0; j < t.length; j++){
      //t.r[j] += noise((t.r[j]/10.0) - 0.5) * 0.5;
      t.pos[j][0] += noise((t.pos[j][0])/50.0) - 0.5;
      t.pos[j][1] += noise((t.pos[j][1])/50.0) - 0.5;
    }
  }
}

void keyPressed(){
  if(key == 'h'){
    outline = !outline;
  }
  if(key == 'c'){
    trazos = new Trazo[0];
  }
}
*/

/////////////////////////////////////////////

/*
Trazo[] trazos = new Trazo[0];

void setup(){
  size(800, 400);
  smooth();
}

void mouseDragged() {
  trazoate(mouseX, mouseY);
}

void mousePressed() {
  trazoate(mouseX, mouseY);
}

void trazoate(float x, float y) {
  trazos = (Trazo[]) append(trazos, new Trazo(x, y));
}

void draw(){
  background(0);
  for(int i = trazos.length-1; i >= 0; i--){
    trazos[i].trace();
  }

  //if (random(10) < 2) trazoate(random(width), random(height));
  
  if(key == ' ' && keyPressed){
    wiggle();
  }
  if(key == 'x' && keyPressed){
    wiggle2();
  }
}
*/

  static public void main(String args[]) {
    PApplet.main(new String[] { "--bgcolor=#ffffff", "musicvis" });
  }
}
