/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.clientinfo;

import com.nuomi.clientinfo.LoginInfo;
import com.nuomi.clientinfo.UserInfo;
import com.nuomi.connect.DataDownload;
import com.nuomi.connect.ImageCache;
import com.nuomi.data.AccountAll;
import com.nuomi.data.City;
import com.nuomi.data.Deal;
import com.nuomi.data.DealList;
import com.nuomi.data.FindCitys;
import com.nuomi.data.FindMyNuomiInfo;
import com.nuomi.data.FindVouchers;
import com.nuomi.data.GetAddresses;
import com.nuomi.data.GetVersion;
import com.nuomi.data.GiftCards;
import com.nuomi.data.Login;
import com.nuomi.data.LotteryDeal;
import com.nuomi.data.Voucher;
import com.nuomi.listener.CityChangedListener;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.listener.LogStatusListener;
import com.nuomi.listener.UserInfoChangedListener;
import com.nuomi.record.DealDetailRecord;
import com.nuomi.record.FindDealsRecord;
import com.nuomi.record.FindVouchersRecord;
import com.nuomi.record.NuomiRecord;
import com.nuomi.utils.Methods;
import com.nuomi.utils.PhoneFunction;
import java.util.Vector;

public class ClientInfo {
    public static long timeRelativeError = 0L;
    public static final String[] invoiceTypeStrings = new String[]{"\u4f1a\u52a1\u8d39", "\u4f1a\u8bae\u8d39", "\u65c5\u6e38\u8d39", "\u5dee\u65c5\u8d39", "\u670d\u52a1\u8d39", "\u673a\u7968\u6b3e", "\u4f4f\u5bbf\u8d39"};
    public static final String[] deliveryTypeStrings = new String[]{"\u53ea\u5de5\u4f5c\u65e5\u9001\u8d27(\u53cc\u4f11\u65e5\u3001\u5047\u65e5\u4e0d\u7528\u9001) (\u6ce8\uff1a\u5199\u5b57\u697c/\u5546\u7528\u5730\u5740\u5ba2\u6237\u8bf7\u9009\u62e9)", "\u53ea\u53cc\u4f11\u65e5\u3001\u5047\u65e5\u9001\u8d27(\u5de5\u4f5c\u65e5\u4e0d\u7528\u9001)", "\u5de5\u4f5c\u65e5\u3001\u53cc\u4f11\u65e5\u4e0e\u5047\u65e5\u5747\u53ef\u9001\u8d27"};
    public static final String[] TodayDeals_CatalogNames = new String[]{"\u5168\u90e8", "\u7f8e\u98df", "\u5a31\u4e50", "\u751f\u6d3b", "\u7f51\u8d2d", "\u65c5\u6e38", "\u5176\u4ed6"};
    public static final int TodayDeals_CatalogCount = TodayDeals_CatalogNames.length;
    public static final int TodayDeals_AllIndex = 0;
    public static final int TodayDeals_MeishiIndex = 1;
    public static final int TodayDeals_YuleIndex = 2;
    public static final int TodayDeals_ShenghuoIndex = 3;
    public static final int TodayDeals_GouwuIndex = 4;
    public static final int TodayDeals_LvyouIndex = 5;
    public static final int TodayDeals_QitaIndex = 6;
    public static final String[] Vouchers_CatalogNames = new String[]{"\u70ed\u95e8", "\u6700\u65b0"};
    public static final int Vouchers_CatalogCount = Vouchers_CatalogNames.length;
    public static final int Vouchers_HotIndex = 0;
    public static final int Vouchers_AllIndex = 1;
    public static final int Coupon_NewBuy_Index = 0;
    public static final int Coupon_NearlyExpired_Index = 1;
    public static final int Coupon_Expired_Index = 2;
    public static final int Coupon_Used_Index = 3;
    public static final int[] Coupon_All_Index;
    public static final String[] Coupon_AllCatalogNames;
    public static final int Lottery_Unend_Index = 0;
    public static final int Lottery_Ended_Index = 1;
    public static final int[] Lottery_All_Index;
    public static final String[] Lottery_AllCatalogNames;
    public static final int Delivery_Unpost_Index = 0;
    public static final int Delivery_Posted_Index = 1;
    public static final int[] Delivery_All_Index;
    public static final String[] Delivery_AllCatalogNames;
    public static final int Giftcard_Unused_Index = 0;
    public static final int Giftcard_Used_Index = 1;
    public static final int Giftcard_Expired_Index = 2;
    public static final int[] Giftcard_All_Index;
    public static final String[] Giftcard_AllCatalogNames;
    private Vector[] catalogOrders = null;
    private Vector[] catalogDeals = null;
    private boolean[] hadRefreshedTodayDeals = null;
    private final int Max_TodayDeals_Count;
    private FindVouchers[] vouchers = null;
    private FindVouchers[] tempVouchers = null;
    private final int Max_Voucher_Count;
    private DataDownload loginDataDownload = null;
    private UserInfo userInfo = null;
    private Vector logStatusListeners = null;
    private Vector cityChangedListeners = null;
    private Vector userInfoChangedListeners = null;
    private FindMyNuomiInfo[] couponInfos = null;
    private FindMyNuomiInfo[] postOrderInfos = null;
    private FindMyNuomiInfo[] lotteryInfos = null;
    private AccountAll accountAll = null;
    private GiftCards[] allGiftCards = null;
    private DataDownloadListener loginDownloadListener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            switch (result) {
                case 3: {
                    ClientInfo.this.sendLogCancelled();
                    break;
                }
                case 2: {
                    if (data == null || !(data instanceof Login) || type != 7) break;
                    Login login = (Login)data;
                    UserInfo newUserInfo = login.userInfo;
                    if (login.result.isSucceed() && newUserInfo != null) {
                        if (!(newUserInfo.actived != null && newUserInfo.actived.booleanValue() || PhoneFunction.isPhoneNumber(newUserInfo.userName))) {
                            ClientInfo.this.sendLogFailed("\u975e\u624b\u673a\u8d26\u53f7\u8bf7\u5230\u7f51\u7ad9\u6fc0\u6d3b", null);
                            break;
                        }
                        ClientInfo.this.setUserInfo(newUserInfo);
                        ClientInfo.this.sendLogSucceed(newUserInfo);
                        break;
                    }
                    ClientInfo.this.sendLogFailed(login.result.msg, login.codeData);
                    break;
                }
                default: {
                    ClientInfo.this.sendLogFailed(DataDownload.ResultStrings[result], null);
                }
            }
        }
    };
    private boolean hadSendOnStart = false;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        Coupon_All_Index = nArray;
        Coupon_AllCatalogNames = new String[]{"\u65b0\u8d2d\u4e70", "\u5feb\u5230\u671f", "\u5df2\u8fc7\u671f", "\u5df2\u4f7f\u7528"};
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        Lottery_All_Index = nArray2;
        Lottery_AllCatalogNames = new String[]{"\u672a\u7ed3\u675f", "\u5df2\u7ed3\u675f"};
        int[] nArray3 = new int[2];
        nArray3[1] = 1;
        Delivery_All_Index = nArray3;
        Delivery_AllCatalogNames = new String[]{"\u672a\u53d1\u8d27", "\u5df2\u53d1\u8d27"};
        int[] nArray4 = new int[3];
        nArray4[1] = 1;
        nArray4[2] = 2;
        Giftcard_All_Index = nArray4;
        Giftcard_AllCatalogNames = new String[]{"\u672a\u4f7f\u7528", "\u5df2\u4f7f\u7528", "\u5df2\u8fc7\u671f"};
    }

    public ClientInfo() {
        this.Max_TodayDeals_Count = 100;
        this.Max_Voucher_Count = 60;
        this.catalogOrders = new Vector[TodayDeals_CatalogCount];
        this.catalogDeals = new Vector[TodayDeals_CatalogCount];
        this.hadRefreshedTodayDeals = new boolean[TodayDeals_CatalogCount];
        this.vouchers = new FindVouchers[Vouchers_CatalogCount];
        this.tempVouchers = new FindVouchers[Vouchers_CatalogCount];
        this.couponInfos = new FindMyNuomiInfo[Coupon_All_Index.length];
        this.postOrderInfos = new FindMyNuomiInfo[Delivery_All_Index.length];
        this.lotteryInfos = new FindMyNuomiInfo[Lottery_All_Index.length];
        this.allGiftCards = new GiftCards[Giftcard_All_Index.length];
    }

    public void init() {
        NuomiRecord.init();
        FindDealsRecord.init();
        FindVouchersRecord.init();
        DealDetailRecord.init();
        int i = 0;
        while (i < TodayDeals_CatalogCount) {
            this.hadRefreshedTodayDeals[i] = false;
            DealList findDeals = FindDealsRecord.getFindDeals(i);
            this.setTodayDeals(i, findDeals, false);
            ++i;
        }
        i = 0;
        while (i < Vouchers_CatalogCount) {
            FindVouchers findVouchers = FindVouchersRecord.getFindVouchers(new Integer(i));
            this.setVouchers(i, findVouchers, false);
            ++i;
        }
        this.loginDataDownload = new DataDownload();
        this.loginDataDownload.addDownloadListener(this.loginDownloadListener);
        this.couponInfos[0] = NuomiRecord.getInfo(7);
        this.couponInfos[1] = NuomiRecord.getInfo(6);
        this.couponInfos[3] = NuomiRecord.getInfo(8);
        this.postOrderInfos[0] = NuomiRecord.getInfo(14);
        this.postOrderInfos[1] = NuomiRecord.getInfo(9);
        this.lotteryInfos[0] = NuomiRecord.getInfo(10);
        this.lotteryInfos[1] = NuomiRecord.getInfo(11);
        if (this.getLoginInfo() != null && this.getLoginInfo().autoLogin != null && this.getLoginInfo().autoLogin.booleanValue()) {
            this.userInfo = NuomiRecord.getUserInfo();
        }
        this.accountAll = NuomiRecord.getAccountAll();
        this.allGiftCards[0] = NuomiRecord.getGiftCards(16);
        this.allGiftCards[1] = NuomiRecord.getGiftCards(17);
        this.allGiftCards[2] = NuomiRecord.getGiftCards(18);
    }

    public void clear() {
        DealDetailRecord.clear();
        FindDealsRecord.clear();
        FindVouchersRecord.clear();
        NuomiRecord.clear();
        ImageCache.clear();
        this.sendCityChangedListener(this.getCity());
        this.sendUserInfoChangedListener(this.getUserInfo());
        System.gc();
    }

    public void close() {
    }

    private void resetTodayDeals(City city) {
        FindDealsRecord.clear();
        if (this.catalogDeals == null) {
            this.catalogDeals = new Vector[TodayDeals_CatalogCount];
        }
        if (this.catalogOrders == null) {
            this.catalogOrders = new Vector[TodayDeals_CatalogCount];
        }
        int i = 0;
        while (i < TodayDeals_CatalogCount) {
            this.catalogDeals[i] = null;
            this.catalogOrders[i] = null;
            this.hadRefreshedTodayDeals[i] = false;
            ++i;
        }
    }

    public void setTodayDeals(int catalogIndex, DealList findDeals) {
        this.setTodayDeals(catalogIndex, findDeals, true);
    }

    public void setTodayDeals(int catalogIndex, DealList findDeals, boolean needSave) {
        try {
            if (findDeals != null) {
                if (needSave && catalogIndex == 0 && findDeals.now != null && findDeals.now > 0L) {
                    long clientNow = System.currentTimeMillis();
                    timeRelativeError = findDeals.now - clientNow;
                }
                this.catalogOrders[catalogIndex] = findDeals.order;
                this.catalogDeals[catalogIndex] = findDeals.deals;
            } else {
                this.catalogOrders[catalogIndex] = null;
                this.catalogDeals[catalogIndex] = null;
            }
            if (needSave) {
                this.hadRefreshedTodayDeals[catalogIndex] = true;
                FindDealsRecord.addFindDeals(catalogIndex, findDeals);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addTodayDeals(int catalogIndex, DealList findDeals) {
        try {
            if (findDeals == null || findDeals.deals == null) {
                return;
            }
            if (this.catalogDeals[catalogIndex] == null) {
                this.catalogDeals[catalogIndex] = findDeals.deals;
            } else {
                int i = 0;
                while (i < findDeals.deals.size()) {
                    this.catalogDeals[catalogIndex].addElement(findDeals.deals.elementAt(i));
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Vector getTodayDeals(int catalogIndex) {
        try {
            return this.catalogDeals[catalogIndex];
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean hadRefreshedTodayDeals(int catalogIndex) {
        try {
            return this.hadRefreshedTodayDeals[catalogIndex];
        }
        catch (Exception e) {
            return true;
        }
    }

    public int getTodayDealsCount(int catalogIndex) {
        try {
            return Math.min(100, this.catalogOrders[catalogIndex].size());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getDealIds(int start, int offset, int catalogIndex) {
        try {
            String result = "[";
            Vector order = this.catalogOrders[catalogIndex];
            int i = start;
            while (i < Math.min(start + offset, this.getTodayDealsCount(catalogIndex))) {
                Long dealId = (Long)order.elementAt(i);
                result = String.valueOf(result) + "{\"dealid\":" + dealId + "},";
                ++i;
            }
            result = result.substring(0, result.length() - 1);
            return String.valueOf(result) + "]";
        }
        catch (Exception e) {
            return null;
        }
    }

    public String AddLookedDeal(Long dealId) {
        String str = NuomiRecord.getLookedDeals();
        if (this.hadLookedDeal(dealId)) {
            return str;
        }
        if (str == null || str.length() <= 0) {
            str = "|";
        }
        String dealIdString = String.valueOf(String.valueOf(dealId)) + "|";
        int maxLength = 1 + dealIdString.length() * 300;
        if (str.length() > maxLength && !(str = str.substring(0, maxLength)).endsWith("|")) {
            str = String.valueOf(str) + "|";
        }
        str = String.valueOf(str) + dealIdString;
        NuomiRecord.saveLookedDeals(str);
        return str;
    }

    public boolean hadLookedDeal(Long dealId) {
        String str = NuomiRecord.getLookedDeals();
        if (str == null || str.length() <= 0) {
            return false;
        }
        int index = str.indexOf("|" + String.valueOf(dealId) + "|");
        return index != -1;
    }

    private void resetVouchers(City city) {
        FindVouchersRecord.clear();
        if (this.vouchers == null) {
            this.vouchers = new FindVouchers[Vouchers_CatalogCount];
        }
        if (this.tempVouchers == null) {
            this.tempVouchers = new FindVouchers[Vouchers_CatalogCount];
        }
        int i = 0;
        while (i < Vouchers_CatalogCount) {
            this.setVouchers(i, null, false);
            this.vouchers[i] = null;
            ++i;
        }
    }

    public void setVouchers(int catalogIndex, FindVouchers findVouchers) {
        this.setVouchers(catalogIndex, findVouchers, true);
    }

    public void setVouchers(int catalogIndex, FindVouchers findVouchers, boolean needSave) {
        if (!needSave) {
            this.tempVouchers[catalogIndex] = findVouchers;
        }
        if (findVouchers == null || catalogIndex < 0 || catalogIndex >= Vouchers_CatalogCount) {
            return;
        }
        if (needSave) {
            this.vouchers[catalogIndex] = findVouchers;
            FindVouchersRecord.addFindVouchers(new Integer(catalogIndex), findVouchers);
        }
    }

    public void addVouchers(int catalogIndex, FindVouchers findVouchers) {
        if (findVouchers == null || catalogIndex < 0 || catalogIndex >= Vouchers_CatalogCount) {
            return;
        }
        if (this.vouchers[catalogIndex] == null) {
            this.vouchers[catalogIndex] = findVouchers;
        } else {
            this.vouchers[catalogIndex].count = findVouchers.count;
            int i = 0;
            while (i < findVouchers.vouchers.size()) {
                this.vouchers[catalogIndex].vouchers.addElement(findVouchers.vouchers.elementAt(i));
                ++i;
            }
        }
    }

    public Vector getVouchers(int catalogIndex) {
        try {
            if (this.vouchers[catalogIndex] != null) {
                return this.vouchers[catalogIndex].vouchers;
            }
            if (this.tempVouchers[catalogIndex] != null) {
                return this.tempVouchers[catalogIndex].vouchers;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getVouchersCount(int catalogIndex) {
        try {
            if (this.vouchers[catalogIndex] != null) {
                return Math.min(60, this.vouchers[catalogIndex].count);
            }
            if (this.tempVouchers[catalogIndex] != null) {
                return Math.min(60, this.tempVouchers[catalogIndex].count);
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean needRefreshVouchers(int catalogIndex) {
        try {
            return this.vouchers[catalogIndex] == null;
        }
        catch (Exception e) {
            return true;
        }
    }

    public LoginInfo getLoginInfo() {
        return NuomiRecord.getLoginInfo();
    }

    public void setLoginInfo(LoginInfo loginInfo) {
        if (!Methods.equals(loginInfo, this.getLoginInfo())) {
            this.setAddresses(null);
            this.resetUserInfomations();
        }
        NuomiRecord.saveLoginInfo(loginInfo);
    }

    public City getCity() {
        return NuomiRecord.getCity();
    }

    public void setCity(City city) {
        if (!Methods.equals(city, this.getCity())) {
            this.sendCityChangedListener(city);
            NuomiRecord.saveCity(city);
        }
    }

    public void addCityChangedListener(CityChangedListener listener) {
        if (this.cityChangedListeners == null) {
            this.cityChangedListeners = new Vector();
        }
        if (!this.cityChangedListeners.contains(listener)) {
            this.cityChangedListeners.addElement(listener);
        }
    }

    public void removeCityChangedListener(CityChangedListener listener) {
        if (this.cityChangedListeners != null && this.cityChangedListeners.contains(listener)) {
            this.cityChangedListeners.removeElement(listener);
        }
    }

    private void sendCityChangedListener(City newCity) {
        this.resetTodayDeals(newCity);
        this.resetVouchers(newCity);
        if (this.cityChangedListeners != null) {
            int i = 0;
            while (i < this.cityChangedListeners.size()) {
                Object listener = this.cityChangedListeners.elementAt(i);
                if (listener instanceof CityChangedListener) {
                    ((CityChangedListener)listener).onChanged(newCity);
                }
                ++i;
            }
        }
    }

    public void setFindCitys(FindCitys findCitys) {
        NuomiRecord.saveFindCitys(findCitys);
    }

    public Vector getCitys() {
        if (NuomiRecord.getFindCitys() != null) {
            return NuomiRecord.getFindCitys().citys;
        }
        return null;
    }

    public void setUserInfo(UserInfo userInfo) {
        NuomiRecord.saveUserInfo(userInfo);
        this.userInfo = userInfo;
        this.sendUserInfoChangedListener(userInfo);
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void addUserInfoChangedListener(UserInfoChangedListener listener) {
        if (this.userInfoChangedListeners == null) {
            this.userInfoChangedListeners = new Vector();
        }
        if (!this.userInfoChangedListeners.contains(listener)) {
            this.userInfoChangedListeners.addElement(listener);
        }
    }

    public void removeUserInfoChangedListener(UserInfoChangedListener listener) {
        if (this.userInfoChangedListeners != null && this.userInfoChangedListeners.contains(listener)) {
            this.userInfoChangedListeners.removeElement(listener);
        }
    }

    private void sendUserInfoChangedListener(UserInfo newUserInfo) {
        this.resetUserInfomations();
        if (this.userInfoChangedListeners != null) {
            int i = 0;
            while (i < this.userInfoChangedListeners.size()) {
                Object listener = this.userInfoChangedListeners.elementAt(i);
                if (listener instanceof UserInfoChangedListener) {
                    ((UserInfoChangedListener)listener).onChanged(newUserInfo);
                }
                ++i;
            }
        }
    }

    public boolean isLoging() {
        return this.loginDataDownload.isDownloading();
    }

    public void startLogin(String email, String password, String code) {
        this.loginDataDownload.login(email, password, code);
    }

    public void cancelLogin() {
        this.loginDataDownload.cancel();
    }

    public void addLogStatusListener(LogStatusListener l) {
        if (this.logStatusListeners == null) {
            this.logStatusListeners = new Vector();
        }
        this.logStatusListeners.addElement(l);
    }

    private void sendLogCancelled() {
        if (this.logStatusListeners != null) {
            int i = 0;
            while (i < this.logStatusListeners.size()) {
                Object o = this.logStatusListeners.elementAt(i);
                if (o != null && o instanceof LogStatusListener) {
                    ((LogStatusListener)o).onCancelled();
                }
                ++i;
            }
        }
    }

    private void sendLogSucceed(UserInfo userInfo) {
        if (this.logStatusListeners != null) {
            int i = 0;
            while (i < this.logStatusListeners.size()) {
                Object o = this.logStatusListeners.elementAt(i);
                if (o != null && o instanceof LogStatusListener) {
                    ((LogStatusListener)o).onSucceed(userInfo);
                }
                ++i;
            }
        }
    }

    private void sendLogFailed(String reason, String codeData) {
        if (this.logStatusListeners != null) {
            int i = 0;
            while (i < this.logStatusListeners.size()) {
                Object o = this.logStatusListeners.elementAt(i);
                if (o != null && o instanceof LogStatusListener) {
                    ((LogStatusListener)o).onFailed(reason, codeData);
                }
                ++i;
            }
        }
    }

    public boolean getAutoLoadImage() {
        return NuomiRecord.getAutoLoadImage();
    }

    public void setAutoLoadImage(boolean autoLoadImage) {
        NuomiRecord.saveAutoLoadImage(autoLoadImage);
    }

    private void resetUserInfomations() {
        int i = 0;
        while (i < this.couponInfos.length) {
            this.couponInfos[i] = null;
            ++i;
        }
        i = 0;
        while (i < this.postOrderInfos.length) {
            this.postOrderInfos[i] = null;
            ++i;
        }
        i = 0;
        while (i < this.lotteryInfos.length) {
            this.lotteryInfos[i] = null;
            ++i;
        }
        this.accountAll = null;
        i = 0;
        while (i < this.allGiftCards.length) {
            this.allGiftCards[i] = null;
            ++i;
        }
    }

    public GetAddresses getAddresses() {
        return NuomiRecord.getAddresses();
    }

    public void setAddresses(GetAddresses getAddresses) {
        NuomiRecord.saveAddresses(getAddresses);
    }

    public Deal getDealDetail(Long dealId) {
        return DealDetailRecord.getDealDetail(dealId);
    }

    public LotteryDeal getLotteryDealDetail(Long dealId) {
        return DealDetailRecord.getLotteryDealDetail(dealId);
    }

    public Voucher getVoucherDetail(Long voucherId) {
        return DealDetailRecord.getVoucherDetail(voucherId);
    }

    public void setDealDetail(Long id, Object dealDetail) {
        DealDetailRecord.addDealDetail(id, dealDetail);
    }

    public void setCouponInfo(FindMyNuomiInfo info, int index) {
        this.couponInfos[index] = info;
        switch (index) {
            case 1: {
                NuomiRecord.saveInfo(6, info);
                break;
            }
            case 0: {
                NuomiRecord.saveInfo(7, info);
                break;
            }
            case 3: {
                NuomiRecord.saveInfo(8, info);
                break;
            }
        }
    }

    public void addCouponInfo(FindMyNuomiInfo info, int index) {
        if (this.couponInfos[index] == null) {
            this.couponInfos[index] = new FindMyNuomiInfo();
        }
        this.couponInfos[index].count = info.count;
        if (info.informations != null) {
            int i = 0;
            while (i < info.informations.size()) {
                this.couponInfos[index].informations.addElement(info.informations.elementAt(i));
                ++i;
            }
        }
    }

    public Vector getCouponInfo(int index) {
        if (this.couponInfos == null || this.couponInfos[index] == null) {
            return null;
        }
        return this.couponInfos[index].informations;
    }

    public int getCouponCount(int index) {
        try {
            return this.couponInfos[index].count;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setPostOrderInfo(FindMyNuomiInfo info, int index) {
        this.postOrderInfos[index] = info;
        switch (index) {
            case 0: {
                NuomiRecord.saveInfo(14, info);
                break;
            }
            case 1: {
                NuomiRecord.saveInfo(9, info);
                break;
            }
        }
    }

    public void addPostOrderInfo(FindMyNuomiInfo info, int index) {
        if (this.postOrderInfos[index] == null) {
            this.postOrderInfos[index] = new FindMyNuomiInfo();
        }
        this.postOrderInfos[index].count = info.count;
        if (info.informations != null) {
            int i = 0;
            while (i < info.informations.size()) {
                this.postOrderInfos[index].informations.addElement(info.informations.elementAt(i));
                ++i;
            }
        }
    }

    public Vector getPostOrderInfo(int index) {
        if (this.postOrderInfos[index] == null) {
            return null;
        }
        return this.postOrderInfos[index].informations;
    }

    public int getPostOrderCount(int index) {
        try {
            return this.postOrderInfos[index].count;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setLotteryInfo(FindMyNuomiInfo info, int index) {
        this.lotteryInfos[index] = info;
        switch (index) {
            case 0: {
                NuomiRecord.saveInfo(10, info);
                break;
            }
            case 1: {
                NuomiRecord.saveInfo(11, info);
                break;
            }
        }
    }

    public void addLotteryInfo(FindMyNuomiInfo info, int index) {
        if (this.lotteryInfos[index] == null) {
            this.lotteryInfos[index] = new FindMyNuomiInfo();
        }
        this.lotteryInfos[index].count = info.count;
        if (info.informations != null) {
            int i = 0;
            while (i < info.informations.size()) {
                this.lotteryInfos[index].informations.addElement(info.informations.elementAt(i));
                ++i;
            }
        }
    }

    public Vector getLotteryInfo(int index) {
        if (this.lotteryInfos[index] == null) {
            return null;
        }
        return this.lotteryInfos[index].informations;
    }

    public int getLotteryCount(int index) {
        try {
            return this.lotteryInfos[index].count;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public Vector getAccounts() {
        if (this.accountAll == null) {
            return null;
        }
        return this.accountAll.accounts;
    }

    public int getAccountCount() {
        try {
            return this.accountAll.count;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setAccounts(AccountAll accountAll, boolean needSave) {
        this.accountAll = null;
        this.accountAll = accountAll;
        if (needSave) {
            NuomiRecord.saveAccountAll(accountAll);
        }
    }

    public void addAccounts(AccountAll accountAll) {
        if (this.accountAll == null) {
            this.accountAll = new AccountAll();
        }
        if (this.accountAll.accounts == null) {
            this.accountAll.accounts = new Vector();
        }
        this.accountAll.count = accountAll.count;
        int i = 0;
        while (i < accountAll.accounts.size()) {
            this.accountAll.accounts.addElement(accountAll.accounts.elementAt(i));
            ++i;
        }
    }

    public void setGiftcards(GiftCards giftCards, int index) {
        this.allGiftCards[index] = giftCards;
        switch (index) {
            case 0: {
                NuomiRecord.saveGiftcards(16, giftCards);
                break;
            }
            case 1: {
                NuomiRecord.saveGiftcards(17, giftCards);
                break;
            }
            case 2: {
                NuomiRecord.saveGiftcards(18, giftCards);
                break;
            }
        }
    }

    public void addGiftcards(GiftCards giftCards, int index) {
        if (this.allGiftCards[index] == null) {
            this.allGiftCards[index] = new GiftCards();
        }
        this.allGiftCards[index].count = giftCards.count;
        if (giftCards.giftcards != null) {
            int i = 0;
            while (i < giftCards.giftcards.size()) {
                this.allGiftCards[index].giftcards.addElement(giftCards.giftcards.elementAt(i));
                ++i;
            }
        }
    }

    public Vector getGiftcards(int index) {
        if (this.allGiftCards[index] == null) {
            return null;
        }
        return this.allGiftCards[index].giftcards;
    }

    public int getGiftcardsCount(int index) {
        try {
            return this.allGiftCards[index].count;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void onStart() {
        if (!this.hadSendOnStart) {
            this.hadSendOnStart = true;
            DataDownload dataDownload = new DataDownload();
            dataDownload.addDownloadListener(new DataDownloadListener(){

                public void onDownloadStart(Object tag) {
                }

                public void onDownloadCompleted(int result, Object data, int type, Object tag) {
                    if (result == 2 && data instanceof GetVersion) {
                        GetVersion getVersion = (GetVersion)data;
                        PhoneFunction.checkVersion(getVersion);
                    }
                }
            });
            dataDownload.onStart();
        }
    }
}

