/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.clientinfo;

import com.nuomi.utils.Methods;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class LoginInfo {
    public String userName = null;
    public String password = null;
    public Boolean autoLogin = null;

    public LoginInfo(String userName, String password, boolean autoLogin) {
        this.userName = userName;
        this.password = password;
        this.autoLogin = new Boolean(autoLogin);
    }

    public LoginInfo() {
    }

    public String toString() {
        return "{\"userName\":\"" + (this.userName == null ? "" : this.userName) + "\"," + "\"password\":\"" + (this.password == null ? "" : this.password) + "\"," + "\"autoLogin\":" + (this.autoLogin == null ? String.valueOf(false) : this.autoLogin.toString()) + "}";
    }

    public static LoginInfo create(String jsonString) {
        if (Methods.isNullOrEmpty(jsonString)) {
            return null;
        }
        try {
            LoginInfo loginInfo = new LoginInfo();
            JSONObject jsonObject = new JSONObject(jsonString);
            loginInfo.userName = Methods.getJOString(jsonObject, "userName");
            loginInfo.password = Methods.getJOString(jsonObject, "password");
            loginInfo.autoLogin = Methods.getJOBoolean(jsonObject, "autoLogin");
            return loginInfo;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof LoginInfo) {
            LoginInfo loginInfo = (LoginInfo)o;
            return this.userName == loginInfo.userName;
        }
        return false;
    }
}

