/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.connect;

import com.nuomi.clientinfo.OrderCheckInfo;
import com.nuomi.connect.HttpConnect;
import com.nuomi.connect.NetworkException;
import com.nuomi.connect.URLEncode;
import com.nuomi.data.AccountAll;
import com.nuomi.data.BuyDealResult;
import com.nuomi.data.Data;
import com.nuomi.data.Deal;
import com.nuomi.data.DealEndTime;
import com.nuomi.data.DealList;
import com.nuomi.data.FindCitys;
import com.nuomi.data.FindMyNuomiInfo;
import com.nuomi.data.FindVouchers;
import com.nuomi.data.GetAddresses;
import com.nuomi.data.GetVersion;
import com.nuomi.data.GiftCardCheck;
import com.nuomi.data.GiftCards;
import com.nuomi.data.JoinLotteryResult;
import com.nuomi.data.Login;
import com.nuomi.data.LotteryDeal;
import com.nuomi.data.OrderCheckResult;
import com.nuomi.data.PayByBlanceResult;
import com.nuomi.data.PayCheckResult;
import com.nuomi.data.PayStatusResult;
import com.nuomi.data.RechargeUrl;
import com.nuomi.data.ResultInfo;
import com.nuomi.data.Voucher;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.utils.Methods;
import com.nuomi.utils.PhoneFunction;
import com.nuomi.utils.Thread;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DataDownload {
    private DataDownload self = this;
    public static final int Result_None = 0;
    public static final int Result_NetworkError = 1;
    public static final int Result_Succeed = 2;
    public static final int Result_Cancelled = 3;
    public static final int Result_DataError = 4;
    public static final int Result_ServerBreak = 5;
    public static final String[] ResultStrings = new String[]{"\u672a\u77e5\u9519\u8bef", "\u7f51\u7edc\u8fde\u63a5\u5931\u8d25", "\u66f4\u65b0\u6210\u529f", "\u8fde\u63a5\u5df2\u53d6\u6d88", "\u5f97\u5230\u6570\u636e\u6709\u8bef", "\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25"};
    public static final int Type_DealListWithOrder = 0;
    public static final int Type_DealListByIds = 1;
    public static final int Type_CityAll = 4;
    public static final int Type_VoucherHot = 5;
    public static final int Type_VoucherAll = 6;
    public static final int Type_Login = 7;
    public static final int Type_GetAddresses = 8;
    public static final int Type_Feedback = 9;
    public static final int Type_DealDetail = 10;
    public static final int Type_LotteryDetail = 11;
    public static final int Type_VoucherDetail = 12;
    public static final int Type_VoucherSendSms = 13;
    public static final int Type_CouponAll = 14;
    public static final int Type_PostOrderAll = 15;
    public static final int Type_LotteryAll = 16;
    public static final int Type_CouponDetail = 17;
    public static final int Type_PostOrderDetail = 18;
    public static final int Type_Register = 19;
    public static final int Type_Active = 20;
    public static final int Type_ResendCode = 21;
    public static final int Type_BindPhoneCode = 22;
    public static final int Type_BindPhone = 23;
    public static final int Type_JoinLottery = 24;
    public static final int Type_Buy = 25;
    public static final int Type_OrderCheck = 26;
    public static final int Type_PayByBalance = 27;
    public static final int Type_PayStatus = 28;
    public static final int Type_PayRoot = 29;
    public static final int Type_NuomiData = 30;
    public static final int Type_OnStart = 31;
    public static final int Type_GetVersion = 32;
    public static final int Type_GiftcardAll = 33;
    public static final int Type_GiftcardCheck = 34;
    public static final int Type_AccountAll = 35;
    public static final int Type_RechargeUrl = 36;
    public static final int Type_DealEndTime = 37;
    public static final int Type_GetQRCode = 38;
    public static final int Type_PAYCHECK = 39;
    public static final int Type_PAYCHECK_POST = 40;
    private Thread thread = null;
    private Vector allListener = null;
    private boolean isDownloading = false;

    public void DealList(long cityId, int start, int offset, int catalogIndex) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("cityid", String.valueOf(cityId));
        params.put("start", String.valueOf(start));
        params.put("offset", String.valueOf(offset));
        params.put("catalogid", String.valueOf(Deal.CATALOGS[catalogIndex]));
        this.start("http://m.nuomi.com/client/deallist/withorder" + DataDownload.makeUrlTail(params), 0, new Integer(catalogIndex));
    }

    public void DealList(String ids, int catalogIndex) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("ids", ids);
        this.start("http://m.nuomi.com/client/deallist/byids", 1, new Integer(catalogIndex), DataDownload.makePostBody(params));
    }

    public void cityAll() {
        String url = "http://m.nuomi.com/client/city/all" + DataDownload.makeUrlTail(null);
        this.start(url, 4, null);
    }

    public void voucherHot(long cityId, int start, int offset) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("cityid", String.valueOf(cityId));
        params.put("start", String.valueOf(start));
        params.put("offset", String.valueOf(offset));
        String url = "http://m.nuomi.com/client/voucher/hot" + DataDownload.makeUrlTail(params);
        this.start(url, 5, new Integer(0));
    }

    public void voucherAll(long cityId, long areaId, long catalogId, int start, int offset) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("cityid", String.valueOf(cityId));
        params.put("areaid", String.valueOf(areaId));
        params.put("catalogid", String.valueOf(catalogId));
        params.put("start", String.valueOf(start));
        params.put("offset", String.valueOf(offset));
        String url = "http://m.nuomi.com/client/voucher/all" + DataDownload.makeUrlTail(params);
        this.start(url, 6, new Integer(1));
    }

    public void login(String username, String password, String code) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("username", username);
        params.put("password", password);
        if (!Methods.isNullOrEmpty(code)) {
            params.put("code", code);
        }
        this.start("http://m.nuomi.com/client/login", 7, username, DataDownload.makePostBody(params));
    }

    public void nuomidata(long userId, String ticket) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("userid", String.valueOf(userId));
        params.put("ticket", ticket);
        String url = "http://m.nuomi.com/client/nuomidata" + DataDownload.makeUrlTail(params);
        this.start(url, 30, null);
    }

    public void register(String username, String password, String nickname, long cityId) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("username", username);
        params.put("password", password);
        params.put("nickname", nickname);
        params.put("cityid", String.valueOf(cityId));
        this.start("http://m.nuomi.com/client/register", 19, username, DataDownload.makePostBody(params));
    }

    public void active(long userId, String ticket, String code) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("userid", String.valueOf(userId));
        params.put("ticket", ticket);
        params.put("code", code);
        String url = "http://m.nuomi.com/client/active" + DataDownload.makeUrlTail(params);
        this.start(url, 20, null);
    }

    public void resendCode(long userId, String ticket) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("userid", String.valueOf(userId));
        params.put("ticket", ticket);
        String url = "http://m.nuomi.com/client/resendcode" + DataDownload.makeUrlTail(params);
        this.start(url, 21, null);
    }

    public void getAddresses(long userId, String ticket) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("userid", String.valueOf(userId));
        params.put("ticket", ticket);
        String url = "http://m.nuomi.com/client/getaddresses" + DataDownload.makeUrlTail(params);
        this.start(url, 8, null);
    }

    public void feedback(String msg, String email, String userId) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("model", PhoneFunction.getModel());
        params.put("msg", URLEncode.UrlEncodeUnicode(msg));
        if (!Methods.isNullOrEmpty(email)) {
            params.put("email", URLEncode.UrlEncodeUnicode(email));
        }
        if (!Methods.isNullOrEmpty(userId)) {
            params.put("userid", userId);
        }
        this.start("http://m.nuomi.com/client/feedback", 9, DataDownload.makePostBody(params));
    }

    public void dealDetail(long dealId) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("dealid", String.valueOf(dealId));
        String url = "http://m.nuomi.com/client/dealdetail" + DataDownload.makeUrlTail(params);
        this.start(url, 10, null);
    }

    public void dealEndTime(long dealId) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("dealid", String.valueOf(dealId));
        String url = "http://m.nuomi.com/client/dealendtime" + DataDownload.makeUrlTail(params);
        this.start(url, 37, null);
    }

    public void lotteryDetail(long dealId) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("dealid", String.valueOf(dealId));
        String url = "http://m.nuomi.com/client/lottery/detail" + DataDownload.makeUrlTail(params);
        this.start(url, 11, null);
    }

    public void voucherDetail(long voucherId) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("voucherid", String.valueOf(voucherId));
        String url = "http://m.nuomi.com/client/voucher/detail" + DataDownload.makeUrlTail(params);
        this.start(url, 12, null);
    }

    public void voucherSendSms(long userId, String ticket, long voucherId, String phone) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("userid", String.valueOf(userId));
        params.put("ticket", ticket);
        params.put("voucherid", String.valueOf(voucherId));
        params.put("phone", phone);
        String url = "http://m.nuomi.com/client/voucher/sendSms" + DataDownload.makeUrlTail(params);
        this.start(url, 13, null);
    }

    public void couponAll(long userId, String ticket, int start, int offset, int status) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("userid", String.valueOf(userId));
        params.put("ticket", ticket);
        params.put("start", String.valueOf(start));
        params.put("offset", String.valueOf(offset));
        params.put("status", String.valueOf(status));
        String url = "http://m.nuomi.com/client/coupon/all" + DataDownload.makeUrlTail(params);
        this.start(url, 14, new Integer(status));
    }

    public void couponDetail(long dealId) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("dealid", String.valueOf(dealId));
        String url = "http://m.nuomi.com/client/coupon/detail" + DataDownload.makeUrlTail(params);
        this.start(url, 17, null);
    }

    public void getQRCode(long userId, String ticket, long couponId, String phone) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("userid", String.valueOf(userId));
        params.put("ticket", ticket);
        params.put("couponId", String.valueOf(couponId));
        params.put("phone", String.valueOf(phone));
        String url = "http://m.nuomi.com/client/coupon/getqrcode" + DataDownload.makeUrlTail(params);
        this.start(url, 38, null);
    }

    public void postOrderAll(long userId, String ticket, int start, int offset, int status) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("userid", String.valueOf(userId));
        params.put("ticket", ticket);
        params.put("start", String.valueOf(start));
        params.put("offset", String.valueOf(offset));
        params.put("status", String.valueOf(status));
        String url = "http://m.nuomi.com/client/postorder/all" + DataDownload.makeUrlTail(params);
        this.start(url, 15, new Integer(status));
    }

    public void postOrderDetail(long dealId) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("dealid", String.valueOf(dealId));
        String url = "http://m.nuomi.com/client/postorder/detail" + DataDownload.makeUrlTail(params);
        this.start(url, 18, null);
    }

    public void lotteryAll(long userId, String ticket, int start, int offset, int endStatus) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("userid", String.valueOf(userId));
        params.put("ticket", ticket);
        params.put("start", String.valueOf(start));
        params.put("offset", String.valueOf(offset));
        params.put("isEnd", String.valueOf(endStatus == 1));
        String url = "http://m.nuomi.com/client/lottery/all" + DataDownload.makeUrlTail(params);
        this.start(url, 16, new Integer(endStatus));
    }

    public void bindPhoneCode(long userId, String ticket, String phone) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("userid", String.valueOf(userId));
        params.put("ticket", ticket);
        params.put("phone", phone);
        String url = "http://m.nuomi.com/client/bindphonecode" + DataDownload.makeUrlTail(params);
        this.start(url, 22, null);
    }

    public void bindPhone(long userId, String ticket, String phone, String code) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("userid", String.valueOf(userId));
        params.put("ticket", ticket);
        params.put("phone", phone);
        params.put("code", code);
        String url = "http://m.nuomi.com/client/bindphone" + DataDownload.makeUrlTail(params);
        this.start(url, 23, null);
    }

    public void joinLottery(long userId, String ticket, long dealId) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("userid", String.valueOf(userId));
        params.put("ticket", ticket);
        params.put("dealid", String.valueOf(dealId));
        String url = "http://m.nuomi.com/client/lottery/join" + DataDownload.makeUrlTail(params);
        this.start(url, 24, null);
    }

    public void buy(long userId, String ticket, long dealId) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("userid", String.valueOf(userId));
        params.put("ticket", ticket);
        params.put("dealid", String.valueOf(dealId));
        String url = "http://m.nuomi.com/client/buy" + DataDownload.makeUrlTail(params);
        this.start(url, 25, null);
    }

    public void orderCheck(OrderCheckInfo info) {
        if (info == null) {
            return;
        }
        Hashtable<String, String> params = new Hashtable<String, String>();
        if (info.userId != null) {
            params.put("userid", String.valueOf(info.userId));
        }
        if (info.ticket != null) {
            params.put("ticket", info.ticket);
        }
        if (info.dealid != null) {
            params.put("dealid", String.valueOf(info.dealid));
        }
        if (info.cityid != null) {
            params.put("cityid", String.valueOf(info.cityid));
        }
        if (info.deliverytype != null) {
            if (info.deliverytype == 0) {
                params.put("deliverytype", "3");
            } else {
                params.put("deliverytype", String.valueOf(info.deliverytype));
            }
        }
        if (info.addressid != null) {
            params.put("addressedid", String.valueOf(info.addressid));
        } else {
            if (info.name != null) {
                params.put("name", info.name);
            }
            if (info.areaCode != null) {
                params.put("areaCode", info.areaCode);
            }
            if (info.address != null) {
                params.put("address", info.address);
            }
            if (info.postcode != null) {
                params.put("postcode", info.postcode);
            }
            if (info.phone != null) {
                params.put("phone", info.phone);
            }
        }
        if (info.other != null) {
            params.put("other", info.other);
        }
        if (info.needinvoice != null) {
            params.put("needinvoice", String.valueOf(info.needinvoice));
        }
        if (info.invoicetitle != null) {
            params.put("invoicetitle", info.invoicetitle);
        }
        if (info.invoicetype != null) {
            params.put("invoicetype", String.valueOf(info.invoicetype + 1));
        }
        if (info.getSelectedOptionsJsonString() != null) {
            params.put("selectedOption", info.getSelectedOptionsJsonString());
        }
        if (info.giftcard != null && info.giftcard.giftcardid != null) {
            params.put("giftcardId", String.valueOf(info.giftcard.giftcardid));
        }
        if (info.checkCode != null) {
            params.put("checkCode", info.checkCode);
        }
        params.put("version", "2.2.0");
        this.start("http://m.nuomi.com/client/ordercheck", 26, null, DataDownload.makePostBody(params));
    }

    public void payCheck(OrderCheckInfo info, Double cost) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        if (info.userId != null) {
            params.put("userid", String.valueOf(info.userId));
        }
        if (info.ticket != null) {
            params.put("ticket", info.ticket);
        }
        params.put("cost", String.valueOf(cost));
        this.start("http://m.nuomi.com/client/paycheck", 39, null, DataDownload.makePostBody(params));
    }

    public void payCheckPost(OrderCheckInfo info) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        if (info.userId != null) {
            params.put("userid", String.valueOf(info.userId));
        }
        if (info.ticket != null) {
            params.put("ticket", info.ticket);
        }
        this.start("http://m.nuomi.com/client/paycheck/post", 40, null, DataDownload.makePostBody(params));
    }

    public void payByBalance(long userId, String ticket, long orderId) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("userid", String.valueOf(userId));
        params.put("ticket", ticket);
        params.put("orderid", String.valueOf(orderId));
        String url = "http://m.nuomi.com/client/paybybalance" + DataDownload.makeUrlTail(params);
        this.start(url, 27, null);
    }

    public void payStatus(long userId, String ticket, long orderId) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("userid", String.valueOf(userId));
        params.put("ticket", ticket);
        params.put("orderid", String.valueOf(orderId));
        String url = "http://m.nuomi.com/client/paystatus" + DataDownload.makeUrlTail(params);
        this.start(url, 28, null);
    }

    public void onStart() {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("channel", PhoneFunction.getChannel());
        params.put("id", PhoneFunction.getImei());
        params.put("width", PhoneFunction.getWidth());
        params.put("height", PhoneFunction.getHeight());
        params.put("model", PhoneFunction.getModel());
        this.start("http://m.nuomi.com/client/onstart", 31, null, DataDownload.makePostBody(params));
    }

    public void getVersion(Object tag) {
        this.start("http://m.nuomi.com/client/getversion" + DataDownload.makeUrlTail(null), 32, tag);
    }

    public void giftcardAll(long userId, String ticket, int start, int offset, int status) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("userid", String.valueOf(userId));
        params.put("ticket", ticket);
        params.put("start", String.valueOf(start));
        params.put("offset", String.valueOf(offset));
        params.put("status", String.valueOf(status));
        String url = "http://m.nuomi.com/client/giftcard/all" + DataDownload.makeUrlTail(params);
        this.start(url, 33, new Integer(status));
    }

    public void giftcardCheck(long userId, String ticket, String giftcard) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("userid", String.valueOf(userId));
        params.put("ticket", ticket);
        params.put("giftcard", giftcard);
        String url = "http://m.nuomi.com/client/giftcard/checkgiftcard" + DataDownload.makeUrlTail(params);
        this.start(url, 34, null);
    }

    public void accountAll(long userId, String ticket, int start, int offset) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("userid", String.valueOf(userId));
        params.put("ticket", ticket);
        params.put("start", String.valueOf(start));
        params.put("offset", String.valueOf(offset));
        String url = "http://m.nuomi.com/client/account/all" + DataDownload.makeUrlTail(params);
        this.start(url, 35, null);
    }

    public void rechargeUrl(long userId, String ticket, double amount) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("userid", String.valueOf(userId));
        params.put("ticket", ticket);
        params.put("amount", String.valueOf(amount));
        String url = "http://m.nuomi.com/client/account/recharge" + DataDownload.makeUrlTail(params);
        this.start(url, 36, null);
    }

    public static String makeAliayRoot(long userId, String ticket, long orderId) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("userid", String.valueOf(userId));
        params.put("ticket", ticket);
        params.put("orderId", String.valueOf(orderId));
        return "http://m.nuomi.com/client/pay/alipay" + DataDownload.makeUrlTail(params);
    }

    public void cancel() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
            this.sendResultListener(3, null, -1, null);
        }
        this.isDownloading = false;
    }

    public boolean isDownloading() {
        return this.isDownloading;
    }

    private void start(String url, int type, Object tag) {
        this.start(url, type, tag, null);
    }

    private void start(final String url, final int type, Object tag, final String postBody) {
        this.isDownloading = true;
        this.sendStartListener(tag);
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        this.thread = new Thread(tag){

            public void run() {
                int result = 0;
                Data data = null;
                try {
                    String resultString = HttpConnect.sendHttp(url, postBody);
                    if (Methods.isNullOrEmpty(resultString)) {
                        result = 2;
                        data = null;
                    } else {
                        switch (type) {
                            case 0: 
                            case 1: {
                                data = DealList.create(resultString);
                                break;
                            }
                            case 4: {
                                data = FindCitys.create(resultString);
                                break;
                            }
                            case 5: 
                            case 6: {
                                data = FindVouchers.create(resultString);
                                break;
                            }
                            case 7: 
                            case 19: 
                            case 30: {
                                data = Login.create(resultString, (String)this.tag);
                                break;
                            }
                            case 8: {
                                data = GetAddresses.create(resultString);
                                break;
                            }
                            case 10: 
                            case 17: 
                            case 18: {
                                data = Deal.create(resultString);
                                break;
                            }
                            case 11: {
                                data = LotteryDeal.create(resultString);
                                break;
                            }
                            case 12: {
                                data = Voucher.create(resultString);
                                break;
                            }
                            case 13: 
                            case 20: 
                            case 21: 
                            case 22: 
                            case 23: 
                            case 38: {
                                data = ResultInfo.create(resultString);
                                break;
                            }
                            case 14: {
                                data = FindMyNuomiInfo.create(resultString, 0);
                                break;
                            }
                            case 15: {
                                data = FindMyNuomiInfo.create(resultString, 1);
                                break;
                            }
                            case 16: {
                                data = FindMyNuomiInfo.create(resultString, 2);
                                break;
                            }
                            case 24: {
                                data = JoinLotteryResult.create(resultString);
                                break;
                            }
                            case 25: {
                                data = BuyDealResult.create(resultString);
                                break;
                            }
                            case 26: {
                                data = OrderCheckResult.create(resultString);
                                break;
                            }
                            case 27: {
                                data = PayByBlanceResult.create(resultString);
                                break;
                            }
                            case 31: 
                            case 32: {
                                data = GetVersion.create(resultString);
                                break;
                            }
                            case 33: {
                                data = GiftCards.create(resultString);
                                break;
                            }
                            case 34: {
                                data = GiftCardCheck.create(resultString);
                                break;
                            }
                            case 35: {
                                data = AccountAll.create(resultString);
                                break;
                            }
                            case 36: {
                                data = RechargeUrl.create(resultString);
                                break;
                            }
                            case 37: {
                                data = DealEndTime.create(resultString);
                                break;
                            }
                            case 28: {
                                data = PayStatusResult.create(resultString);
                                break;
                            }
                            case 39: {
                                data = PayCheckResult.create(resultString);
                                break;
                            }
                        }
                        result = data == null ? 4 : 2;
                    }
                }
                catch (NetworkException e) {
                    e.printStackTrace();
                    switch (e.type) {
                        case 1: {
                            result = 5;
                            break;
                        }
                        default: {
                            result = 1;
                        }
                    }
                    data = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = 4;
                    data = null;
                }
                if (!this.isStoped && result != 0) {
                    DataDownload.this.sendResultListener(result, data, type, this.tag);
                }
                DataDownload.this.self.isDownloading = false;
            }
        };
        this.thread.start();
    }

    public void addDownloadListener(DataDownloadListener listener) {
        if (this.allListener == null) {
            this.allListener = new Vector();
        }
        this.allListener.addElement(listener);
    }

    private void sendResultListener(int result, Object data, int type, Object tag) {
        if (this.allListener != null) {
            int i = 0;
            while (i < this.allListener.size()) {
                Object listener = this.allListener.elementAt(i);
                if (listener instanceof DataDownloadListener) {
                    ((DataDownloadListener)listener).onDownloadCompleted(result, data, type, tag);
                }
                ++i;
            }
        }
    }

    private void sendStartListener(Object tag) {
        if (this.allListener != null) {
            int i = 0;
            while (i < this.allListener.size()) {
                Object listener = this.allListener.elementAt(i);
                if (listener instanceof DataDownloadListener) {
                    ((DataDownloadListener)listener).onDownloadStart(tag);
                }
                ++i;
            }
        }
    }

    private static String makeUrlTail(Hashtable params) {
        return "?" + DataDownload.makePostBody(params);
    }

    private static String makePostBody(Hashtable params) {
        String result = "";
        if (params == null) {
            params = new Hashtable<String, String>();
        }
        params.put("client", "symbian");
        if (params.get("version") == null) {
            params.put("version", PhoneFunction.getVersion());
        }
        if (!params.isEmpty()) {
            Enumeration e = params.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = (String)params.get(key);
                result = String.valueOf(result) + key + "=" + URLEncode.UrlEncodeUnicode(value);
                if (!e.hasMoreElements()) continue;
                result = String.valueOf(result) + "&";
            }
        }
        return result;
    }
}

