/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.connect;

import com.sun.lwuit.Image;
import java.util.Enumeration;
import java.util.Hashtable;

public class ImageCache {
    private static ImageCache s_ImageCache = null;
    private final int MAX_IMAGE_COUNT;
    Hashtable m_htImageCache = new Hashtable();

    public ImageCache() {
        this.MAX_IMAGE_COUNT = 20;
    }

    public static void addImage(String src, Image img, long size) {
        if (src == null || img == null) {
            return;
        }
        if (s_ImageCache == null) {
            s_ImageCache = new ImageCache();
        }
        ImageCache.s_ImageCache.m_htImageCache.put(src, s_ImageCache.new MyImage(img, size));
        s_ImageCache.deleteOldImg();
    }

    public static Image getImage(String src) {
        if (s_ImageCache != null && ImageCache.s_ImageCache.m_htImageCache != null && ImageCache.s_ImageCache.m_htImageCache.containsKey(src)) {
            return ((MyImage)ImageCache.s_ImageCache.m_htImageCache.get((Object)src)).img;
        }
        return null;
    }

    public static long getSize() {
        if (s_ImageCache != null && ImageCache.s_ImageCache.m_htImageCache != null) {
            long size = 0L;
            Enumeration e = ImageCache.s_ImageCache.m_htImageCache.keys();
            while (e.hasMoreElements()) {
                String src = (String)e.nextElement();
                long imgSize = ((MyImage)ImageCache.s_ImageCache.m_htImageCache.get((Object)src)).size;
                size += (long)src.getBytes().length;
                size += imgSize;
            }
            return size;
        }
        return 0L;
    }

    public static void clear() {
        if (s_ImageCache != null && ImageCache.s_ImageCache.m_htImageCache != null) {
            ImageCache.s_ImageCache.m_htImageCache.clear();
        }
    }

    private void deleteOldImg() {
        if (this.m_htImageCache != null && this.m_htImageCache.size() > 20) {
            Enumeration keys = this.m_htImageCache.keys();
            Object oldestKey = keys.nextElement();
            MyImage oldestImage = (MyImage)this.m_htImageCache.get(oldestKey);
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                MyImage img = (MyImage)this.m_htImageCache.get(key);
                if (img.createTime >= oldestImage.createTime) continue;
                oldestKey = key;
                oldestImage = img;
            }
            this.m_htImageCache.remove(oldestKey);
        }
    }

    private class MyImage {
        Image img = null;
        long size = 0L;
        long createTime = 0L;

        public MyImage(Image img, long size) {
            this.img = img;
            this.size = size;
            this.createTime = System.currentTimeMillis();
        }
    }
}

