/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.connect;

public class URLEncode {
    public static String UrlEncodeUnicode(String s) {
        int length = s.length();
        StringBuffer builder = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            char ch = s.charAt(i);
            if ((ch & 0xFF80) == 0) {
                if (URLEncode.IsSafe(ch)) {
                    builder.append(ch);
                } else if (ch == ' ') {
                    builder.append('+');
                } else {
                    builder.append('%');
                    builder.append(URLEncode.IntToHex(ch >> 4 & 0xF));
                    builder.append(URLEncode.IntToHex(ch & 0xF));
                }
            } else {
                builder.append("%u");
                builder.append(URLEncode.IntToHex(ch >> 12 & 0xF));
                builder.append(URLEncode.IntToHex(ch >> 8 & 0xF));
                builder.append(URLEncode.IntToHex(ch >> 4 & 0xF));
                builder.append(URLEncode.IntToHex(ch & 0xF));
            }
            ++i;
        }
        return builder.toString();
    }

    private static char IntToHex(int n) {
        if (n <= 9) {
            return (char)(n + 48);
        }
        return (char)(n - 10 + 97);
    }

    private static boolean IsSafe(char ch) {
        if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') {
            return true;
        }
        switch (ch) {
            case '!': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '-': 
            case '.': 
            case '_': {
                return true;
            }
        }
        return false;
    }
}

