/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.data;

import com.nuomi.data.Data;
import com.nuomi.utils.Methods;
import java.util.Calendar;
import org.json.me.JSONObject;

public class Account
extends Data {
    public static String[] TypeStrings = new String[]{"\u6536\u5165", "\u652f\u51fa"};
    public Long accountId = null;
    public String consume = null;
    public Long payTime = null;
    public Integer type = null;
    public Double amount = null;
    public Double balance = null;
    public Calendar payTimeCalendar = null;
    public String typeString = null;

    public static Account create(String jsonString) {
        if (Methods.isNullOrEmpty(jsonString)) {
            return null;
        }
        try {
            Account account = new Account();
            account.jsonString = jsonString;
            JSONObject jsonObject = new JSONObject(jsonString);
            account.accountId = Methods.getJOLong(jsonObject, "accountId");
            account.consume = Methods.getJOString(jsonObject, "consume");
            account.payTime = Methods.getJOLong(jsonObject, "payTime");
            if (account.payTime != null) {
                account.payTimeCalendar = Methods.createCalendar(account.payTime);
            }
            account.type = Methods.getJOInt(jsonObject, "type");
            if (account.type != null && (account.type == 0 || account.type == 1)) {
                account.typeString = TypeStrings[account.type];
            }
            account.amount = Methods.getJODouble(jsonObject, "amount");
            account.balance = Methods.getJODouble(jsonObject, "balance");
            return account;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

