/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.data;

import com.nuomi.data.Data;
import com.nuomi.data.DealOption;
import com.nuomi.data.PostAddress;
import com.nuomi.data.ResultInfo;
import com.nuomi.utils.Methods;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class BuyDealResult
extends Data {
    public ResultInfo result = null;
    public Double balance = null;
    public Boolean hasOption = null;
    public Boolean multiOption = null;
    public Integer lowLimit = null;
    public Integer limit = null;
    public Boolean delivery = null;
    public Boolean elong = null;
    public Vector options = null;
    public Vector addresses = null;

    public static BuyDealResult create(String jsonString) {
        if (Methods.isNullOrEmpty(jsonString)) {
            return null;
        }
        try {
            JSONArray addressesArray;
            BuyDealResult buyDealResult = new BuyDealResult();
            buyDealResult.jsonString = jsonString;
            JSONObject jsonObject = new JSONObject(jsonString);
            buyDealResult.result = new ResultInfo(Methods.getJOInt(jsonObject, "succ"), Methods.getJOString(jsonObject, "msg"));
            buyDealResult.balance = Methods.getJODouble(jsonObject, "balance");
            buyDealResult.hasOption = Methods.getJOBoolean(jsonObject, "hasOption");
            buyDealResult.multiOption = Methods.getJOBoolean(jsonObject, "multiOption");
            buyDealResult.lowLimit = Methods.getJOInt(jsonObject, "lowLimit");
            buyDealResult.limit = Methods.getJOInt(jsonObject, "limit");
            buyDealResult.delivery = Methods.getJOBoolean(jsonObject, "delivery");
            buyDealResult.elong = Methods.getJOBoolean(jsonObject, "elong");
            JSONArray optionsArray = Methods.getJOArray(jsonObject, "options");
            if (optionsArray != null) {
                int length = optionsArray.length();
                buyDealResult.options = new Vector();
                int i = 0;
                while (i < length) {
                    String optionString = optionsArray.getString(i);
                    DealOption option = DealOption.create(optionString);
                    if (option != null) {
                        buyDealResult.options.addElement(option);
                    }
                    ++i;
                }
            }
            if ((addressesArray = Methods.getJOArray(jsonObject, "addresses")) != null) {
                int length = addressesArray.length();
                buyDealResult.addresses = new Vector();
                int i = 0;
                while (i < length) {
                    String addressString = addressesArray.getString(i);
                    PostAddress address = PostAddress.create(addressString);
                    if (address != null) {
                        buyDealResult.addresses.addElement(address);
                    }
                    ++i;
                }
            }
            return buyDealResult;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

