/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.data;

import com.nuomi.data.Data;
import com.nuomi.utils.Methods;
import java.util.Calendar;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class Coupon
extends Data {
    public static final int NEW_BUY = 0;
    public static final int WILL_EXPIRE = 1;
    public static final int EXPIRED = 2;
    public static final int USED = 3;
    public Long couponId = null;
    public Long dealId = null;
    public String middleTitle = null;
    public String minTitle = null;
    public String businessName = null;
    public String image = null;
    public Long buyTime = null;
    public Long expireTime = null;
    public Long startTime = null;
    public Long usedTime = null;
    public String password = null;
    public String distance = null;
    public String share = null;
    public Boolean isNuomiPassword = null;
    public Boolean isQRCode = null;
    public Calendar buyTimeCalendar = null;
    public Calendar expireTimeCalendar = null;
    public Calendar startTimeCalendar = null;
    public Calendar usedTimeCalendar = null;

    public static Coupon create(String jsonString) {
        if (Methods.isNullOrEmpty(jsonString)) {
            return null;
        }
        try {
            Coupon coupon = new Coupon();
            coupon.jsonString = jsonString;
            JSONObject jsonObject = new JSONObject(jsonString);
            coupon.couponId = Methods.getJOLong(jsonObject, "couponId");
            coupon.dealId = Methods.getJOLong(jsonObject, "dealId");
            coupon.middleTitle = Methods.getJOString(jsonObject, "middleTitle");
            coupon.minTitle = Methods.getJOString(jsonObject, "minTitle");
            coupon.businessName = Methods.getJOString(jsonObject, "businessName");
            coupon.image = Methods.getJOString(jsonObject, "image");
            coupon.buyTime = Methods.getJOLong(jsonObject, "buyTime");
            if (coupon.buyTime != null) {
                coupon.buyTimeCalendar = Methods.createCalendar(coupon.buyTime);
            }
            coupon.expireTime = Methods.getJOLong(jsonObject, "expireTime");
            if (coupon.expireTime != null) {
                coupon.expireTimeCalendar = Methods.createCalendar(coupon.expireTime);
            }
            coupon.startTime = Methods.getJOLong(jsonObject, "startTime");
            if (coupon.startTime != null) {
                coupon.startTimeCalendar = Methods.createCalendar(coupon.startTime);
            }
            coupon.usedTime = Methods.getJOLong(jsonObject, "usedTime");
            if (coupon.usedTime != null) {
                coupon.usedTimeCalendar = Methods.createCalendar(coupon.usedTime);
            }
            coupon.password = Methods.getJOString(jsonObject, "password");
            coupon.distance = Methods.getJOString(jsonObject, "distance");
            coupon.share = Methods.getJOString(jsonObject, "share");
            coupon.isNuomiPassword = Methods.getJOBoolean(jsonObject, "isNuomiPassword");
            coupon.isQRCode = Methods.getJOBoolean(jsonObject, "isQRCode");
            return coupon;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

