/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.data;

import com.nuomi.data.BusinessInfo;
import com.nuomi.data.Data;
import com.nuomi.utils.Methods;
import java.util.Calendar;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class Deal
extends Data {
    public static final int ALL = -1;
    public static final int MEISHI = 326;
    public static final int YULE = 320;
    public static final int SHENGHUO = 316;
    public static final int GOUWU = 330;
    public static final int LVYOU = 377;
    public static final int QITA = 323;
    public static final int[] CATALOGS = new int[]{-1, 326, 320, 316, 330, 377, 323};
    public Double currentPrice = null;
    public Double marketPrice = null;
    public String discount = null;
    public String image = null;
    public Integer saleCount = null;
    public String setMeal = null;
    public String highlights = null;
    public String consumerTips = null;
    public String detail = null;
    public String introductionWap = null;
    public String businessInfo = null;
    public Vector business = null;
    public Boolean daysRefund = null;
    public Boolean expiredRefund = null;
    public Long now = null;
    public Long endTime = null;
    public Calendar endTimeCalendar = null;

    public static Deal create(String jsonString) {
        if (Methods.isNullOrEmpty(jsonString)) {
            return null;
        }
        try {
            Deal deal = new Deal();
            deal.jsonString = jsonString;
            JSONObject jsonObject = new JSONObject(jsonString);
            deal.currentPrice = Methods.getJODouble(jsonObject, "currentPrice");
            deal.marketPrice = Methods.getJODouble(jsonObject, "marketPrice");
            deal.discount = Methods.getJOString(jsonObject, "discount");
            deal.image = Methods.getJOString(jsonObject, "image");
            deal.saleCount = Methods.getJOInt(jsonObject, "saleCount");
            deal.setMeal = Methods.getJOString(jsonObject, "setMeal");
            deal.highlights = Methods.getJOString(jsonObject, "highlights");
            deal.consumerTips = Methods.getJOString(jsonObject, "consumerTips");
            deal.detail = Methods.getJOString(jsonObject, "detail");
            deal.introductionWap = Methods.getJOString(jsonObject, "introductionWap");
            deal.businessInfo = Methods.getJOString(jsonObject, "businessInfo");
            JSONArray businessArray = Methods.getJOArray(jsonObject, "business");
            if (businessArray != null) {
                int length = businessArray.length();
                deal.business = new Vector();
                int i = 0;
                while (i < length) {
                    String businessString = businessArray.getString(i);
                    BusinessInfo businessInfo = BusinessInfo.create(businessString);
                    if (businessInfo != null) {
                        deal.business.addElement(businessInfo);
                    }
                    ++i;
                }
            }
            deal.daysRefund = Methods.getJOBoolean(jsonObject, "daysRefund");
            deal.expiredRefund = Methods.getJOBoolean(jsonObject, "expiredRefund");
            deal.now = Methods.getJOLong(jsonObject, "now");
            deal.endTime = Methods.getJOLong(jsonObject, "endTime");
            if (deal.endTime != null) {
                deal.endTimeCalendar = Methods.createCalendar(deal.endTime);
            }
            return deal;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

