/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.data;

import com.nuomi.data.BusinessInfo;
import com.nuomi.data.Data;
import com.nuomi.utils.Methods;
import java.util.Calendar;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class DealPreview
extends Data {
    public Long dealId = null;
    public Integer catalogId = null;
    public Boolean isLottery = null;
    public String tinyImage = null;
    public String image = null;
    public String middleTitle = null;
    public String minTitle = null;
    public Double currentPrice = null;
    public Double marketPrice = null;
    public String discount = null;
    public Integer saleCount = null;
    public String area = null;
    public Long endTime = null;
    public Boolean soldOut = null;
    public Boolean onlyPhone = null;
    public Boolean isNew = null;
    public String share = null;
    public Vector business = null;
    public Calendar endTimeCalendar = null;

    public static DealPreview create(String jsonString) {
        if (Methods.isNullOrEmpty(jsonString)) {
            return null;
        }
        try {
            DealPreview dealPreview = new DealPreview();
            dealPreview.jsonString = jsonString;
            JSONObject jsonObject = new JSONObject(jsonString);
            dealPreview.dealId = Methods.getJOLong(jsonObject, "dealId");
            dealPreview.catalogId = Methods.getJOInt(jsonObject, "catalogId");
            dealPreview.isLottery = Methods.getJOBoolean(jsonObject, "isLottery");
            dealPreview.image = dealPreview.tinyImage = Methods.getJOString(jsonObject, "tinyImage");
            dealPreview.middleTitle = Methods.getJOString(jsonObject, "middleTitle");
            dealPreview.minTitle = Methods.getJOString(jsonObject, "minTitle");
            dealPreview.currentPrice = Methods.getJODouble(jsonObject, "currentPrice");
            dealPreview.marketPrice = Methods.getJODouble(jsonObject, "marketPrice");
            dealPreview.discount = Methods.getJOString(jsonObject, "discount");
            dealPreview.saleCount = Methods.getJOInt(jsonObject, "saleCount");
            dealPreview.area = Methods.getJOString(jsonObject, "area");
            dealPreview.endTime = Methods.getJOLong(jsonObject, "endTime");
            if (dealPreview.endTime != null) {
                dealPreview.endTimeCalendar = Methods.createCalendar(dealPreview.endTime);
            }
            dealPreview.soldOut = Methods.getJOBoolean(jsonObject, "soldOut");
            dealPreview.isNew = Methods.getJOBoolean(jsonObject, "isNew");
            dealPreview.onlyPhone = Methods.getJOBoolean(jsonObject, "onlyPhone");
            dealPreview.share = Methods.getJOString(jsonObject, "share");
            JSONArray businessArray = Methods.getJOArray(jsonObject, "business");
            if (businessArray != null) {
                int length = businessArray.length();
                dealPreview.business = new Vector();
                int i = 0;
                while (i < length) {
                    String businessString = businessArray.getString(i);
                    BusinessInfo businessInfo = BusinessInfo.create(businessString);
                    if (businessInfo != null) {
                        dealPreview.business.addElement(businessInfo);
                    }
                    ++i;
                }
            }
            return dealPreview;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

