/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.data;

import com.nuomi.data.Coupon;
import com.nuomi.data.Data;
import com.nuomi.data.Lottery;
import com.nuomi.data.PostOrder;
import com.nuomi.data.ResultInfo;
import com.nuomi.utils.Methods;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class FindMyNuomiInfo
extends Data {
    public static final int Type_Coupon = 0;
    public static final int Type_PostOrder = 1;
    public static final int Type_Lottery = 2;
    public int type;
    public ResultInfo result = null;
    public Integer count = null;
    public Vector informations = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FindMyNuomiInfo create(String jsonString, int type) {
        if (Methods.isNullOrEmpty(jsonString)) {
            return null;
        }
        try {
            FindMyNuomiInfo findMyNuomiInfo = new FindMyNuomiInfo();
            findMyNuomiInfo.jsonString = jsonString;
            findMyNuomiInfo.type = type;
            JSONObject jsonObject = new JSONObject(jsonString);
            findMyNuomiInfo.result = new ResultInfo(Methods.getJOInt(jsonObject, "succ"), null);
            findMyNuomiInfo.count = Methods.getJOInt(jsonObject, "count");
            switch (type) {
                case 0: {
                    JSONArray couponArray = Methods.getJOArray(jsonObject, "coupons");
                    if (couponArray == null) return findMyNuomiInfo;
                    int length = couponArray.length();
                    findMyNuomiInfo.informations = new Vector();
                    int i = 0;
                    while (true) {
                        if (i >= length) {
                            return findMyNuomiInfo;
                        }
                        String couponString = couponArray.getString(i);
                        Coupon coupon = Coupon.create(couponString);
                        if (coupon != null) {
                            findMyNuomiInfo.informations.addElement(coupon);
                        }
                        ++i;
                    }
                }
                case 1: {
                    JSONArray postOrderArray = Methods.getJOArray(jsonObject, "postorders");
                    if (postOrderArray == null) return findMyNuomiInfo;
                    int length = postOrderArray.length();
                    findMyNuomiInfo.informations = new Vector();
                    int i = 0;
                    while (true) {
                        if (i >= length) {
                            return findMyNuomiInfo;
                        }
                        String postOrderString = postOrderArray.getString(i);
                        PostOrder postOrder = PostOrder.create(postOrderString);
                        if (postOrder != null) {
                            findMyNuomiInfo.informations.addElement(postOrder);
                        }
                        ++i;
                    }
                }
                case 2: {
                    JSONArray lotteryArray = Methods.getJOArray(jsonObject, "lotteries");
                    if (lotteryArray == null) return findMyNuomiInfo;
                    int length = lotteryArray.length();
                    findMyNuomiInfo.informations = new Vector();
                    int i = 0;
                    while (i < length) {
                        String lotteryString = lotteryArray.getString(i);
                        Lottery lottery = Lottery.create(lotteryString);
                        if (lottery != null) {
                            findMyNuomiInfo.informations.addElement(lottery);
                        }
                        ++i;
                    }
                    return findMyNuomiInfo;
                }
            }
            return null;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

