/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.data;

import com.nuomi.data.Data;
import com.nuomi.utils.CalendarFormat;
import com.nuomi.utils.Methods;
import java.util.Calendar;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class GiftCard
extends Data {
    public Long giftcardid = null;
    public Double worth = null;
    public String condition = null;
    public Long expiredTime = null;
    public Calendar expiredTimeCalendar = null;

    public static GiftCard create(String jsonString) {
        if (Methods.isNullOrEmpty(jsonString)) {
            return null;
        }
        try {
            GiftCard giftCard = new GiftCard();
            giftCard.jsonString = jsonString;
            JSONObject jsonObject = new JSONObject(jsonString);
            giftCard.giftcardid = Methods.getJOLong(jsonObject, "giftcardid");
            giftCard.worth = Methods.getJODouble(jsonObject, "worth");
            giftCard.condition = Methods.getJOString(jsonObject, "condition");
            giftCard.expiredTime = Methods.getJOLong(jsonObject, "expiredTime");
            if (giftCard.expiredTime != null) {
                giftCard.expiredTimeCalendar = Methods.createCalendar(giftCard.expiredTime);
            }
            return giftCard;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return "\u91d1\u989d\uff1a" + Methods.formatPrice(this.worth) + "\u5143" + (Methods.isNullOrWhitespace(this.condition) ? "" : "\r\n\u4f7f\u7528\u6761\u4ef6\uff1a" + this.condition) + (this.expiredTimeCalendar == null ? "" : "\r\n\u5230\u671f\u65e5\u671f\uff1a" + CalendarFormat.toYMD(this.expiredTimeCalendar));
    }
}

