/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.data;

import com.nuomi.data.Data;
import com.nuomi.data.DealOptionPreview;
import com.nuomi.data.ResultInfo;
import com.nuomi.utils.Methods;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class OrderCheckResult
extends Data {
    public ResultInfo result = null;
    public Double totalPrice = null;
    public Double deliveryPrice = null;
    public Double balance = null;
    public Long orderId = null;
    public Vector options = null;
    public Double giftworth = null;
    public Double neededpay = null;

    public static OrderCheckResult create(String jsonString) {
        if (Methods.isNullOrEmpty(jsonString)) {
            return null;
        }
        try {
            OrderCheckResult orderCheckResult = new OrderCheckResult();
            orderCheckResult.jsonString = jsonString;
            JSONObject jsonObject = new JSONObject(jsonString);
            orderCheckResult.result = new ResultInfo(Methods.getJOInt(jsonObject, "succ"), Methods.getJOString(jsonObject, "msg"));
            orderCheckResult.totalPrice = Methods.getJODouble(jsonObject, "totalPrice");
            orderCheckResult.deliveryPrice = Methods.getJODouble(jsonObject, "deliveryPrice");
            orderCheckResult.balance = Methods.getJODouble(jsonObject, "balance");
            orderCheckResult.orderId = Methods.getJOLong(jsonObject, "orderId");
            JSONArray optionArray = Methods.getJOArray(jsonObject, "option");
            if (optionArray != null) {
                int length = optionArray.length();
                orderCheckResult.options = new Vector();
                int i = 0;
                while (i < length) {
                    String optionString = optionArray.getString(i);
                    DealOptionPreview dealOptionPreview = DealOptionPreview.create(optionString);
                    if (dealOptionPreview != null) {
                        orderCheckResult.options.addElement(dealOptionPreview);
                    }
                    ++i;
                }
            }
            orderCheckResult.giftworth = Methods.getJODouble(jsonObject, "giftworth");
            orderCheckResult.neededpay = Methods.getJODouble(jsonObject, "neededpay");
            return orderCheckResult;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

