/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.data;

import com.nuomi.data.Data;
import com.nuomi.data.PostOrderOption;
import com.nuomi.utils.Methods;
import java.util.Calendar;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class PostOrder
extends Data {
    public Long postorderId = null;
    public Long dealId = null;
    public String middleTitle = null;
    public String minTitle = null;
    public String businessName = null;
    public String image = null;
    public Long buyTime = null;
    public String postAddress = null;
    public String share = null;
    public Boolean canEditAddress = null;
    public Integer buyCount = null;
    public Double deliveryPrice = null;
    public Double price = null;
    public Vector options = null;
    public Calendar buyTimeCalendar = null;

    public static PostOrder create(String jsonString) {
        if (Methods.isNullOrEmpty(jsonString)) {
            return null;
        }
        try {
            PostOrder postOrder = new PostOrder();
            postOrder.jsonString = jsonString;
            JSONObject jsonObject = new JSONObject(jsonString);
            postOrder.postorderId = Methods.getJOLong(jsonObject, "postorderId");
            postOrder.dealId = Methods.getJOLong(jsonObject, "dealId");
            postOrder.middleTitle = Methods.getJOString(jsonObject, "middleTitle");
            postOrder.minTitle = Methods.getJOString(jsonObject, "minTitle");
            postOrder.businessName = Methods.getJOString(jsonObject, "businessName");
            postOrder.image = Methods.getJOString(jsonObject, "image");
            postOrder.buyTime = Methods.getJOLong(jsonObject, "buyTime");
            if (postOrder.buyTime != null) {
                postOrder.buyTimeCalendar = Methods.createCalendar(postOrder.buyTime);
            }
            postOrder.postAddress = Methods.getJOString(jsonObject, "postAddress");
            postOrder.share = Methods.getJOString(jsonObject, "share");
            postOrder.canEditAddress = Methods.getJOBoolean(jsonObject, "canEditAddress");
            postOrder.buyCount = Methods.getJOInt(jsonObject, "buyCount");
            postOrder.deliveryPrice = Methods.getJODouble(jsonObject, "deliveryPrice");
            postOrder.price = Methods.getJODouble(jsonObject, "price");
            JSONArray optionArray = Methods.getJOArray(jsonObject, "options");
            if (optionArray != null) {
                int length = optionArray.length();
                postOrder.options = new Vector();
                int i = 0;
                while (i < length) {
                    String optionString = optionArray.getString(i);
                    PostOrderOption option = PostOrderOption.create(optionString);
                    if (option != null) {
                        postOrder.options.addElement(option);
                    }
                    ++i;
                }
            }
            return postOrder;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

