/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.data;

import com.nuomi.data.BusinessInfo;
import com.nuomi.data.Data;
import com.nuomi.utils.Methods;
import java.util.Calendar;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class Voucher
extends Data {
    public Long startTime = null;
    public Integer downloadCount = null;
    public String number = null;
    public Integer businessDownloadCount = null;
    public Integer period = null;
    public String description = null;
    public String hint = null;
    public Vector branchs = null;
    public Calendar startTimeCalendar = null;

    public static Voucher create(String jsonString) {
        if (Methods.isNullOrEmpty(jsonString)) {
            return null;
        }
        try {
            Voucher voucher = new Voucher();
            voucher.jsonString = jsonString;
            JSONObject jsonObject = new JSONObject(jsonString);
            voucher.startTime = Methods.getJOLong(jsonObject, "startTime");
            if (voucher.startTime != null) {
                voucher.startTimeCalendar = Methods.createCalendar(voucher.startTime);
            }
            voucher.downloadCount = Methods.getJOInt(jsonObject, "downloadCount");
            voucher.number = Methods.getJOString(jsonObject, "number");
            voucher.businessDownloadCount = Methods.getJOInt(jsonObject, "businessDownloadCount");
            voucher.period = Methods.getJOInt(jsonObject, "period");
            voucher.description = Methods.getJOString(jsonObject, "description");
            voucher.hint = Methods.getJOString(jsonObject, "hint");
            JSONArray branchArray = Methods.getJOArray(jsonObject, "branchs");
            if (branchArray != null) {
                int length = branchArray.length();
                voucher.branchs = new Vector();
                int i = 0;
                while (i < length) {
                    String branchString = branchArray.getString(i);
                    BusinessInfo businessInfo = BusinessInfo.create(branchString);
                    if (businessInfo != null) {
                        voucher.branchs.addElement(businessInfo);
                    }
                    ++i;
                }
            }
            return voucher;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

