/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.dialogs;

import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.ContentContainer;
import com.nuomi.usercontrol.LabelGroup;
import com.nuomi.utils.Methods;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Vector;

public class MessageBox
extends Dialog {
    public static int OK = 0;
    public static int CANCEL = 1;
    private int result = OK;
    private final int Width;
    private final int Label_Height;
    private final int MaxRows;
    private ContentContainer mainContainer = null;
    private Container content = null;
    private Container msgContainer = null;
    private Button okButton = null;
    private Button cancelButton = null;
    public static boolean isShow = false;
    private static MessageBox singleButtonBox = null;
    private static MessageBox towButtonsBox = null;

    public static int Show(String msg, String okString, String cancelString) {
        return MessageBox.Show(msg, okString, cancelString, UserInterface.FONT_MESSAGEBOX);
    }

    public static int Show(String msg, String okString, String cancelString, Font msgFont) {
        if (cancelString == null) {
            if (singleButtonBox == null) {
                singleButtonBox = new MessageBox(okString, null);
            } else {
                singleButtonBox.setButtonTitle(okString, null);
            }
            singleButtonBox.setMsg(msg, msgFont);
            int xMargin = 3;
            int yMargin = (UserInterface.DISPLAY_HEIGHT - (MessageBox.singleButtonBox.mainContainer.getPreferredH() + 5)) / 2;
            isShow = true;
            singleButtonBox.show(yMargin, yMargin, xMargin, xMargin, false);
            return MessageBox.singleButtonBox.result;
        }
        if (towButtonsBox == null) {
            towButtonsBox = new MessageBox(okString, cancelString);
        } else {
            towButtonsBox.setButtonTitle(okString, cancelString);
        }
        towButtonsBox.setMsg(msg, msgFont);
        int xMargin = 3;
        int yMargin = Math.max(0, (UserInterface.DISPLAY_HEIGHT - (MessageBox.towButtonsBox.mainContainer.getPreferredH() + 5)) / 2);
        isShow = true;
        towButtonsBox.show(yMargin, yMargin, xMargin, xMargin, false);
        return MessageBox.towButtonsBox.result;
    }

    public MessageBox(String okString, String cancelString) {
        this.Width = 344;
        this.Label_Height = 33;
        this.MaxRows = 15;
        this.setScrollable(false);
        this.setScrollVisible(false);
        Container buttonContainer = new Container();
        buttonContainer.setPreferredW(334);
        if (cancelString == null) {
            this.okButton = UserInterface.createBigButton(okString);
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MessageBox.this.onOk();
                }
            });
            buttonContainer.setPreferredH(this.okButton.getPreferredH() + 5);
            buttonContainer.getStyle().setPadding(0, 10);
            buttonContainer.setLayout(new CoordinateLayout(buttonContainer.getPreferredW(), buttonContainer.getPreferredH()));
            buttonContainer.addComponent(this.okButton);
            this.okButton.setX((buttonContainer.getPreferredW() - this.okButton.getPreferredW()) / 2);
            this.okButton.setY(0);
        } else {
            this.okButton = UserInterface.createButton(okString);
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MessageBox.this.onOk();
                }
            });
            this.cancelButton = UserInterface.createButton(cancelString);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MessageBox.this.onCancel();
                }
            });
            buttonContainer.setPreferredH(this.okButton.getPreferredH() + 5);
            buttonContainer.setLayout(new BorderLayout());
            buttonContainer.addComponent("West", (Component)this.okButton);
            buttonContainer.addComponent("East", (Component)this.cancelButton);
            buttonContainer.getStyle().setPadding(5, 0, 10, 10);
        }
        this.msgContainer = new Container(new BoxLayout(2));
        this.content = new Container(new BoxLayout(2));
        this.content.addComponent(this.msgContainer);
        this.content.addComponent(buttonContainer);
        this.mainContainer = new ContentContainer(this.content, 0, 0);
        this.addComponent(this.mainContainer);
    }

    private void setMsg(String msg, Font msgFont) {
        this.msgContainer.removeAll();
        Vector msgStrings = Methods.splitString(msg, msgFont, 0, 339, "\r\n");
        String[] msgStrings2 = new String[Math.min(15, msgStrings.size()) + (15 < msgStrings.size() ? 1 : 0)];
        int i = 0;
        while (i < msgStrings2.length) {
            msgStrings2[i] = (String)msgStrings.elementAt(i);
            ++i;
        }
        if (15 < msgStrings.size()) {
            msgStrings2[15] = String.valueOf(msgStrings2[15].substring(0, msgStrings2[15].length() - 4)) + "...";
        }
        LabelGroup msgGroup = new LabelGroup(msgStrings2, msgFont, 6453130, 344, 33);
        msgGroup.setAlignment(msgStrings.size() > 1 ? 1 : 4);
        this.msgContainer.addComponent(msgGroup);
        this.mainContainer.setCenterHeight(this.content.getPreferredH());
    }

    private void setButtonTitle(String okString, String cancelString) {
        if (this.okButton != null) {
            this.okButton.setText(okString);
        }
        if (this.cancelButton != null) {
            this.cancelButton.setText(cancelString);
        }
    }

    private void onOk() {
        this.result = OK;
        isShow = false;
        this.dispose();
        Display.getInstance().getCurrent().repaint();
    }

    private void onCancel() {
        this.result = CANCEL;
        isShow = false;
        this.dispose();
        Display.getInstance().getCurrent().repaint();
    }
}

