/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.Main;
import com.nuomi.clientinfo.UserInfo;
import com.nuomi.connect.DataDownload;
import com.nuomi.data.ResultInfo;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.LogPage;
import com.nuomi.usercontrol.Button;
import com.nuomi.usercontrol.ContentContainer;
import com.nuomi.usercontrol.TextBox;
import com.nuomi.utils.Methods;
import com.nuomi.utils.PhoneFunction;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BoxLayout;
import java.util.Timer;
import java.util.TimerTask;

public class ActivePage
extends BasePage {
    private static ActivePage _ActivePage = null;
    private final int TOP_MARGIN;
    private TextBox phoneTextBox = null;
    private Button resendCodeButton = null;
    private Label hintLabel = null;
    private TextBox codeTextBox = null;
    private Button activeButton = null;
    private final int MAX_REMAIN_TIME;
    private DataDownload resendDownload = null;
    private DataDownload activeDownload = null;
    private DataDownloadListener resendCodeListener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            ActivePage.this.startRefresh();
            ActivePage.this.showRefreshIcon();
            ActivePage.this.setConnecting(true);
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            String hintString = DataDownload.ResultStrings[result];
            boolean showHint = true;
            if (result == 2 && data instanceof ResultInfo) {
                ResultInfo resultInfo = (ResultInfo)data;
                if (resultInfo.isSucceed()) {
                    ActivePage.this.startTimer();
                    hintString = "\u9a8c\u8bc1\u7801\u83b7\u53d6\u6210\u529f\uff0c\u8bf7\u6ce8\u610f\u67e5\u6536";
                } else if (resultInfo.isLogExpired()) {
                    if (Display.getInstance().getCurrent() == ActivePage.this.self) {
                        if (ActivePage.this.getCurrentForm() == ActivePage.this.self && !MessageBox.isShow && MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                            LogPage.Show(ActivePage.this.self, true);
                        }
                        showHint = false;
                    }
                } else {
                    hintString = resultInfo.msg;
                }
            }
            if (ActivePage.this.activeDownload == null || !ActivePage.this.activeDownload.isDownloading()) {
                ActivePage.this.hideRefreshIcon();
                ActivePage.this.endRefresh();
            }
            if (showHint) {
                ActivePage.this.showHint(hintString);
            }
            ActivePage.this.setConnecting(false);
            ActivePage.this.repaint();
        }
    };
    private DataDownloadListener activeListener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            ActivePage.this.setConnecting(true);
            ActivePage.this.startRefresh();
            ActivePage.this.showRefreshIcon();
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            String hintString = DataDownload.ResultStrings[result];
            boolean showHint = true;
            if (result == 2 && data instanceof ResultInfo) {
                ResultInfo resultInfo = (ResultInfo)data;
                if (resultInfo.isSucceed()) {
                    UserInfo userInfo = UserInfo.copy(BasePage.clientInfo.getUserInfo());
                    if (userInfo != null) {
                        userInfo.actived = new Boolean(true);
                        if (PhoneFunction.isPhoneNumber(userInfo.userName)) {
                            userInfo.phone = userInfo.userName;
                        }
                    }
                    BasePage.clientInfo.setUserInfo(userInfo);
                    ActivePage.this.onBack();
                } else if (resultInfo.isLogExpired()) {
                    if (Display.getInstance().getCurrent() == ActivePage.this.self) {
                        if (ActivePage.this.getCurrentForm() == ActivePage.this.self && !MessageBox.isShow && MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                            LogPage.Show(ActivePage.this.self, true);
                        }
                        showHint = false;
                    }
                } else {
                    hintString = resultInfo.msg;
                }
            }
            if (ActivePage.this.resendDownload == null || !ActivePage.this.resendDownload.isDownloading()) {
                ActivePage.this.hideRefreshIcon();
                ActivePage.this.endRefresh();
            }
            if (showHint) {
                ActivePage.this.showHint(hintString);
            }
            ActivePage.this.setConnecting(false);
            ActivePage.this.repaint();
        }
    };

    public static void Show(BasePage parentPage, boolean startTimer) {
        String username = Main.clientInfo.getLoginInfo().userName;
        if (PhoneFunction.isPhoneNumber(username)) {
            if (_ActivePage == null) {
                _ActivePage = new ActivePage();
            } else {
                ActivePage._ActivePage.phoneTextBox.setText(username);
                ActivePage._ActivePage.codeTextBox.setText(null);
            }
            if (startTimer) {
                ActivePage._ActivePage.resendCodeButton.setEnabled(false);
                _ActivePage.startTimer();
            }
            _ActivePage.setParent(parentPage);
            _ActivePage.show();
        } else {
            if (!MessageBox.isShow) {
                MessageBox.Show("\u975e\u624b\u673a\u8d26\u53f7\u8bf7\u5230\u7f51\u7ad9\u6fc0\u6d3b", "\u786e\u5b9a", null);
            }
            if (parentPage instanceof LogPage) {
                parentPage.onBack();
            }
        }
    }

    public static void Show(BasePage parentPage) {
        ActivePage.Show(parentPage, false);
    }

    private ActivePage() {
        this.TOP_MARGIN = 20;
        this.MAX_REMAIN_TIME = 20;
        this.self.setTitle("\u6fc0\u6d3b");
        this.hideRefreshIcon();
        this.mainContainer.setLayout(new BoxLayout(2));
        Container content = new Container(new BoxLayout(2));
        this.phoneTextBox = new TextBox();
        content.addComponent(this.phoneTextBox);
        this.phoneTextBox.setText(BasePage.clientInfo.getLoginInfo().userName);
        this.phoneTextBox.setEnabled(false);
        Container resendContainer = new Container(new BoxLayout(1));
        content.addComponent(resendContainer);
        resendContainer.getStyle().setMargin(0, 20);
        this.resendCodeButton = UserInterface.createButton("\u83b7\u53d6\u9a8c\u8bc1\u7801");
        resendContainer.addComponent(this.resendCodeButton);
        this.resendCodeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActivePage.this.onResendCode();
            }
        });
        this.hintLabel = new Label("20\u79d2\u540e\u53ef\u91cd\u65b0\u83b7\u53d6");
        resendContainer.addComponent(this.hintLabel);
        this.hintLabel.getStyle().setFont(UserInterface.FONT_SMALL);
        this.hintLabel.setVisible(false);
        this.codeTextBox = new TextBox(2);
        content.addComponent(this.codeTextBox);
        this.codeTextBox.setHint("\u8f93\u5165\u9a8c\u8bc1\u7801");
        this.codeTextBox.getStyle().setMargin(0, 20);
        Container activeContainer = new Container(new BoxLayout(1));
        content.addComponent(activeContainer);
        activeContainer.getStyle().setMargin(0, 20);
        this.activeButton = UserInterface.createButton("\u6fc0\u6d3b");
        activeContainer.addComponent(this.activeButton);
        this.activeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActivePage.this.onActive();
            }
        });
        ContentContainer contentContainer = new ContentContainer(content, 20, 20);
        this.mainContainer.addComponent(contentContainer);
        contentContainer.getStyle().setMargin(0, 5);
    }

    protected void onBack() {
        if (this.parentPage instanceof LogPage) {
            this.parentPage.onBack();
        } else {
            super.onBack();
        }
    }

    private void onResendCode() {
        UserInfo userInfo = BasePage.clientInfo.getUserInfo();
        if (userInfo != null) {
            if (this.resendDownload == null) {
                this.resendDownload = new DataDownload();
                this.resendDownload.addDownloadListener(this.resendCodeListener);
            }
            this.resendDownload.resendCode(userInfo.userId, userInfo.ticket);
        }
    }

    private void onActive() {
        String code = this.codeTextBox.getText().trim();
        if (Methods.isNullOrEmpty(code)) {
            this.showHint("\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801");
            return;
        }
        UserInfo userInfo = BasePage.clientInfo.getUserInfo();
        if (userInfo != null) {
            if (this.activeDownload == null) {
                this.activeDownload = new DataDownload();
                this.activeDownload.addDownloadListener(this.activeListener);
            }
            this.activeDownload.active(userInfo.userId, userInfo.ticket, code);
        }
    }

    private void startTimer() {
        this.hintLabel.setText("20\u79d2\u540e\u53ef\u91cd\u65b0\u83b7\u53d6");
        this.hintLabel.setVisible(true);
        this.repaint();
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            public void run() {
                ActivePage.this.hintLabel.setVisible(false);
                if (!ActivePage.this.isRefreshing) {
                    ActivePage.this.resendCodeButton.setEnabled(true);
                }
                ActivePage.this.repaint();
            }
        }, 20000L);
    }

    private void setConnecting(boolean isConnecting) {
        if (!this.hintLabel.isVisible()) {
            this.resendCodeButton.setEnabled(!isConnecting);
        }
        this.codeTextBox.setEnabled(!isConnecting);
        this.activeButton.setEnabled(!isConnecting);
    }
}

