/*
 * Decompiled with CFR 0.152.
 */
package com.nuomi.pages;

import com.nuomi.clientinfo.UserInfo;
import com.nuomi.connect.DataDownload;
import com.nuomi.data.GetAddresses;
import com.nuomi.data.PostAddress;
import com.nuomi.dialogs.MessageBox;
import com.nuomi.listener.DataDownloadListener;
import com.nuomi.pages.BasePage;
import com.nuomi.pages.LogPage;
import com.nuomi.usercontrol.LabelGroup;
import com.nuomi.usercontrol.ListBox;
import com.nuomi.usercontrol.addressespage.AddressListBoxItem;
import com.nuomi.utils.UserImages;
import com.nuomi.utils.UserInterface;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Label;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.CoordinateLayout;

public class AddressesPage
extends BasePage {
    private static AddressesPage _AddressPage = null;
    private Container scrollContainer = null;
    private Label nuomiLogoLabel = null;
    private ListBox addressesListBox = null;
    private boolean userChanged = true;
    private boolean showByHideMessageBox = false;
    private DataDownloadListener listener = new DataDownloadListener(){

        public void onDownloadStart(Object tag) {
            AddressesPage.this.startRefresh();
        }

        public void onDownloadCompleted(int result, Object data, int type, Object tag) {
            String hintText = DataDownload.ResultStrings[result];
            boolean showHint = true;
            if (result == 2 && type == 8 && data instanceof GetAddresses) {
                GetAddresses addresses = (GetAddresses)data;
                if (addresses.result.succ == null) {
                    if (addresses.addresses == null) {
                        if (Display.getInstance().getCurrent() == AddressesPage.this.self && AddressesPage.this.getCurrentForm() == AddressesPage.this.self && !MessageBox.isShow) {
                            if (MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                                LogPage.Show(AddressesPage.this.self, true);
                            } else {
                                AddressesPage.this.showByHideMessageBox = true;
                                AddressesPage.this.userChanged = true;
                                showHint = false;
                            }
                        }
                    } else {
                        BasePage.clientInfo.setAddresses(addresses);
                        AddressesPage.this.showAddresses(addresses);
                    }
                } else if (addresses.result.isSucceed()) {
                    BasePage.clientInfo.setAddresses(addresses);
                    AddressesPage.this.showAddresses(addresses);
                } else if (Display.getInstance().getCurrent() == AddressesPage.this.self && AddressesPage.this.getCurrentForm() == AddressesPage.this.self && !MessageBox.isShow) {
                    if (MessageBox.Show("\u60a8\u7684\u767b\u5f55\u4fe1\u606f\u5df2\u8fc7\u671f", "\u91cd\u65b0\u767b\u5f55", "\u53d6\u6d88") == MessageBox.OK) {
                        LogPage.Show(AddressesPage.this.self, true);
                    } else {
                        AddressesPage.this.showByHideMessageBox = true;
                        AddressesPage.this.userChanged = true;
                        showHint = false;
                    }
                }
            }
            if (showHint) {
                AddressesPage.this.showHint(hintText);
            }
            AddressesPage.this.endRefresh();
        }
    };

    public static void Show(BasePage parentPage) {
        if (_AddressPage == null) {
            _AddressPage = new AddressesPage();
        }
        _AddressPage.setParent(parentPage);
        _AddressPage.show();
    }

    private AddressesPage() {
        this.self.setTitle("\u6211\u7684\u5730\u5740");
        this.mainContainer.setLayout(new CoordinateLayout(this.mainContainer.getPreferredW(), this.mainContainer.getPreferredH()));
        Container titleContainer = new Container();
        this.mainContainer.addComponent(titleContainer);
        titleContainer.getStyle().setBgImage(UserImages.NUOMI_TITLE_BG_2LINE_IMAGE);
        titleContainer.setX(0);
        titleContainer.setY(0);
        String[] titleStrings = new String[]{"\u5df2\u6dfb\u52a0\u7684\u5730\u5740(\u6bcf\u4e2a\u8d26\u53f7\u53ea\u652f\u6301\u6dfb\u52a0", "10\u4e2a\u5730\u5740)"};
        LabelGroup titleGroup = new LabelGroup(titleStrings, UserInterface.FONT_STATIC_WORD, 0xFFFFFF, 30);
        titleGroup.setX(5);
        titleGroup.setY(5);
        titleContainer.addComponent(titleGroup);
        titleContainer.setPreferredW(UserInterface.DISPLAY_WIDTH);
        titleContainer.setPreferredH(titleGroup.getPreferredH() + 10);
        titleContainer.setLayout(new CoordinateLayout(titleContainer.getPreferredW(), titleContainer.getPreferredH()));
        this.nuomiLogoLabel = UserInterface.createNuomiLogoLabel();
        this.mainContainer.addComponent(this.nuomiLogoLabel);
        this.nuomiLogoLabel.setX((UserInterface.DISPLAY_WIDTH - this.nuomiLogoLabel.getPreferredW()) / 2);
        this.nuomiLogoLabel.setY((UserInterface.DISPLAY_HEIGHT - titleContainer.getPreferredH() - this.nuomiLogoLabel.getPreferredH()) / 2);
        this.scrollContainer = new Container(new CoordinateLayout(this.mainContainer.getPreferredW(), this.mainContainer.getPreferredH() - titleContainer.getPreferredH()));
        this.mainContainer.addComponent(this.scrollContainer);
        this.scrollContainer.setPreferredW(this.mainContainer.getPreferredW());
        this.scrollContainer.setPreferredH(this.mainContainer.getPreferredH() - titleContainer.getPreferredH());
        this.scrollContainer.setX(0);
        this.scrollContainer.setY(titleContainer.getPreferredH());
        this.scrollContainer.setScrollableY(true);
        Container innerContainer = new Container(new BoxLayout(2));
        this.scrollContainer.addComponent(innerContainer);
        innerContainer.setX(0);
        innerContainer.setY(0);
        this.addressesListBox = new ListBox();
        innerContainer.addComponent(this.addressesListBox);
    }

    protected void onShowCompleted() {
        if (!this.showByHideMessageBox) {
            if (BasePage.clientInfo.getAddresses() == null || this.userChanged) {
                if (!this.mainContainer.contains(this.nuomiLogoLabel)) {
                    this.mainContainer.addComponent(this.nuomiLogoLabel);
                }
                this.addressesListBox.removeAll();
                this.onRefresh();
            } else {
                if (this.mainContainer.contains(this.nuomiLogoLabel)) {
                    this.mainContainer.removeComponent(this.nuomiLogoLabel);
                }
                this.showAddresses(BasePage.clientInfo.getAddresses());
            }
            this.userChanged = false;
        }
        this.showByHideMessageBox = false;
        super.onShowCompleted();
    }

    protected void onRefreshClicked() {
        this.onRefresh();
    }

    private void onRefresh() {
        DataDownload dataDownload = new DataDownload();
        dataDownload.addDownloadListener(this.listener);
        if (BasePage.clientInfo.getUserInfo() != null) {
            dataDownload.getAddresses(BasePage.clientInfo.getUserInfo().userId, BasePage.clientInfo.getUserInfo().ticket);
        }
    }

    protected void onUserInfoChanged(UserInfo newUserInfo) {
        this.userChanged = true;
    }

    private void showAddresses(GetAddresses addresses) {
        if (addresses == null) {
            return;
        }
        if (this.mainContainer.contains(this.nuomiLogoLabel)) {
            this.mainContainer.removeComponent(this.nuomiLogoLabel);
        }
        this.addressesListBox.removeAll();
        if (addresses.addresses != null) {
            int i = 0;
            while (i < addresses.addresses.size()) {
                AddressListBoxItem item = new AddressListBoxItem((PostAddress)addresses.addresses.elementAt(i));
                this.addressesListBox.addItem(item);
                ++i;
            }
        }
        if (this.addressesListBox.getCount() <= 0) {
            this.addressesListBox.showHint("\u60a8\u6682\u65f6\u672a\u6dfb\u52a0\u4efb\u4f55\u5730\u5740\u4fe1\u606f");
        }
        this.scrollContainer.setScrollY(0);
        this.scrollContainer.setScrollableY(this.scrollContainer.getScrollDimension().getHeight() > this.scrollContainer.getPreferredH());
        this.repaint();
    }
}

